/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.resource.loader.impl;

import com.alibaba.citrus.service.resource.loader.FileResourceLoader;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileResourceLoaderDefinitionParser
extends AbstractSingleBeanDefinitionParser<FileResourceLoader> {
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        URL configFileURL;
        SpringExtUtil.attributesToProperties(element, builder, "basedir");
        try {
            configFileURL = parserContext.getReaderContext().getResource().getURL();
        }
        catch (IOException e) {
            configFileURL = null;
        }
        if (configFileURL != null) {
            builder.addPropertyValue("configFileURL", (Object)configFileURL);
        }
        DomUtil.ElementSelector pathSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("path"));
        List<Object> paths = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element, pathSelector)) {
            paths.add(this.parsePath(subElement, parserContext));
        }
        builder.addPropertyValue("paths", paths);
    }

    private BeanDefinition parsePath(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(FileResourceLoader.SearchPath.class);
        String type = ObjectUtil.defaultIfNull(StringUtil.trimToNull(element.getAttribute("type")), "relative");
        String path = StringUtil.trimToEmpty(element.getTextContent());
        builder.addConstructorArgValue((Object)path);
        builder.addConstructorArgValue((Object)"relative".equals(type));
        return builder.getBeanDefinition();
    }
}

