/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.ast.statement;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLExplainStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class MySqlExplainStatement
extends SQLExplainStatement
implements MySqlStatement {
    private boolean describe;
    private SQLName tableName;
    private SQLName columnName;
    private SQLExpr wild;
    private SQLExpr connectionId;
    private boolean distributeInfo = false;

    public MySqlExplainStatement() {
        super(DbType.mysql);
    }

    public MySqlExplainStatement(DbType dbType) {
        super(dbType);
    }

    @Override
    public void accept0(MySqlASTVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.tableName != null) {
                this.tableName.accept(visitor);
                if (this.columnName != null) {
                    this.columnName.accept(visitor);
                } else if (this.wild != null) {
                    this.wild.accept(visitor);
                }
            } else if (this.connectionId != null) {
                this.connectionId.accept(visitor);
            } else if (this.statement != null) {
                this.statement.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor instanceof MySqlASTVisitor) {
            this.accept0((MySqlASTVisitor)visitor);
        } else {
            super.accept0(visitor);
        }
    }

    @Override
    public String toString() {
        return SQLUtils.toMySqlString(this);
    }

    public boolean isDescribe() {
        return this.describe;
    }

    public void setDescribe(boolean describe) {
        this.describe = describe;
    }

    public SQLName getTableName() {
        return this.tableName;
    }

    public void setTableName(SQLName tableName) {
        this.tableName = tableName;
    }

    public SQLName getColumnName() {
        return this.columnName;
    }

    public void setColumnName(SQLName columnName) {
        this.columnName = columnName;
    }

    public SQLExpr getWild() {
        return this.wild;
    }

    public void setWild(SQLExpr wild) {
        this.wild = wild;
    }

    public SQLExpr getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(SQLExpr connectionId) {
        this.connectionId = connectionId;
    }

    public boolean isDistributeInfo() {
        return this.distributeInfo;
    }

    public void setDistributeInfo(boolean distributeInfo) {
        this.distributeInfo = distributeInfo;
    }
}

