/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher;

import java.util.ArrayList;
import java.util.List;

public class SearchResult<T> {
    private Number totalCount;
    private final List<T> dataList;
    private Number[] summaries;

    public SearchResult() {
        this(0, new Number[0]);
    }

    public SearchResult(Number totalCount) {
        this(totalCount, new Number[0]);
    }

    public SearchResult(Number totalCount, Number[] summaries) {
        this(new ArrayList());
        this.totalCount = totalCount;
        this.summaries = summaries;
    }

    public SearchResult(List<T> dataList) {
        this.dataList = dataList;
    }

    public Number getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Number totalCount) {
        this.totalCount = totalCount;
    }

    public List<T> getDataList() {
        return this.dataList;
    }

    public void addData(T data) {
        this.dataList.add(data);
    }

    public Number[] getSummaries() {
        return this.summaries;
    }

    public void setSummaries(Number[] summaries) {
        if (summaries != null) {
            for (int i = 0; i < summaries.length; ++i) {
                if (summaries[i] != null) continue;
                summaries[i] = 0;
            }
            this.summaries = summaries;
        } else {
            this.summaries = new Number[0];
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder("totalCount = " + this.totalCount + "\n");
        for (T data : this.dataList) {
            str.append("\t").append(data.toString());
        }
        return str.toString();
    }
}

