/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher;

import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.SearchSql;
import java.io.Closeable;
import java.sql.SQLException;

public class SqlResult<T>
implements Closeable {
    private final SearchSql<T> searchSql;
    private final ResultSet listResult;
    private final Result clusterResult;

    public SqlResult(SearchSql<T> searchSql) {
        this(searchSql, null, null);
    }

    public SqlResult(SearchSql<T> searchSql, ResultSet listResult, Result clusterResult) {
        this.searchSql = searchSql;
        this.listResult = listResult;
        this.clusterResult = clusterResult;
    }

    @Override
    public void close() {
        try {
            if (this.listResult != null) {
                this.listResult.close();
            }
            if (this.clusterResult != null) {
                this.clusterResult.close();
            }
        }
        catch (SQLException e) {
            throw new SearchException("Can not close result or resultSet!", e);
        }
    }

    public SearchSql<T> getSearchSql() {
        return this.searchSql;
    }

    public ResultSet getListResult() {
        return this.listResult;
    }

    public Result getClusterResult() {
        return this.clusterResult;
    }

    public static interface ResultSet
    extends Result {
        public boolean next() throws SQLException;
    }

    public static interface Result {
        public Object get(String var1) throws SQLException;

        default public void close() throws SQLException {
        }
    }
}

