/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.group;

import com.ejlchina.searcher.group.DefaultParserFactory;
import com.ejlchina.searcher.group.ExprParser;
import com.ejlchina.searcher.group.Group;
import com.ejlchina.searcher.group.GroupResolver;
import com.ejlchina.searcher.util.LRUCache;
import com.ejlchina.searcher.util.StringUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGroupResolver
implements GroupResolver {
    static final Logger log = LoggerFactory.getLogger(DefaultGroupResolver.class);
    static final Group<String> DEFAULT_RAW_GROUP = new Group(3);
    private final Object lock = new Object();
    private LRUCache<Group<String>> cache = new LRUCache(50);
    private boolean enabled = true;
    private ExprParser.Factory parserFactory = new DefaultParserFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group<String> resolve(String gExpr) {
        if (this.enabled) {
            Group<String> group;
            Object object = this.lock;
            synchronized (object) {
                group = (Group<String>)this.cache.get(gExpr);
            }
            if (group == null) {
                group = this.doResolve(gExpr);
                object = this.lock;
                synchronized (object) {
                    this.cache.put(gExpr, group);
                }
            }
            return group;
        }
        return DEFAULT_RAW_GROUP;
    }

    protected Group<String> doResolve(String expr) {
        if (StringUtils.isBlank(expr)) {
            return DEFAULT_RAW_GROUP;
        }
        try {
            return this.parserFactory.create(expr).parse();
        }
        catch (Exception e) {
            log.warn("can not parse expr: [{}], fallback to DEFAULT_RAW_GROUP", (Object)expr);
            return DEFAULT_RAW_GROUP;
        }
    }

    public ExprParser.Factory getParserFactory() {
        return this.parserFactory;
    }

    public void setParserFactory(ExprParser.Factory parserFactory) {
        this.parserFactory = parserFactory;
    }

    public LRUCache<Group<String>> getCache() {
        return this.cache;
    }

    public void setCache(LRUCache<Group<String>> cache) {
        this.cache = Objects.requireNonNull(cache);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

