/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.PageExtractor;
import com.ejlchina.searcher.param.Paging;
import com.ejlchina.searcher.util.ObjectUtils;
import java.util.Map;

public abstract class BasePageExtractor
implements PageExtractor {
    private int start = 0;
    private String sizeName = "size";
    private int maxAllowedSize = 100;
    private int defaultSize = 15;

    @Override
    public Paging extract(Map<String, Object> paraMap) {
        int size = this.toSize(paraMap.get(this.getSizeName()));
        return new Paging(size, this.toOffset(paraMap, size));
    }

    protected abstract long toOffset(Map<String, Object> var1, int var2);

    protected int toSize(Object value) {
        Integer size = ObjectUtils.toInt(value);
        if (size == null) {
            return this.defaultSize;
        }
        return Math.min(Math.max(size, 0), this.maxAllowedSize);
    }

    @Override
    public String getSizeName() {
        return this.sizeName;
    }

    public int getStart() {
        return this.start;
    }

    public void setSizeName(String sizeName) {
        this.sizeName = sizeName;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setMaxAllowedSize(int maxAllowedSize) {
        this.maxAllowedSize = maxAllowedSize;
    }

    public int getMaxAllowedSize() {
        return this.maxAllowedSize;
    }

    public int getDefaultSize() {
        return this.defaultSize;
    }

    public void setDefaultSize(int defaultSize) {
        this.defaultSize = defaultSize;
    }
}

