/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.FieldConvertor;
import com.ejlchina.searcher.FieldMeta;
import java.util.Arrays;
import java.util.Objects;

public class BoolFieldConvertor
implements FieldConvertor.BFieldConvertor {
    private String[] falseValues = new String[]{"0", "OFF", "FALSE", "N", "NO", "F"};

    @Override
    public boolean supports(FieldMeta meta, Class<?> valueType) {
        if (Boolean.class == valueType || String.class == valueType || Number.class.isAssignableFrom(valueType)) {
            Class<?> targetType = meta.getType();
            return targetType == Boolean.TYPE || targetType == Boolean.class;
        }
        return false;
    }

    @Override
    public Object convert(FieldMeta meta, Object value) {
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof String) {
            String bool = (String)value;
            for (String t : this.falseValues) {
                if (!t.equalsIgnoreCase(bool)) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return ((Number)value).intValue() != 0;
    }

    public String[] getFalseValues() {
        return this.falseValues;
    }

    public void setFalseValues(String[] falseValues) {
        this.falseValues = Objects.requireNonNull(falseValues);
    }

    public void addFalseValues(String[] falseValues) {
        int newLength = falseValues.length + this.falseValues.length;
        this.falseValues = Arrays.copyOf(this.falseValues, newLength);
        System.arraycopy(falseValues, 0, this.falseValues, this.falseValues.length, falseValues.length);
    }
}

