/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.DbMapping;
import com.ejlchina.searcher.FieldOp;
import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.bean.DbField;
import com.ejlchina.searcher.bean.DbIgnore;
import com.ejlchina.searcher.bean.InheritType;
import com.ejlchina.searcher.bean.SearchBean;
import com.ejlchina.searcher.bean.SortType;
import com.ejlchina.searcher.util.StringUtils;
import java.lang.reflect.Field;
import java.util.Objects;

public class DefaultDbMapping
implements DbMapping {
    private static final Class<FieldOp>[] EMPTY_OPERATORS = new Class[0];
    private String tablePrefix;
    private boolean upperCase = false;
    private InheritType defaultInheritType = InheritType.ALL;
    private SortType defaultSortType = SortType.ALLOW_PARAM;
    private String[] redundantSuffixes;
    private String[] ignoreFields;

    @Override
    public InheritType inheritType(Class<?> beanClass) {
        InheritType iType;
        SearchBean bean = this.getSearchBean(beanClass);
        if (bean != null && (iType = bean.inheritType()) != InheritType.DEFAULT) {
            return iType;
        }
        return this.defaultInheritType;
    }

    @Override
    public DbMapping.Table table(Class<?> beanClass) {
        SearchBean bean = this.getSearchBean(beanClass);
        if (bean != null) {
            return new DbMapping.Table(bean.dataSource().trim(), this.tables(beanClass, bean), bean.joinCond().trim(), bean.groupBy().trim(), bean.distinct(), bean.orderBy(), this.sortable(bean.sortType()));
        }
        return new DbMapping.Table(this.toTableName(beanClass));
    }

    protected boolean sortable(SortType sortType) {
        if (sortType == SortType.ALLOW_PARAM) {
            return true;
        }
        if (sortType == SortType.ONLY_ENTITY) {
            return false;
        }
        return this.defaultSortType == SortType.ALLOW_PARAM;
    }

    @Override
    public DbMapping.Column column(Class<?> beanClass, Field field) {
        String fieldSql = this.dbFieldSql(beanClass, field);
        if (fieldSql == null) {
            return null;
        }
        DbField dbField = field.getAnnotation(DbField.class);
        if (dbField != null) {
            return new DbMapping.Column(fieldSql, dbField.conditional(), dbField.onlyOn(), dbField.alias());
        }
        return new DbMapping.Column(fieldSql, true, EMPTY_OPERATORS);
    }

    protected SearchBean getSearchBean(Class<?> beanClass) {
        while (beanClass != Object.class) {
            SearchBean bean = beanClass.getAnnotation(SearchBean.class);
            if (bean != null) {
                return bean;
            }
            if (this.defaultInheritType != InheritType.TABLE && this.defaultInheritType != InheritType.ALL) break;
            beanClass = beanClass.getSuperclass();
        }
        return null;
    }

    protected String tables(Class<?> beanClass, SearchBean bean) {
        String tables = bean.tables();
        if (StringUtils.isBlank(tables)) {
            return this.toTableName(beanClass);
        }
        return tables.trim();
    }

    protected String toTableName(Class<?> beanClass) {
        String name = this.simplify(beanClass.getSimpleName());
        String tables = StringUtils.toUnderline(name);
        if (this.upperCase) {
            tables = tables.toUpperCase();
        }
        if (this.tablePrefix != null) {
            return this.tablePrefix + tables;
        }
        return tables;
    }

    protected String simplify(String clazzName) {
        if (this.redundantSuffixes != null) {
            int length = clazzName.length();
            for (String suffix : this.redundantSuffixes) {
                if (length <= suffix.length() || !clazzName.endsWith(suffix)) continue;
                return clazzName.substring(0, length - suffix.length());
            }
        }
        return clazzName;
    }

    protected String dbFieldSql(Class<?> beanClass, Field field) {
        DbField dbField = field.getAnnotation(DbField.class);
        if (field.getAnnotation(DbIgnore.class) != null) {
            if (dbField == null) {
                return null;
            }
            throw new SearchException("[" + beanClass.getName() + ": " + field.getName() + "] is annotated by @DbField and @DbIgnore, which are mutually exclusive.");
        }
        SearchBean bean = this.getSearchBean(beanClass);
        if (bean != null && this.shouldIgnore(field, bean.ignoreFields())) {
            if (dbField == null) {
                return null;
            }
            int res = this.compareFieldToBeanAnnotation(field, beanClass);
            if (res == 0) {
                throw new SearchException("[" + beanClass.getName() + ": " + field.getName() + "] is annotated by @DbField and listed by @SearchBean.ignoreFields in same class, which are mutually exclusive.");
            }
            if (res > 0) {
                return null;
            }
        }
        if (dbField != null) {
            String fieldSql = dbField.value().trim();
            if (StringUtils.isNotBlank(fieldSql)) {
                if (fieldSql.toLowerCase().startsWith("select ")) {
                    return "(" + fieldSql + ")";
                }
                return fieldSql;
            }
        } else if (this.shouldIgnore(field, this.ignoreFields)) {
            return null;
        }
        if (bean == null || StringUtils.isBlank(bean.tables())) {
            return this.toColumnName(field);
        }
        String tab = bean.autoMapTo();
        if (StringUtils.isBlank(tab)) {
            return null;
        }
        return tab.trim() + "." + this.toColumnName(field);
    }

    protected int compareFieldToBeanAnnotation(Field field, Class<?> beanClass) {
        int fieldLevel = 0;
        int beanLevel = 0;
        Class<?> clazz = beanClass;
        while (clazz != field.getDeclaringClass() && clazz != Object.class) {
            clazz = clazz.getSuperclass();
            ++fieldLevel;
        }
        clazz = beanClass;
        while (clazz.getAnnotation(SearchBean.class) == null && clazz != Object.class) {
            clazz = clazz.getSuperclass();
            ++beanLevel;
        }
        return fieldLevel - beanLevel;
    }

    protected boolean shouldIgnore(Field field, String[] ignoreFields) {
        if (ignoreFields != null) {
            for (String ignoreField : ignoreFields) {
                if (!field.getName().equals(ignoreField)) continue;
                return true;
            }
        }
        return false;
    }

    private String toColumnName(Field field) {
        String column = StringUtils.toUnderline(field.getName());
        return this.upperCase ? column.toUpperCase() : column;
    }

    public InheritType getDefaultInheritType() {
        return this.defaultInheritType;
    }

    public void setDefaultInheritType(InheritType inheritType) {
        this.defaultInheritType = Objects.requireNonNull(inheritType);
    }

    public SortType getDefaultSortType() {
        return this.defaultSortType;
    }

    public void setDefaultSortType(SortType defaultSortType) {
        this.defaultSortType = Objects.requireNonNull(defaultSortType);
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        if (StringUtils.isNotBlank(tablePrefix)) {
            this.tablePrefix = tablePrefix.trim();
        }
    }

    public boolean isUpperCase() {
        return this.upperCase;
    }

    public void setUpperCase(boolean upperCase) {
        this.upperCase = upperCase;
    }

    public String[] getRedundantSuffixes() {
        return this.redundantSuffixes;
    }

    public void setRedundantSuffixes(String[] redundantSuffixes) {
        this.redundantSuffixes = redundantSuffixes;
    }

    public String[] getIgnoreFields() {
        return this.ignoreFields;
    }

    public void setIgnoreFields(String[] ignoreFields) {
        this.ignoreFields = ignoreFields;
    }
}

