/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.BeanMeta;
import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.SearchSql;
import com.ejlchina.searcher.SqlExecutor;
import com.ejlchina.searcher.SqlResult;
import com.ejlchina.searcher.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSqlExecutor
implements SqlExecutor {
    protected Logger log = LoggerFactory.getLogger(DefaultSqlExecutor.class);
    private DataSource dataSource;
    private final Map<String, DataSource> dataSourceMap = new ConcurrentHashMap<String, DataSource>();
    private boolean transactional = false;
    private int transactionIsolation = 2;

    public DefaultSqlExecutor() {
    }

    public DefaultSqlExecutor(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public <T> SqlResult<T> execute(SearchSql<T> searchSql) {
        Connection connection;
        if (!searchSql.isShouldQueryList() && !searchSql.isShouldQueryCluster()) {
            return new SqlResult<T>(searchSql);
        }
        try {
            connection = this.getConnection(searchSql.getBeanMeta());
        }
        catch (SQLException e) {
            throw new SearchException("Can not get connection from dataSource!", e);
        }
        try {
            return this.doExecute(searchSql, connection);
        }
        catch (SQLException e) {
            this.closeConnection(connection);
            throw new SearchException("A exception occurred when query!", e);
        }
    }

    protected Connection getConnection(BeanMeta<?> beanMeta) throws SQLException {
        String name = beanMeta.getDataSource();
        if (StringUtils.isBlank(name)) {
            if (this.dataSource == null) {
                throw new SearchException("There is no default dataSource for " + beanMeta.getBeanClass());
            }
            return this.dataSource.getConnection();
        }
        DataSource dataSource = this.dataSourceMap.get(name);
        if (dataSource == null) {
            throw new SearchException("There is no dataSource named " + name + " for " + beanMeta.getBeanClass());
        }
        return dataSource.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> SqlResult<T> doExecute(SearchSql<T> searchSql, final Connection connection) throws SQLException {
        if (this.transactional) {
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(this.transactionIsolation);
            connection.setReadOnly(true);
        }
        SqlResult.ResultSet listResult = null;
        SqlResult.Result clusterResult = null;
        try {
            List<Object> params;
            String sql;
            if (searchSql.isShouldQueryList()) {
                sql = searchSql.getListSqlString();
                params = searchSql.getListSqlParams();
                this.writeLog(sql, params);
                listResult = this.executeListSql(connection, sql, params);
            }
            if (searchSql.isShouldQueryCluster()) {
                sql = searchSql.getClusterSqlString();
                params = searchSql.getClusterSqlParams();
                this.writeLog(sql, params);
                clusterResult = this.executeClusterSql(connection, sql, params);
            }
        }
        finally {
            if (this.transactional) {
                connection.commit();
                connection.setReadOnly(false);
            }
        }
        return new SqlResult<T>(searchSql, listResult, clusterResult){

            @Override
            public void close() {
                try {
                    super.close();
                }
                finally {
                    DefaultSqlExecutor.this.closeConnection(connection);
                }
            }
        };
    }

    protected void writeLog(String sql, List<Object> params) {
        this.log.debug("bean-searcher - sql ---- {}", (Object)sql);
        this.log.debug("bean-searcher - params - {}", params);
    }

    protected SqlResult.ResultSet executeListSql(Connection connection, String sql, List<Object> params) throws SQLException {
        final PreparedStatement statement = connection.prepareStatement(sql);
        this.setStatementParams(statement, params);
        final ResultSet resultSet = statement.executeQuery();
        return new SqlResult.ResultSet(){

            @Override
            public boolean next() throws SQLException {
                return resultSet.next();
            }

            @Override
            public Object get(String columnLabel) throws SQLException {
                return resultSet.getObject(columnLabel);
            }

            @Override
            public void close() throws SQLException {
                try {
                    resultSet.close();
                }
                finally {
                    statement.close();
                }
            }
        };
    }

    protected SqlResult.Result executeClusterSql(Connection connection, String sql, List<Object> params) throws SQLException {
        final PreparedStatement statement = connection.prepareStatement(sql);
        this.setStatementParams(statement, params);
        final ResultSet resultSet = statement.executeQuery();
        final boolean hasValue = resultSet.next();
        return new SqlResult.Result(){

            @Override
            public Object get(String columnLabel) throws SQLException {
                if (hasValue) {
                    return resultSet.getObject(columnLabel);
                }
                return null;
            }

            @Override
            public void close() throws SQLException {
                try {
                    resultSet.close();
                }
                finally {
                    statement.close();
                }
            }
        };
    }

    protected void setStatementParams(PreparedStatement statement, List<Object> params) throws SQLException {
        int size = params.size();
        for (int i = 0; i < size; ++i) {
            statement.setObject(i + 1, params.get(i));
        }
    }

    protected void closeConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            throw new SearchException("Can not close connection!", e);
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = Objects.requireNonNull(dataSource);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String name, DataSource dataSource) {
        if (name != null && dataSource != null) {
            this.dataSourceMap.put(name.trim(), dataSource);
        }
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(int level) {
        this.transactionIsolation = level;
    }
}

