/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.BeanMeta;
import com.ejlchina.searcher.FieldMeta;
import com.ejlchina.searcher.FieldOp;
import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.SearchParam;
import com.ejlchina.searcher.SearchSql;
import com.ejlchina.searcher.SqlResolver;
import com.ejlchina.searcher.SqlSnippet;
import com.ejlchina.searcher.SqlWrapper;
import com.ejlchina.searcher.dialect.Dialect;
import com.ejlchina.searcher.group.Group;
import com.ejlchina.searcher.implement.DateValueCorrector;
import com.ejlchina.searcher.implement.DialectWrapper;
import com.ejlchina.searcher.param.FetchType;
import com.ejlchina.searcher.param.FieldParam;
import com.ejlchina.searcher.param.OrderBy;
import com.ejlchina.searcher.param.Paging;
import com.ejlchina.searcher.util.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DefaultSqlResolver
extends DialectWrapper
implements SqlResolver {
    private DateValueCorrector dateValueCorrector = new DateValueCorrector();

    public DefaultSqlResolver() {
    }

    public DefaultSqlResolver(Dialect dialect, DateValueCorrector dateValueCorrector) {
        super(dialect);
        this.dateValueCorrector = dateValueCorrector;
    }

    @Override
    public <T> SearchSql<T> resolve(BeanMeta<T> beanMeta, SearchParam searchParam) {
        String[] summaryFields;
        List<String> fetchFields = searchParam.getFetchFields();
        FetchType fetchType = searchParam.getFetchType();
        SearchSql<T> searchSql = new SearchSql<T>(beanMeta, fetchFields);
        searchSql.setShouldQueryCluster(fetchType.shouldQueryCluster());
        searchSql.setShouldQueryList(fetchType.shouldQueryList());
        if (fetchType.shouldQueryTotal()) {
            searchSql.setCountAlias(this.getCountAlias(beanMeta));
        }
        for (String summaryField : summaryFields = fetchType.getSummaryFields()) {
            FieldMeta fieldMeta = beanMeta.getFieldMeta(summaryField);
            if (fieldMeta == null) {
                throw new SearchException("\u6c42\u548c\u5c5e\u6027\u3010" + summaryField + "\u3011\u6ca1\u6709\u548c\u6570\u636e\u5e93\u5b57\u6bb5\u505a\u6620\u5c04\uff0c\u8bf7\u68c0\u67e5\u8be5\u5c5e\u6027\u662f\u5426 \u5df2\u88ab\u5ffd\u7565 \u6216 \u662f\u5426\u5df2\u88ab @DbField \u6b63\u786e\u6ce8\u89e3\uff01");
            }
            searchSql.addSummaryAlias(this.getSummaryAlias(fieldMeta));
        }
        Map<String, Object> paraMap = searchParam.getParaMap();
        SqlWrapper<Object> fieldSelectSqlWrapper = this.buildFieldSelectSql(beanMeta, fetchFields, paraMap);
        SqlWrapper<Object> fromWhereSqlWrapper = this.buildFromWhereSql(beanMeta, searchParam.getParamsGroup(), paraMap);
        String fieldSelectSql = fieldSelectSqlWrapper.getSql();
        String fromWhereSql = fromWhereSqlWrapper.getSql();
        if (fetchType.shouldQueryTotal() || summaryFields.length > 0) {
            List<String> summaryAliases = searchSql.getSummaryAliases();
            String countAlias = searchSql.getCountAlias();
            SqlWrapper<Object> clusterSelectSql = this.buildClusterSelectSql(beanMeta, summaryFields, summaryAliases, countAlias, paraMap);
            String clusterSql = this.buildClusterSql(beanMeta, clusterSelectSql.getSql(), fieldSelectSql, fromWhereSql);
            searchSql.setClusterSqlString(clusterSql);
            searchSql.addClusterSqlParams(clusterSelectSql.getParas());
            if (beanMeta.isDistinctOrGroupBy()) {
                searchSql.addClusterSqlParams(fieldSelectSqlWrapper.getParas());
            }
            searchSql.addClusterSqlParams(fromWhereSqlWrapper.getParas());
        }
        if (fetchType.shouldQueryList()) {
            List<OrderBy> orderBys = searchParam.getOrderBys();
            Paging paging = searchParam.getPaging();
            SqlWrapper<Object> listSql = this.buildListSql(beanMeta, fieldSelectSql, fromWhereSql, orderBys, paging, fetchFields, paraMap);
            searchSql.setListSqlString(listSql.getSql());
            searchSql.addListSqlParams(fieldSelectSqlWrapper.getParas());
            searchSql.addListSqlParams(fromWhereSqlWrapper.getParas());
            searchSql.addListSqlParams(listSql.getParas());
        }
        return searchSql;
    }

    protected <T> SqlWrapper<Object> buildFieldSelectSql(BeanMeta<T> beanMeta, List<String> fetchFields, Map<String, Object> paraMap) {
        SqlWrapper<Object> sqlWrapper = new SqlWrapper<Object>();
        StringBuilder builder = new StringBuilder("select ");
        if (beanMeta.isDistinct()) {
            builder.append("distinct ");
        }
        int fieldCount = fetchFields.size();
        for (int i = 0; i < fieldCount; ++i) {
            String field = fetchFields.get(i);
            FieldMeta meta = beanMeta.requireFieldMeta(field);
            SqlWrapper<Object> dbFieldSql = this.resolveDbFieldSql(meta.getFieldSql(), paraMap);
            builder.append(dbFieldSql.getSql()).append(" ").append(meta.getDbAlias());
            if (i < fieldCount - 1) {
                builder.append(", ");
            }
            sqlWrapper.addParas(dbFieldSql.getParas());
        }
        sqlWrapper.setSql(builder.toString());
        return sqlWrapper;
    }

    protected <T> SqlWrapper<Object> buildClusterSelectSql(BeanMeta<T> beanMeta, String[] summaryFields, List<String> summaryAliases, String countAlias, Map<String, Object> paraMap) {
        StringBuilder builder = new StringBuilder("select ");
        if (countAlias != null) {
            builder.append("count(*) ").append(countAlias);
            if (summaryFields.length > 0) {
                builder.append(", ");
            }
        }
        SqlWrapper<Object> sqlWrapper = new SqlWrapper<Object>();
        boolean distinctOrGroupBy = beanMeta.isDistinctOrGroupBy();
        for (int i = 0; i < summaryFields.length; ++i) {
            FieldMeta fieldMeta = beanMeta.requireFieldMeta(summaryFields[i]);
            builder.append("sum(");
            if (distinctOrGroupBy) {
                builder.append(fieldMeta.getDbAlias());
            } else {
                SqlWrapper<Object> fieldSql = this.resolveDbFieldSql(fieldMeta.getFieldSql(), paraMap);
                builder.append(fieldSql.getSql());
                sqlWrapper.addParas(fieldSql.getParas());
            }
            builder.append(") ").append(summaryAliases.get(i));
            if (i >= summaryFields.length - 1) continue;
            builder.append(", ");
        }
        sqlWrapper.setSql(builder.toString());
        return sqlWrapper;
    }

    protected <T> SqlWrapper<Object> buildFromWhereSql(BeanMeta<T> beanMeta, Group<List<FieldParam>> paramsGroup, Map<String, Object> paraMap) {
        SqlWrapper<Object> sqlWrapper = new SqlWrapper<Object>();
        SqlWrapper<Object> tableSql = this.resolveTableSql(beanMeta.getTableSnippet(), paraMap);
        sqlWrapper.addParas(tableSql.getParas());
        StringBuilder builder = new StringBuilder(" from ").append(tableSql.getSql());
        String joinCond = beanMeta.getJoinCond();
        if (StringUtils.isNotBlank(joinCond)) {
            List<SqlSnippet.SqlPara> joinCondParams = beanMeta.getJoinCondSqlParas();
            for (SqlSnippet.SqlPara param : joinCondParams) {
                Object sqlParam = paraMap.get(param.getName());
                if (param.isJdbcPara()) {
                    sqlWrapper.addPara(sqlParam);
                    continue;
                }
                String strParam = sqlParam != null ? sqlParam.toString() : "";
                joinCond = joinCond.replace(param.getSqlName(), strParam);
            }
        }
        boolean hasJoinCond = StringUtils.isNotBlank(joinCond);
        boolean hasFieldParams = paramsGroup.judgeAny(l -> l.size() > 0);
        if (hasJoinCond || hasFieldParams) {
            builder.append(" where ");
            if (hasJoinCond) {
                builder.append("(").append(joinCond).append(")");
                if (hasFieldParams) {
                    builder.append(" and ");
                }
            }
        }
        paramsGroup.forEach(event -> {
            if (event.isGroupStart()) {
                builder.append("(");
            } else if (event.isGroupEnd()) {
                builder.append(")");
            } else if (event.isGroupAnd()) {
                builder.append(" and ");
            } else if (event.isGroupOr()) {
                builder.append(" or ");
            } else {
                List params = (List)event.getValue();
                for (int i = 0; i < params.size(); ++i) {
                    if (i == 0) {
                        builder.append("(");
                    } else {
                        builder.append(" and (");
                    }
                    FieldParam param = (FieldParam)params.get(i);
                    FieldMeta fieldMeta = beanMeta.requireFieldMeta(param.getName());
                    Object[] values = param.getValues();
                    FieldOp operator = (FieldOp)param.getOperator();
                    if (this.dateValueCorrector != null) {
                        values = this.dateValueCorrector.correct(fieldMeta.getType(), values, operator);
                    }
                    SqlWrapper<Object> fieldSql = this.resolveDbFieldSql(fieldMeta.getFieldSql(), paraMap);
                    FieldOp.OpPara opPara = new FieldOp.OpPara(fieldSql, param.isIgnoreCase(), values);
                    sqlWrapper.addParas(operator.operate(builder, opPara));
                    builder.append(")");
                }
            }
        });
        String groupBy = beanMeta.getGroupBy();
        if (StringUtils.isNotBlank(groupBy)) {
            List<SqlSnippet.SqlPara> groupParams = beanMeta.getGroupBySqlParas();
            if (groupParams != null) {
                for (SqlSnippet.SqlPara param : groupParams) {
                    Object sqlParam = paraMap.get(param.getName());
                    if (param.isJdbcPara()) {
                        sqlWrapper.addPara(sqlParam);
                        continue;
                    }
                    String strParam = sqlParam != null ? sqlParam.toString() : "";
                    groupBy = groupBy.replace(param.getSqlName(), strParam);
                }
            }
            builder.append(" group by ").append(groupBy);
        }
        sqlWrapper.setSql(builder.toString());
        return sqlWrapper;
    }

    protected <T> String buildClusterSql(BeanMeta<T> beanMeta, String clusterSelectSql, String fieldSelectSql, String fromWhereSql) {
        if (beanMeta.isDistinctOrGroupBy()) {
            String tableAlias = this.getTableAlias(beanMeta);
            return clusterSelectSql + " from (" + fieldSelectSql + fromWhereSql + ") " + tableAlias;
        }
        return clusterSelectSql + fromWhereSql;
    }

    protected <T> SqlWrapper<Object> buildListSql(BeanMeta<T> beanMeta, String fieldSelectSql, String fromWhereSql, List<OrderBy> orderBys, Paging paging, List<String> fetchFields, Map<String, Object> paraMap) {
        SqlSnippet orderBySnippet = beanMeta.getOrderBySnippet();
        boolean defaultOrderBy = StringUtils.isNotBlank(orderBySnippet.getSql());
        StringBuilder builder = new StringBuilder(fromWhereSql);
        int count = orderBys.size();
        if (count > 0 || defaultOrderBy) {
            builder.append(" order by ");
        }
        for (int index = 0; index < count; ++index) {
            OrderBy orderBy = orderBys.get(index);
            FieldMeta meta = beanMeta.requireFieldMeta(orderBy.getSort());
            if (fetchFields.contains(meta.getName())) {
                builder.append(meta.getDbAlias());
            } else {
                builder.append(meta.getFieldSql().getSql());
            }
            String order = orderBy.getOrder();
            if (StringUtils.isNotBlank(order)) {
                builder.append(' ').append(order);
            }
            if (index >= count - 1) continue;
            builder.append(", ");
        }
        if (count == 0 && defaultOrderBy) {
            SqlWrapper<Object> dbFieldSql = this.resolveDbFieldSql(orderBySnippet, paraMap);
            builder.append(dbFieldSql.getSql());
            SqlWrapper<Object> sqlWrapper = this.forPaginate(fieldSelectSql, builder.toString(), paging);
            SqlWrapper<Object> listSql = new SqlWrapper<Object>(sqlWrapper.getSql());
            listSql.addParas(dbFieldSql.getParas());
            listSql.addParas(sqlWrapper.getParas());
            return listSql;
        }
        return this.forPaginate(fieldSelectSql, builder.toString(), paging);
    }

    protected SqlWrapper<Object> resolveTableSql(SqlSnippet tableSnippet, Map<String, Object> paraMap) {
        SqlWrapper<Object> sqlWrapper = new SqlWrapper<Object>();
        String tables = tableSnippet.getSql();
        List params = tableSnippet.getParas();
        for (SqlSnippet.SqlPara param : params) {
            Object sqlParam = paraMap.get(param.getName());
            if (param.isJdbcPara()) {
                sqlWrapper.addPara(sqlParam);
                continue;
            }
            String strParam = sqlParam != null ? sqlParam.toString() : "";
            tables = tables.replace(param.getSqlName(), strParam);
        }
        sqlWrapper.setSql(tables);
        return sqlWrapper;
    }

    protected SqlWrapper<Object> resolveDbFieldSql(SqlSnippet dbFieldSnippet, Map<String, Object> paraMap) {
        String dbField = dbFieldSnippet.getSql();
        List params = dbFieldSnippet.getParas();
        SqlWrapper<Object> sqlWrapper = new SqlWrapper<Object>();
        for (SqlSnippet.SqlPara param : params) {
            Object sqlParam = paraMap.get(param.getName());
            if (param.isJdbcPara()) {
                sqlWrapper.addPara(sqlParam);
                continue;
            }
            String strParam = sqlParam != null ? sqlParam.toString() : "";
            dbField = dbField.replace(param.getSqlName(), strParam);
        }
        sqlWrapper.setSql(dbField);
        return sqlWrapper;
    }

    protected <T> String getCountAlias(BeanMeta<T> beanMeta) {
        return "s_count";
    }

    protected String getSummaryAlias(FieldMeta fieldMeta) {
        return fieldMeta.getDbAlias() + "_sum_";
    }

    protected <T> String getTableAlias(BeanMeta<T> beanMeta) {
        return "t_";
    }

    public DateValueCorrector getDateValueCorrector() {
        return this.dateValueCorrector;
    }

    public void setDateValueCorrector(DateValueCorrector dateValueCorrector) {
        this.dateValueCorrector = Objects.requireNonNull(dateValueCorrector);
    }
}

