/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.FieldConvertor;
import com.ejlchina.searcher.FieldMeta;

public class NumberFieldConvertor
implements FieldConvertor.BFieldConvertor {
    @Override
    public boolean supports(FieldMeta meta, Class<?> valueType) {
        if (Number.class.isAssignableFrom(valueType)) {
            Class<?> targetType = meta.getType();
            return targetType == Integer.TYPE || targetType == Integer.class || targetType == Long.TYPE || targetType == Long.class || targetType == Float.TYPE || targetType == Float.class || targetType == Double.TYPE || targetType == Double.class || targetType == Short.TYPE || targetType == Short.class || targetType == Byte.TYPE || targetType == Byte.class;
        }
        return false;
    }

    @Override
    public Object convert(FieldMeta meta, Object value) {
        Number number = (Number)value;
        Class<?> targetType = meta.getType();
        if (targetType == Integer.TYPE || targetType == Integer.class) {
            return number.intValue();
        }
        if (targetType == Long.TYPE || targetType == Long.class) {
            return number.longValue();
        }
        if (targetType == Float.TYPE || targetType == Float.class) {
            return Float.valueOf(number.floatValue());
        }
        if (targetType == Double.TYPE || targetType == Double.class) {
            return number.doubleValue();
        }
        if (targetType == Short.TYPE || targetType == Short.class) {
            return number.shortValue();
        }
        if (targetType == Byte.TYPE || targetType == Byte.class) {
            return number.byteValue();
        }
        throw new UnsupportedOperationException();
    }
}

