/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.util;

import com.ejlchina.searcher.FieldOp;
import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.SearchParam;
import com.ejlchina.searcher.param.FieldParam;
import com.ejlchina.searcher.param.OrderBy;
import com.ejlchina.searcher.param.Paging;
import com.ejlchina.searcher.util.StringUtils;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class MapBuilder {
    public static final String ORDER_BY = OrderBy.class.getName();
    public static final String PAGING = Paging.class.getName();
    public static final String FIELD_PARAM = FieldParam.class.getName();
    public static final String ONLY_SELECT = SearchParam.class.getName() + ".ONLY_SELECT";
    public static final String SELECT_EXCLUDE = SearchParam.class.getName() + ".SELECT_EXCLUDE";
    public static final String GROUP_EXPR = SearchParam.class.getName() + ".GROUP_EXPR";
    private final Map<FieldFn<?, ?>, String> cache = new ConcurrentHashMap();
    private final Map<String, Object> map;
    private FieldParam fieldParam = null;
    private String group = null;

    public MapBuilder(Map<String, Object> map) {
        this.map = map;
    }

    public MapBuilder put(String key, Object value) {
        this.map.put(key, value);
        return this;
    }

    @SafeVarargs
    public final <T> MapBuilder onlySelect(FieldFn<T, ?> ... fieldFns) {
        String[] fields = new String[fieldFns.length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = this.toFieldName(fieldFns[i]);
        }
        return this.onlySelect(fields);
    }

    public MapBuilder onlySelect(String ... fields) {
        ArrayList list = (ArrayList)this.map.get(ONLY_SELECT);
        if (list == null) {
            list = new ArrayList();
            this.map.put(ONLY_SELECT, list);
        }
        Collections.addAll(list, fields);
        return this;
    }

    @SafeVarargs
    public final <T> MapBuilder selectExclude(FieldFn<T, ?> ... fieldFns) {
        String[] fields = new String[fieldFns.length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = this.toFieldName(fieldFns[i]);
        }
        return this.selectExclude(fields);
    }

    public MapBuilder selectExclude(String ... fields) {
        ArrayList list = (ArrayList)this.map.get(SELECT_EXCLUDE);
        if (list == null) {
            list = new ArrayList();
            this.map.put(SELECT_EXCLUDE, list);
        }
        Collections.addAll(list, fields);
        return this;
    }

    public MapBuilder group(String group) {
        this.group = group;
        return this;
    }

    public MapBuilder groupExpr(String gExpr) {
        this.map.put(GROUP_EXPR, gExpr);
        return this;
    }

    public <T> MapBuilder field(FieldFn<T, ?> fieldFn, Collection<?> values) {
        return this.field(fieldFn, values.toArray());
    }

    public <T> MapBuilder field(FieldFn<T, ?> fieldFn, Object ... values) {
        return this.field(this.toFieldName(fieldFn), values);
    }

    public <T> MapBuilder field(String fieldName, Collection<?> values) {
        return this.field(fieldName, values.toArray());
    }

    public MapBuilder field(String fieldName, Object ... values) {
        if (fieldName != null) {
            ArrayList<FieldParam.Value> pValues = new ArrayList<FieldParam.Value>();
            for (int index = 0; index < values.length; ++index) {
                pValues.add(new FieldParam.Value(values[index], index));
            }
            String field = fieldName.trim();
            this.fieldParam = new FieldParam(field, pValues);
            if (this.group != null) {
                this.map.put(this.group + FIELD_PARAM + field, this.fieldParam);
            } else {
                this.map.put(FIELD_PARAM + field, this.fieldParam);
            }
        }
        return this;
    }

    public MapBuilder op(String operator) {
        return this.fieldOp(operator);
    }

    public MapBuilder op(Class<? extends FieldOp> operator) {
        return this.fieldOp(operator);
    }

    public MapBuilder op(FieldOp operator) {
        return this.fieldOp(operator);
    }

    private MapBuilder fieldOp(Object operator) {
        if (this.fieldParam == null) {
            throw new IllegalStateException("the method [ op(...) ] must go after [ field(...) ] method");
        }
        this.fieldParam.setOperator(operator);
        return this;
    }

    public MapBuilder ic() {
        return this.ic(true);
    }

    public MapBuilder ic(boolean ignoreCase) {
        if (this.fieldParam == null) {
            throw new IllegalStateException("the method [ ic(...) ] must go after [ field(...) ] method");
        }
        this.fieldParam.setIgnoreCase(ignoreCase);
        return this;
    }

    public <T> MapBuilder orderBy(FieldFn<T, ?> fieldFn, String order) {
        return this.orderBy(this.toFieldName(fieldFn), order);
    }

    public MapBuilder orderBy(String fieldName, String order) {
        if (fieldName != null) {
            Optional<OrderBy> orderByOpt;
            ArrayList<OrderBy> orderBys = (ArrayList<OrderBy>)this.map.get(ORDER_BY);
            if (orderBys == null) {
                orderBys = new ArrayList<OrderBy>();
                this.map.put(ORDER_BY, orderBys);
            }
            if ((orderByOpt = orderBys.stream().filter(orderBy -> fieldName.equals(orderBy.getSort())).findAny()).isPresent()) {
                throw new SearchException("\u91cd\u590d\u6dfb\u52a0\u6392\u5e8f\u5b57\u6bb5\uff1a" + fieldName + " " + order);
            }
            orderBys.add(new OrderBy(fieldName, order));
        }
        return this;
    }

    public MapBuilder page(long page, int size) {
        return this.limit(page * (long)size, size);
    }

    public MapBuilder limit(long offset, int size) {
        this.map.put(PAGING, new Paging(size, offset));
        return this;
    }

    public Map<String, Object> build() {
        return this.map;
    }

    private String toFieldName(FieldFn<?, ?> fieldFn) {
        String fieldName = this.cache.get(fieldFn);
        if (fieldName != null) {
            return fieldName;
        }
        try {
            String methodName;
            boolean isInaccessible;
            Method wrMethod = fieldFn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            boolean bl = isInaccessible = !wrMethod.isAccessible();
            if (isInaccessible) {
                wrMethod.setAccessible(true);
            }
            SerializedLambda sLambda = (SerializedLambda)wrMethod.invoke(fieldFn, new Object[0]);
            if (isInaccessible) {
                wrMethod.setAccessible(false);
            }
            if ((methodName = sLambda.getImplMethodName()).startsWith("get") && methodName.length() > 3) {
                fieldName = StringUtils.firstCharToLoweCase(methodName.substring(3));
            }
            if (methodName.startsWith("is") && methodName.length() > 2) {
                fieldName = StringUtils.firstCharToLoweCase(methodName.substring(2));
            }
            if (fieldName != null) {
                this.cache.put(fieldFn, fieldName);
                return fieldName;
            }
            throw new IllegalStateException("can not convert method [" + methodName + "] to field name");
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("\u65e0\u6cd5\u53cd\u5c04\u51fa\u5b57\u6bb5\u540d", e);
        }
    }

    @FunctionalInterface
    public static interface FieldFn<T, R>
    extends Function<T, R>,
    Serializable {
    }
}

