/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc;

import com.github.therapi.runtimejavadoc.BaseJavadoc;
import com.github.therapi.runtimejavadoc.Comment;
import com.github.therapi.runtimejavadoc.FieldJavadoc;
import com.github.therapi.runtimejavadoc.MethodJavadoc;
import com.github.therapi.runtimejavadoc.OtherJavadoc;
import com.github.therapi.runtimejavadoc.ParamJavadoc;
import com.github.therapi.runtimejavadoc.RuntimeJavadoc;
import com.github.therapi.runtimejavadoc.SeeAlsoJavadoc;
import com.github.therapi.runtimejavadoc.internal.MethodSignature;
import com.github.therapi.runtimejavadoc.internal.RuntimeJavadocHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ClassJavadoc
extends BaseJavadoc {
    private final Map<String, FieldJavadoc> fields;
    private final Map<String, FieldJavadoc> enumConstants;
    private final Map<MethodSignature, MethodJavadoc> methods;
    private final Map<MethodSignature, MethodJavadoc> constructors;
    private final Map<String, ParamJavadoc> recordComponents;

    public ClassJavadoc(String name, Comment comment, List<FieldJavadoc> fields, List<FieldJavadoc> enumConstants, List<MethodJavadoc> methods, List<MethodJavadoc> constructors, List<OtherJavadoc> other, List<SeeAlsoJavadoc> seeAlso, List<ParamJavadoc> recordComponents) {
        super(name, comment, seeAlso, other);
        LinkedHashMap fieldMap = new LinkedHashMap();
        if (fields != null) {
            fields.forEach(fieldJavadoc -> fieldMap.put(fieldJavadoc.getName(), fieldJavadoc));
        }
        this.fields = Collections.unmodifiableMap(fieldMap);
        LinkedHashMap enumMap = new LinkedHashMap();
        if (enumConstants != null) {
            enumConstants.forEach(fieldJavadoc -> enumMap.put(fieldJavadoc.getName(), fieldJavadoc));
        }
        this.enumConstants = Collections.unmodifiableMap(enumMap);
        LinkedHashMap methodsMap = new LinkedHashMap();
        if (methods != null) {
            methods.forEach(methodJavadoc -> methodsMap.put(MethodSignature.from(methodJavadoc), methodJavadoc));
        }
        this.methods = Collections.unmodifiableMap(methodsMap);
        LinkedHashMap constructorsMap = new LinkedHashMap();
        if (constructors != null) {
            constructors.forEach(methodJavadoc -> constructorsMap.put(MethodSignature.from(methodJavadoc), methodJavadoc));
        }
        this.constructors = Collections.unmodifiableMap(constructorsMap);
        LinkedHashMap recordsMap = new LinkedHashMap();
        if (recordComponents != null) {
            recordComponents.forEach(paramJavadoc -> recordsMap.put(paramJavadoc.getName(), paramJavadoc));
        }
        this.recordComponents = Collections.unmodifiableMap(recordsMap);
    }

    private ClassJavadoc(String name, Comment comment, Map<String, FieldJavadoc> fields, Map<String, FieldJavadoc> enumConstants, Map<MethodSignature, MethodJavadoc> methods, Map<MethodSignature, MethodJavadoc> constructors, List<OtherJavadoc> other, List<SeeAlsoJavadoc> seeAlso, Map<String, ParamJavadoc> recordComponents) {
        super(name, comment, seeAlso, other);
        this.fields = Collections.unmodifiableMap(fields);
        this.enumConstants = Collections.unmodifiableMap(enumConstants);
        this.methods = Collections.unmodifiableMap(methods);
        this.constructors = Collections.unmodifiableMap(constructors);
        this.recordComponents = Collections.unmodifiableMap(recordComponents);
    }

    public static ClassJavadoc createEmpty(String qualifiedClassName) {
        return new ClassJavadoc(qualifiedClassName, null, (List)null, null, null, null, null, null, null){

            @Override
            public boolean isEmpty() {
                return true;
            }
        };
    }

    ClassJavadoc createEnhancedClassJavadoc(Class<?> clazz) {
        assert (this.getName().replace("$", ".").equals(clazz.getCanonicalName())) : "Class `" + clazz.getName() + "` does not match class doc for `" + this.getName() + "`";
        HashMap<String, ClassJavadoc> classJavadocCache = new HashMap<String, ClassJavadoc>();
        classJavadocCache.put(clazz.getCanonicalName(), this);
        RuntimeJavadocHelper.getAllTypeAncestors(clazz).forEach(cls -> classJavadocCache.put(cls.getCanonicalName(), RuntimeJavadoc.getSkinnyClassJavadoc(cls)));
        LinkedHashMap<MethodSignature, MethodJavadoc> methodJavadocs = new LinkedHashMap<MethodSignature, MethodJavadoc>();
        Arrays.stream(clazz.getMethods()).forEach(method -> {
            MethodJavadoc methodJavadoc = RuntimeJavadoc.getJavadoc(method, classJavadocCache);
            if (!methodJavadoc.isEmpty()) {
                methodJavadocs.put(MethodSignature.from(method), methodJavadoc);
            }
        });
        if (methodJavadocs.isEmpty()) {
            return this;
        }
        return new ClassJavadoc(this.getName(), this.getComment(), this.fields, this.enumConstants, methodJavadocs, this.constructors, this.getOther(), this.getSeeAlso(), this.recordComponents);
    }

    public List<FieldJavadoc> getFields() {
        return Collections.unmodifiableList(new ArrayList<FieldJavadoc>(this.fields.values()));
    }

    public List<FieldJavadoc> getEnumConstants() {
        return Collections.unmodifiableList(new ArrayList<FieldJavadoc>(this.enumConstants.values()));
    }

    public List<MethodJavadoc> getMethods() {
        return Collections.unmodifiableList(new ArrayList<MethodJavadoc>(this.methods.values()));
    }

    public List<MethodJavadoc> getConstructors() {
        return Collections.unmodifiableList(new ArrayList<MethodJavadoc>(this.constructors.values()));
    }

    public List<ParamJavadoc> getRecordComponents() {
        return Collections.unmodifiableList(new ArrayList<ParamJavadoc>(this.recordComponents.values()));
    }

    FieldJavadoc findMatchingField(Field field) {
        return this.fields.getOrDefault(field.getName(), FieldJavadoc.createEmpty(field.getName()));
    }

    FieldJavadoc findMatchingEnumConstant(Enum<?> enumConstant) {
        return this.enumConstants.getOrDefault(enumConstant.name(), FieldJavadoc.createEmpty(enumConstant.name()));
    }

    MethodJavadoc findMatchingMethod(Method method) {
        MethodSignature methodSignature = MethodSignature.from(method);
        return this.methods.getOrDefault(methodSignature, MethodJavadoc.createEmpty(method));
    }

    MethodJavadoc findMatchingConstructor(Constructor<?> constructor) {
        MethodSignature methodSignature = MethodSignature.from(constructor);
        return this.constructors.getOrDefault(methodSignature, MethodJavadoc.createEmpty(constructor));
    }

    ParamJavadoc findRecordComponent(String recordComponent) {
        return this.recordComponents.getOrDefault(recordComponent, new ParamJavadoc(recordComponent, Comment.createEmpty()));
    }

    public String toString() {
        return "ClassJavadoc{name='" + this.getName() + '\'' + ", comment=" + this.getComment() + ", fields=" + this.fields + ", methods=" + this.methods + ", constructors=" + this.constructors + ", recordComponents=" + this.recordComponents + ", seeAlso=" + this.getSeeAlso() + ", other=" + this.getOther() + '}';
    }
}

