/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.model.AbstractBulkRequest;
import com.obs.services.model.KeyAndVersion;
import com.obs.services.model.RestoreObjectRequest;
import com.obs.services.model.RestoreObjectResult;
import com.obs.services.model.RestoreTierEnum;
import com.obs.services.model.TaskCallback;
import java.util.List;

public class RestoreObjectsRequest
extends AbstractBulkRequest {
    private int days;
    private RestoreTierEnum tier;
    private String prefix;
    private boolean versionRestored;
    private String encodingType;
    private List<KeyAndVersion> keyAndVersions;
    private TaskCallback<RestoreObjectResult, RestoreObjectRequest> callback;

    public RestoreObjectsRequest() {
    }

    public RestoreObjectsRequest(String bucketName) {
        this.bucketName = bucketName;
    }

    public RestoreObjectsRequest(String bucketName, int days, RestoreTierEnum tier) {
        this.bucketName = bucketName;
        this.days = days;
        this.tier = tier;
    }

    public RestoreObjectsRequest(String bucketName, int days, RestoreTierEnum tier, String encodingType) {
        this.bucketName = bucketName;
        this.days = days;
        this.tier = tier;
        this.encodingType = encodingType;
    }

    public int getDays() {
        return this.days;
    }

    public void setDays(int days) {
        this.days = days;
    }

    public RestoreTierEnum getRestoreTier() {
        return this.tier;
    }

    public void setRestoreTier(RestoreTierEnum tier) {
        this.tier = tier;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isVersionRestored() {
        return this.versionRestored;
    }

    public void setVersionRestored(boolean versionRestored) {
        this.versionRestored = versionRestored;
    }

    public void setKeyAndVersions(List<KeyAndVersion> keyAndVersions) {
        this.keyAndVersions = keyAndVersions;
    }

    public List<KeyAndVersion> getKeyAndVersions() {
        return this.keyAndVersions;
    }

    public KeyAndVersion addKeyAndVersion(String objectKey, String versionId) {
        KeyAndVersion kv = new KeyAndVersion(objectKey, versionId);
        this.getKeyAndVersions().add(kv);
        return kv;
    }

    public KeyAndVersion addKeyAndVersion(String objectKey) {
        return this.addKeyAndVersion(objectKey, null);
    }

    public TaskCallback<RestoreObjectResult, RestoreObjectRequest> getCallback() {
        return this.callback;
    }

    public void setCallback(TaskCallback<RestoreObjectResult, RestoreObjectRequest> callback) {
        this.callback = callback;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    @Override
    public String toString() {
        return "RestoreObjectsRequest [bucketName=" + this.bucketName + ", days=" + this.days + ", tier=" + (Object)((Object)this.tier) + ", encodingType=" + this.encodingType + "]";
    }
}

