/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.spring;

import com.mybatisflex.core.datasource.DataSourceKey;
import com.mybatisflex.core.datasource.FlexDataSource;
import com.mybatisflex.core.transaction.TransactionContext;
import com.mybatisflex.core.util.StringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.transaction.Transaction;

public class FlexSpringTransaction
implements Transaction {
    private final FlexDataSource dataSource;
    private final Map<String, Connection> connectionMap = new HashMap<String, Connection>();
    private boolean isTransaction = false;
    private boolean autoCommit;

    public FlexSpringTransaction(FlexDataSource dataSource, boolean autoCommit) {
        this.dataSource = dataSource;
        this.autoCommit = autoCommit;
    }

    public Connection getConnection() throws SQLException {
        Connection connection;
        String dataSourceKey = DataSourceKey.get();
        if (StringUtil.isBlank((String)dataSourceKey)) {
            dataSourceKey = this.dataSource.getDefaultDataSourceKey();
        }
        if ((connection = this.connectionMap.get(dataSourceKey)) == null) {
            connection = this.dataSource.getConnection();
            this.connectionMap.put(dataSourceKey, connection);
        }
        this.autoCommit = connection.getAutoCommit();
        if (TransactionContext.getXID() != null) {
            this.isTransaction = true;
        }
        return connection;
    }

    public void commit() throws SQLException {
        if (!this.isTransaction && !this.autoCommit) {
            this.getConnection().commit();
        }
    }

    public void rollback() throws SQLException {
        if (!this.isTransaction && !this.autoCommit) {
            this.getConnection().rollback();
        }
    }

    public void close() throws SQLException {
        this.getConnection().close();
    }

    public Integer getTimeout() throws SQLException {
        return null;
    }
}

