/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.ResourceBundle;
import oracle.jdbc.driver.Message;

class ErrorMessageFramework
implements Message {
    private static ResourceBundle messageBundleWithoutErrorCode;
    private static ResourceBundle messageBundleWithErrorCode;
    private static final String messagesWithoutCodes = "oracle.jdbc.driver.Messages";
    private static final String messagesWithCodes = "oracle.jdbc.driver.ErrorMessages";

    private String getMessage(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (messageBundleWithErrorCode.containsKey(key = key.replace("ORA-", ""))) {
            return messageBundleWithErrorCode.getString(key);
        }
        return messageBundleWithoutErrorCode.getString(key);
    }

    @Override
    public String msg(String key, Object what) {
        if (messageBundleWithoutErrorCode == null) {
            try {
                messageBundleWithoutErrorCode = ResourceBundle.getBundle(messagesWithoutCodes);
            }
            catch (Exception e) {
                return "Message file 'oracle.jdbc.driver.Messages' is missing.";
            }
        }
        if (messageBundleWithErrorCode == null) {
            try {
                messageBundleWithErrorCode = ResourceBundle.getBundle(messagesWithCodes);
            }
            catch (Exception e) {
                return "Message file 'oracle.jdbc.driver.ErrorMessages' is missing.";
            }
        }
        try {
            if (what != null) {
                return this.getMessage(key) + ": " + String.valueOf(what);
            }
            return this.getMessage(key);
        }
        catch (Exception e) {
            return "Message [" + key + "] not found in 'oracle.jdbc.driver.Messages/oracle.jdbc.driver.ErrorMessages'.";
        }
    }
}

