/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.url.parser;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import oracle.net.resolver.EnvVariableResolver;
import oracle.net.url.builder.ConnectDescriptorBuilder;
import oracle.net.url.builder.URLBuilder;
import oracle.net.url.common.Node;
import oracle.net.url.parser.EZConnectParser;

final class ConnectDescriptorAdapter {
    private static final List<String> DESCRIPTION_PARAMS = Collections.unmodifiableList(Arrays.asList("ENABLE", "FAILOVER", "LOAD_BALANCE", "USE_SNI", "RECV_BUF_SIZE", "SEND_BUF_SIZE", "SDU", "EXPIRE_TIME", "SOURCE_ROUTE", "RETRY_COUNT", "RETRY_DELAY", "CONNECT_TIMEOUT", "TRANSPORT_CONNECT_TIMEOUT"));
    private static final List<String> CONNECT_DATA_PARAMS = Collections.unmodifiableList(Arrays.asList("POOL_CONNECTION_CLASS", "POOL_PURITY", "SERVICE_TAG", "POOL_BOUNDARY", "CONNECTION_ID_PREFIX"));
    private static final List<String> SECURITY_PARAMS = Collections.unmodifiableList(Arrays.asList("SSL_SERVER_CERT_DN", "MY_WALLET_DIRECTORY", "WALLET_LOCATION", "IGNORE_ANO_ENCRYPTION_FOR_TCPS", "ENCRYPTION_CLIENT", "ENCRYPTION_TYPES_CLIENT", "CRYPTO_CHECKSUM_CLIENT", "CRYPTO_CHECKSUM_TYPES_CLIENT", "SSL_SERVER_DN_MATCH"));
    private static final List<String> ADDRESS_PARAMS = Collections.unmodifiableList(Arrays.asList("HTTPS_PROXY", "HTTPS_PROXY_PORT"));
    private static final Map<String, String> URL_PROPS_ALIAS = ConnectDescriptorAdapter.initializeUrlAlias();
    private static final Map<String, String> CONNECTION_PROPS_ALIAS = ConnectDescriptorAdapter.initializeConnectionPropertiesAlias();
    private static final String EXT_TNS_ADMIN_KEYWORD = "TNS_ADMIN";
    private final EZConnectParser ezConnectParser;
    private ConnectDescriptorBuilder.DescriptionNode rootNode;
    private Map<String, String> urlParams;
    private Properties connectProps;

    ConnectDescriptorAdapter(EZConnectParser ezConnectParser) throws IllegalArgumentException {
        this.ezConnectParser = ezConnectParser;
        this.translate();
    }

    private void translate() throws IllegalArgumentException {
        this.extractURLandConnectionProps();
        ConnectDescriptorBuilder urlBuilder = URLBuilder.newInstance(ConnectDescriptorBuilder.class).strictMode(this.ezConnectParser.strictMode).rootNode(ConnectDescriptorBuilder.DescriptionNode.class, descNode -> {
            this.addDescriptionParams((ConnectDescriptorBuilder.DescriptionNode)descNode, this.ezConnectParser);
            this.addAddressList((ConnectDescriptorBuilder.DescriptionNode)descNode, this.ezConnectParser);
            this.addConnectData((ConnectDescriptorBuilder.DescriptionNode)descNode, this.ezConnectParser);
            this.addSecurityOptions((ConnectDescriptorBuilder.DescriptionNode)descNode, this.ezConnectParser);
        });
        this.rootNode = (ConnectDescriptorBuilder.DescriptionNode)urlBuilder.rootNode();
    }

    String getURLParam(String key) {
        return this.urlParams.get(key);
    }

    ConnectDescriptorBuilder.DescriptionNode getRootNode() {
        return this.rootNode;
    }

    Properties getConnectionProperties() {
        return this.connectProps;
    }

    private void addDescriptionParams(ConnectDescriptorBuilder.DescriptionNode descNode, EZConnectParser ezConnectParser) {
        if (this.urlParams == null || this.urlParams.isEmpty()) {
            return;
        }
        this.urlParams.entrySet().stream().filter(e -> DESCRIPTION_PARAMS.contains(e.getKey())).forEach(e -> descNode.param((String)e.getKey(), (String)e.getValue()));
    }

    private void addConnectData(ConnectDescriptorBuilder.DescriptionNode descNode, EZConnectParser ezConnectParser) {
        if (!this.isConnectDataNeeded(ezConnectParser)) {
            return;
        }
        descNode.addChild(ConnectDescriptorBuilder.ConnectDataNode.class, connectDataNode -> {
            if (ezConnectParser.getServiceName() != null) {
                connectDataNode.serviceName(ezConnectParser.getServiceName());
            }
            if (ezConnectParser.getInstanceName() != null) {
                if (ezConnectParser.isSIDFormat()) {
                    connectDataNode.param("SID", ezConnectParser.getInstanceName());
                } else {
                    connectDataNode.instanceName(ezConnectParser.getInstanceName());
                }
            }
            if (ezConnectParser.getServerMode() != null) {
                connectDataNode.serverMode(ezConnectParser.getServerMode());
            }
            if (this.urlParams == null || this.urlParams.isEmpty()) {
                return;
            }
            this.urlParams.entrySet().stream().filter(e -> CONNECT_DATA_PARAMS.contains(e.getKey())).forEach(e -> connectDataNode.param((String)e.getKey(), (String)e.getValue()));
        });
    }

    private boolean isConnectDataNeeded(EZConnectParser ezConnectParser) {
        return ezConnectParser.getServiceName() != null || ezConnectParser.getInstanceName() != null || ezConnectParser.getServerMode() != null || this.urlParams != null && !this.urlParams.isEmpty() && this.urlParams.entrySet().stream().filter(e -> CONNECT_DATA_PARAMS.contains(e.getKey())).count() != 0L;
    }

    private void addSecurityOptions(ConnectDescriptorBuilder.DescriptionNode descNode, EZConnectParser ezConnectParser) {
        if (this.urlParams == null || this.urlParams.isEmpty()) {
            return;
        }
        Map<String, String> securityParams = this.urlParams.entrySet().stream().filter(e -> SECURITY_PARAMS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (securityParams.isEmpty()) {
            return;
        }
        descNode.addChild(ConnectDescriptorBuilder.SecurityNode.class, securityNode -> securityParams.forEach((name, value) -> securityNode.param((String)name, (String)value)));
    }

    private void addAddressList(ConnectDescriptorBuilder.DescriptionNode descNode, EZConnectParser ezConnectParser) {
        if (ezConnectParser.hasSeenAddrListDelimiter()) {
            ezConnectParser.getAddressList().forEach(list -> this.addAddressList(descNode, (List<EZConnectParser.Address>)list));
        } else {
            ezConnectParser.getAddressList().get(0).forEach(address -> this.addAddress(descNode, (EZConnectParser.Address)address));
        }
    }

    private void addAddressList(ConnectDescriptorBuilder.DescriptionNode desc, List<EZConnectParser.Address> addresses) {
        desc.addChild(ConnectDescriptorBuilder.AddressListNode.class, addressListNode -> {
            addressListNode.param("LOAD_BALANCE", "ON");
            addresses.forEach(address -> this.addAddress((Node)addressListNode, (EZConnectParser.Address)address));
        });
    }

    private void addAddress(Node parent, EZConnectParser.Address address) {
        parent.addChild(ConnectDescriptorBuilder.AddressNode.class, addressNode -> {
            addressNode.host(address.host, address.port);
            addressNode.protocol(this.ezConnectParser.getProtocol());
            if (this.urlParams == null || this.urlParams.isEmpty()) {
                return;
            }
            this.urlParams.entrySet().stream().filter(e -> ADDRESS_PARAMS.contains(e.getKey())).forEach(e -> addressNode.param((String)e.getKey(), (String)e.getValue()));
        });
    }

    private void extractURLandConnectionProps() {
        this.urlParams = new LinkedHashMap<String, String>();
        this.connectProps = new Properties();
        Properties extProps = this.ezConnectParser.getProperties();
        if (extProps != null && !extProps.isEmpty()) {
            this.populateParams(extProps);
        }
        if (!(this.ezConnectParser.hasSeenAddrListDelimiter() || this.urlParams.containsKey("LOAD_BALANCE") || this.ezConnectParser.isSIDFormat())) {
            this.urlParams.put("LOAD_BALANCE", "ON");
        }
        if ("tcps".equalsIgnoreCase(this.ezConnectParser.getProtocol()) && !this.urlParams.containsKey("SSL_SERVER_DN_MATCH") && !this.connectProps.containsKey("oracle.net.ssl_server_dn_match")) {
            this.urlParams.put("SSL_SERVER_DN_MATCH", "TRUE");
        }
    }

    private void populateParams(Properties extProps) {
        extProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String aliasKeyName = key.toString().toLowerCase();
            String propertyName = URL_PROPS_ALIAS.get(aliasKeyName);
            if (propertyName != null) {
                this.urlParams.put(propertyName, (String)value);
            } else if (aliasKeyName.equalsIgnoreCase(EXT_TNS_ADMIN_KEYWORD)) {
                this.addTNSAdmin((String)value);
            } else {
                propertyName = CONNECTION_PROPS_ALIAS.getOrDefault(aliasKeyName, (String)key);
                this.connectProps.put(propertyName, value);
            }
        }));
    }

    private void addTNSAdmin(String tnsAdminValue) {
        if (!new File(tnsAdminValue).exists()) {
            tnsAdminValue = EnvVariableResolver.resolveEnvPlaceHolders(tnsAdminValue, this.connectProps);
        }
        this.connectProps.put("oracle.net.tns_admin", tnsAdminValue);
    }

    private static final Map<String, String> initializeUrlAlias() {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        aliasMap.put("enable", "ENABLE");
        aliasMap.put("failover", "FAILOVER");
        aliasMap.put("expire_time", "EXPIRE_TIME");
        aliasMap.put("load_balance", "LOAD_BALANCE");
        aliasMap.put("recv_buf_size", "RECV_BUF_SIZE");
        aliasMap.put("send_buf_size", "SEND_BUF_SIZE");
        aliasMap.put("sdu", "SDU");
        aliasMap.put("source_route", "SOURCE_ROUTE");
        aliasMap.put("retry_count", "RETRY_COUNT");
        aliasMap.put("retry_delay", "RETRY_DELAY");
        aliasMap.put("https_proxy", "HTTPS_PROXY");
        aliasMap.put("https_proxy_port", "HTTPS_PROXY_PORT");
        aliasMap.put("connect_timeout", "CONNECT_TIMEOUT");
        aliasMap.put("transport_connect_timeout", "TRANSPORT_CONNECT_TIMEOUT");
        aliasMap.put("ssl_server_cert_dn", "SSL_SERVER_CERT_DN");
        aliasMap.put("ssl_server_dn_match", "SSL_SERVER_DN_MATCH");
        aliasMap.put("wallet_location", "WALLET_LOCATION");
        aliasMap.put("encryption_client", "ENCRYPTION_CLIENT");
        aliasMap.put("encryption_types_client", "ENCRYPTION_TYPES_CLIENT");
        aliasMap.put("crypto_checksum_client", "CRYPTO_CHECKSUM_CLIENT");
        aliasMap.put("crypto_checksum_types_client", "CRYPTO_CHECKSUM_TYPES_CLIENT");
        aliasMap.put("pool_connection_class", "POOL_CONNECTION_CLASS");
        aliasMap.put("pool_purity", "POOL_PURITY");
        aliasMap.put("pool_boundary", "POOL_BOUNDARY");
        aliasMap.put("service_tag", "SERVICE_TAG");
        aliasMap.put("connection_id_prefix", "CONNECTION_ID_PREFIX");
        aliasMap.put("use_sni", "USE_SNI");
        aliasMap.put("ignore_ano_encryption_for_tcps", "IGNORE_ANO_ENCRYPTION_FOR_TCPS");
        return aliasMap;
    }

    private static Map<String, String> initializeConnectionPropertiesAlias() {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        aliasMap.put("keystore_type", "javax.net.ssl.keyStoreType");
        aliasMap.put("keystore_password", "javax.net.ssl.keyStorePassword");
        aliasMap.put("keystore", "javax.net.ssl.keyStore");
        aliasMap.put("truststore_type", "javax.net.ssl.trustStoreType");
        aliasMap.put("truststore_password", "javax.net.ssl.trustStorePassword");
        aliasMap.put("truststore", "javax.net.ssl.trustStore");
        aliasMap.put("ssl_version", "oracle.net.ssl_version");
        aliasMap.put("ssl_ciphers", "oracle.net.ssl_cipher_suites");
        aliasMap.put("allow_weak_crypto", "oracle.net.allow_weak_crypto");
        aliasMap.put("ssl_certificate_alias", "oracle.net.ssl_certificate_alias");
        aliasMap.put("ssl_certificate_thumbprint", "oracle.net.ssl_certificate_thumbprint");
        aliasMap.put("token_auth", "oracle.jdbc.tokenAuthentication");
        aliasMap.put("token_location", "oracle.jdbc.tokenLocation");
        aliasMap.put("password_auth", "oracle.jdbc.passwordAuthentication");
        aliasMap.put("oci_iam_url", "oracle.jdbc.ociIamUrl");
        aliasMap.put("oci_tenancy", "oracle.jdbc.ociTenancy");
        aliasMap.put("oci_compartment", "oracle.jdbc.ociCompartment");
        aliasMap.put("oci_database", "oracle.jdbc.ociDatabase");
        aliasMap.put("oci_config_file", "oracle.jdbc.ociConfigFile");
        aliasMap.put("oci_profile", "oracle.jdbc.ociProfile");
        aliasMap.put("azure_db_app_id_uri", "oracle.jdbc.azureDatabaseApplicationIdUri");
        aliasMap.put("tenant_id", "oracle.jdbc.tenantId");
        aliasMap.put("client_id", "oracle.jdbc.clientId");
        aliasMap.put("client_certificate", "oracle.jdbc.clientCertificate");
        aliasMap.put("redirect_uri", "oracle.jdbc.redirectUri");
        return aliasMap;
    }
}

