/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.discovery;

import com.tencent.cloud.polaris.PolarisDiscoveryProperties;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.core.ProviderAPI;
import com.tencent.polaris.api.rpc.GetAllInstancesRequest;
import com.tencent.polaris.api.rpc.GetHealthyInstancesRequest;
import com.tencent.polaris.api.rpc.GetServicesRequest;
import com.tencent.polaris.api.rpc.InstancesResponse;
import com.tencent.polaris.api.rpc.ServicesResponse;
import com.tencent.polaris.client.api.SDKContext;

public class PolarisDiscoveryHandler {
    private final PolarisDiscoveryProperties polarisDiscoveryProperties;
    private final ProviderAPI providerAPI;
    private final SDKContext sdkContext;
    private final ConsumerAPI polarisConsumer;

    public PolarisDiscoveryHandler(PolarisDiscoveryProperties polarisDiscoveryProperties, ProviderAPI providerAPI, SDKContext sdkContext, ConsumerAPI polarisConsumer) {
        this.polarisDiscoveryProperties = polarisDiscoveryProperties;
        this.providerAPI = providerAPI;
        this.sdkContext = sdkContext;
        this.polarisConsumer = polarisConsumer;
    }

    public InstancesResponse getHealthyInstances(String service) {
        String namespace = this.polarisDiscoveryProperties.getNamespace();
        GetHealthyInstancesRequest getHealthyInstancesRequest = new GetHealthyInstancesRequest();
        getHealthyInstancesRequest.setNamespace(namespace);
        getHealthyInstancesRequest.setService(service);
        getHealthyInstancesRequest.setIncludeCircuitBreakInstances(Boolean.valueOf(false));
        return this.polarisConsumer.getHealthyInstances(getHealthyInstancesRequest);
    }

    public InstancesResponse getInstances(String service) {
        String namespace = this.polarisDiscoveryProperties.getNamespace();
        GetAllInstancesRequest request = new GetAllInstancesRequest();
        request.setNamespace(namespace);
        request.setService(service);
        return this.polarisConsumer.getAllInstance(request);
    }

    public ProviderAPI getProviderAPI() {
        return this.providerAPI;
    }

    public SDKContext getSdkContext() {
        return this.sdkContext;
    }

    public ServicesResponse getServices() {
        String namespace = this.polarisDiscoveryProperties.getNamespace();
        GetServicesRequest request = new GetServicesRequest();
        request.setNamespace(namespace);
        return this.polarisConsumer.getServices(request);
    }
}

