/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.extend.consul;

import com.tencent.cloud.common.constant.ContextConstant;
import com.tencent.cloud.polaris.context.PolarisConfigModifier;
import com.tencent.cloud.polaris.extend.consul.ConsulContextProperties;
import com.tencent.polaris.factory.config.ConfigurationImpl;
import com.tencent.polaris.factory.config.consumer.DiscoveryConfigImpl;
import com.tencent.polaris.factory.config.global.ServerConnectorConfigImpl;
import com.tencent.polaris.factory.config.provider.RegisterConfigImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ConsulConfigModifier
implements PolarisConfigModifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulConfigModifier.class);
    private static final String ID = "consul";
    private final ConsulContextProperties consulContextProperties;

    public ConsulConfigModifier(ConsulContextProperties consulContextProperties) {
        this.consulContextProperties = consulContextProperties;
    }

    public void modify(ConfigurationImpl configuration) {
        if (this.consulContextProperties != null && this.consulContextProperties.isEnabled()) {
            boolean consulAvailable = false;
            try {
                consulAvailable = null != Class.forName("com.ecwid.consul.v1.ConsulClient");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!consulAvailable) {
                LOGGER.error("Please import \"connector-consul\" dependency when enabling consul service registration and discovery.\nAdd dependency configuration below to pom.xml:\n<dependency>\n\t<groupId>com.tencent.polaris</groupId>\n\t<artifactId>connector-consul</artifactId>\n</dependency>");
                throw new RuntimeException("Dependency \"connector-consul\" not found.");
            }
            if (CollectionUtils.isEmpty((Collection)configuration.getGlobal().getServerConnectors())) {
                configuration.getGlobal().setServerConnectors(new ArrayList());
            }
            if (CollectionUtils.isEmpty((Collection)configuration.getGlobal().getServerConnectors()) && null != configuration.getGlobal().getServerConnector()) {
                configuration.getGlobal().getServerConnectors().add(configuration.getGlobal().getServerConnector());
            }
            ServerConnectorConfigImpl serverConnectorConfig = new ServerConnectorConfigImpl();
            serverConnectorConfig.setId(ID);
            serverConnectorConfig.setAddresses(Collections.singletonList(this.consulContextProperties.getHost() + ":" + this.consulContextProperties.getPort()));
            serverConnectorConfig.setProtocol(ID);
            Map metadata = serverConnectorConfig.getMetadata();
            if (StringUtils.isNotBlank((String)this.consulContextProperties.getServiceName())) {
                metadata.put("SERVICE_NAME_KEY", this.consulContextProperties.getServiceName());
            }
            if (StringUtils.isNotBlank((String)this.consulContextProperties.getInstanceId())) {
                metadata.put("INSTANCE_ID_KEY", this.consulContextProperties.getInstanceId());
            }
            if (this.consulContextProperties.isPreferIpAddress() && StringUtils.isNotBlank((String)this.consulContextProperties.getIpAddress())) {
                metadata.put("PREFER_IP_ADDRESS_KEY", String.valueOf(this.consulContextProperties.isPreferIpAddress()));
                metadata.put("IP_ADDRESS_KEY", this.consulContextProperties.getIpAddress());
            }
            configuration.getGlobal().getServerConnectors().add(serverConnectorConfig);
            DiscoveryConfigImpl discoveryConfig = new DiscoveryConfigImpl();
            discoveryConfig.setServerConnectorId(ID);
            discoveryConfig.setEnable(Boolean.valueOf(this.consulContextProperties.isDiscoveryEnabled()));
            configuration.getConsumer().getDiscoveries().add(discoveryConfig);
            RegisterConfigImpl registerConfig = new RegisterConfigImpl();
            registerConfig.setServerConnectorId(ID);
            registerConfig.setEnable(this.consulContextProperties.isRegister());
            configuration.getProvider().getRegisters().add(registerConfig);
        }
    }

    public int getOrder() {
        return ContextConstant.ModifierOrder.LAST;
    }
}

