/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.registry;

import com.tencent.cloud.polaris.registry.PolarisRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.serviceregistry.AbstractAutoServiceRegistration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.util.StringUtils;

public class PolarisAutoServiceRegistration
extends AbstractAutoServiceRegistration<PolarisRegistration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisAutoServiceRegistration.class);
    private final PolarisRegistration registration;

    public PolarisAutoServiceRegistration(ServiceRegistry<PolarisRegistration> serviceRegistry, AutoServiceRegistrationProperties autoServiceRegistrationProperties, PolarisRegistration registration) {
        super(serviceRegistry, autoServiceRegistrationProperties);
        this.registration = registration;
    }

    protected PolarisRegistration getRegistration() {
        return this.registration;
    }

    protected PolarisRegistration getManagementRegistration() {
        return null;
    }

    protected void register() {
        if (!this.registration.isRegisterEnabled()) {
            LOGGER.debug("Registration disabled.");
            return;
        }
        super.register();
    }

    protected void registerManagement() {
        if (!this.registration.isRegisterEnabled()) {
            return;
        }
        super.registerManagement();
    }

    protected Object getConfiguration() {
        return this.registration.getPolarisProperties();
    }

    protected boolean isEnabled() {
        return this.registration.isRegisterEnabled();
    }

    protected String getAppName() {
        String appName = this.registration.getPolarisProperties().getService();
        return StringUtils.isEmpty((Object)appName) ? super.getAppName() : appName;
    }
}

