/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.registry;

import com.tencent.cloud.common.metadata.StaticMetadataManager;
import com.tencent.cloud.polaris.PolarisDiscoveryProperties;
import com.tencent.cloud.polaris.context.config.PolarisContextProperties;
import com.tencent.cloud.polaris.extend.consul.ConsulContextProperties;
import com.tencent.cloud.polaris.extend.nacos.NacosContextProperties;
import com.tencent.polaris.client.api.SDKContext;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.web.reactive.context.ReactiveWebServerApplicationContext;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public class PolarisRegistration
implements Registration {
    private static final String METADATA_KEY_IP = "internal-ip";
    private static final String METADATA_KEY_ADDRESS = "internal-address";
    private static final String GROUP_SERVER_ID_FORMAT = "%s__%s";
    private static final String NACOS_CLUSTER = "nacos.cluster";
    private final PolarisDiscoveryProperties polarisDiscoveryProperties;
    private final ConsulContextProperties consulContextProperties;
    private final SDKContext polarisContext;
    private final StaticMetadataManager staticMetadataManager;
    private final NacosContextProperties nacosContextProperties;
    private final ServletWebServerApplicationContext servletWebServerApplicationContext;
    private final ReactiveWebServerApplicationContext reactiveWebServerApplicationContext;
    private Map<String, String> metadata;
    private String host;
    private int port;
    private String instanceId;

    public PolarisRegistration(PolarisDiscoveryProperties polarisDiscoveryProperties, @Nullable PolarisContextProperties polarisContextProperties, @Nullable ConsulContextProperties consulContextProperties, SDKContext context, StaticMetadataManager staticMetadataManager, @Nullable NacosContextProperties nacosContextProperties, @Nullable ServletWebServerApplicationContext servletWebServerApplicationContext, @Nullable ReactiveWebServerApplicationContext reactiveWebServerApplicationContext) {
        this.polarisDiscoveryProperties = polarisDiscoveryProperties;
        this.consulContextProperties = consulContextProperties;
        this.polarisContext = context;
        this.staticMetadataManager = staticMetadataManager;
        this.nacosContextProperties = nacosContextProperties;
        this.servletWebServerApplicationContext = servletWebServerApplicationContext;
        this.reactiveWebServerApplicationContext = reactiveWebServerApplicationContext;
        this.host = this.polarisContext.getConfig().getGlobal().getAPI().getBindIP();
        if (polarisContextProperties != null) {
            this.port = polarisContextProperties.getLocalPort();
        }
    }

    public String getServiceId() {
        if (Objects.isNull(this.nacosContextProperties)) {
            return this.polarisDiscoveryProperties.getService();
        }
        String group = this.nacosContextProperties.getGroup();
        if (StringUtils.isNotBlank((String)group) && !"DEFAULT_GROUP".equals(group)) {
            return String.format(GROUP_SERVER_ID_FORMAT, group, this.polarisDiscoveryProperties.getService());
        }
        return this.polarisDiscoveryProperties.getService();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        if (this.port <= 0) {
            if (this.servletWebServerApplicationContext != null) {
                this.port = this.servletWebServerApplicationContext.getWebServer().getPort();
            } else if (this.reactiveWebServerApplicationContext != null) {
                this.port = this.reactiveWebServerApplicationContext.getWebServer().getPort();
            } else {
                throw new RuntimeException("Unsupported web type.");
            }
        }
        return this.port;
    }

    protected void setPort(int port) {
        this.port = port;
    }

    public boolean isSecure() {
        return StringUtils.equalsIgnoreCase((String)this.polarisDiscoveryProperties.getProtocol(), (String)"https");
    }

    public URI getUri() {
        return DefaultServiceInstance.getUri((ServiceInstance)this);
    }

    public Map<String, String> getMetadata() {
        if (CollectionUtils.isEmpty(this.metadata)) {
            HashMap<String, String> instanceMetadata = new HashMap<String, String>();
            instanceMetadata.put(METADATA_KEY_IP, this.host);
            instanceMetadata.put(METADATA_KEY_ADDRESS, this.host + ":" + this.port);
            String clusterName = this.nacosContextProperties.getClusterName();
            if (StringUtils.isNotBlank((String)clusterName) && !"DEFAULT".equals(clusterName)) {
                instanceMetadata.put(NACOS_CLUSTER, clusterName);
            }
            instanceMetadata.putAll(this.staticMetadataManager.getMergedStaticMetadata());
            this.metadata = instanceMetadata;
        }
        return this.metadata;
    }

    public PolarisDiscoveryProperties getPolarisProperties() {
        return this.polarisDiscoveryProperties;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    protected void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public boolean isRegisterEnabled() {
        boolean registerEnabled = false;
        if (null != this.polarisDiscoveryProperties) {
            registerEnabled = this.polarisDiscoveryProperties.isRegisterEnabled();
        }
        if (null != this.consulContextProperties && this.consulContextProperties.isEnabled()) {
            registerEnabled |= this.consulContextProperties.isRegister();
        }
        if (null != this.nacosContextProperties && this.nacosContextProperties.isEnabled()) {
            registerEnabled |= this.nacosContextProperties.isRegisterEnabled();
        }
        return registerEnabled;
    }

    public String toString() {
        return "PolarisRegistration{ polarisDiscoveryProperties=" + this.polarisDiscoveryProperties + ", polarisContext=" + this.polarisContext + ", staticMetadataManager=" + this.staticMetadataManager + ", metadata=" + this.metadata + ", host='" + this.host + "', instanceId='" + this.instanceId + "'}";
    }
}

