/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class OkHttpUtil {
    public static final Logger LOGGER = LoggerFactory.getLogger(OkHttpUtil.class);

    private OkHttpUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean get(String path, Map<String, String> headers) {
        HttpURLConnection conn = null;
        try {
            String str;
            URL url = new URL(path);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(2L));
            conn.setReadTimeout((int)TimeUnit.SECONDS.toMillis(2L));
            if (!CollectionUtils.isEmpty(headers)) {
                headers.forEach(conn::setRequestProperty);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuffer buffer = new StringBuffer();
            while ((str = reader.readLine()) != null) {
                buffer.append(str);
            }
            String responseBody = buffer.toString();
            if (conn.getResponseCode() == 200 && StringUtils.hasText((String)responseBody)) {
                LOGGER.debug("exec get request, url: {} success, response data: {}", (Object)url, (Object)responseBody);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            LOGGER.error("exec get request, url: {} failed!", (Object)path, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
        return false;
    }
}

