/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.registry.consul.client;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.model.NewService;
import com.ecwid.consul.v1.health.model.HealthService;
import com.ecwid.consul.v1.kv.model.GetValue;
import com.weibo.api.motan.registry.consul.ConsulConstants;
import com.weibo.api.motan.registry.consul.ConsulResponse;
import com.weibo.api.motan.registry.consul.ConsulService;
import com.weibo.api.motan.registry.consul.ConsulUtils;
import com.weibo.api.motan.registry.consul.client.MotanConsulClient;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class ConsulEcwidClient
extends MotanConsulClient {
    public static ConsulClient client;

    public ConsulEcwidClient(String host, int port) {
        super(host, port);
        client = new ConsulClient(host + ":" + port);
        LoggerUtil.info((String)("ConsulEcwidClient init finish. client host:" + host + ", port:" + port));
    }

    @Override
    public void checkPass(String serviceid) {
        client.agentCheckPass("service:" + serviceid);
    }

    @Override
    public void registerService(ConsulService service) {
        NewService newService = this.convertService(service);
        client.agentServiceRegister(newService);
    }

    @Override
    public void unregisterService(String serviceid) {
        client.agentServiceDeregister(serviceid);
    }

    @Override
    public ConsulResponse<List<ConsulService>> lookupHealthService(String serviceName, long lastConsulIndex) {
        QueryParams queryParams = new QueryParams(ConsulConstants.CONSUL_BLOCK_TIME_SECONDS, lastConsulIndex);
        Response orgResponse = client.getHealthServices(serviceName, true, queryParams);
        ConsulResponse<ArrayList<ConsulService>> newResponse = null;
        if (orgResponse != null && orgResponse.getValue() != null && !((List)orgResponse.getValue()).isEmpty()) {
            List HealthServices = (List)orgResponse.getValue();
            ArrayList<ConsulService> ConsulServcies = new ArrayList<ConsulService>(HealthServices.size());
            for (HealthService orgService : HealthServices) {
                try {
                    ConsulService newService = this.convertToConsulService(orgService);
                    ConsulServcies.add(newService);
                }
                catch (Exception e) {
                    String servcieid = "null";
                    if (orgService.getService() != null) {
                        servcieid = orgService.getService().getId();
                    }
                    LoggerUtil.error((String)("convert consul service fail. org consulservice:" + servcieid), (Throwable)e);
                }
            }
            if (!ConsulServcies.isEmpty()) {
                newResponse = new ConsulResponse<ArrayList<ConsulService>>();
                newResponse.setValue(ConsulServcies);
                newResponse.setConsulIndex(orgResponse.getConsulIndex());
                newResponse.setConsulLastContact(orgResponse.getConsulLastContact());
                newResponse.setConsulKnownLeader(orgResponse.isConsulKnownLeader());
            }
        }
        return newResponse;
    }

    @Override
    public String lookupCommand(String group) {
        Response response = client.getKVValue("motan/command/" + ConsulUtils.convertGroupToServiceName(group));
        GetValue value = (GetValue)response.getValue();
        String command = "";
        if (value == null) {
            LoggerUtil.info((String)("no command in group: " + group));
        } else if (value.getValue() != null) {
            command = new String(Base64.decodeBase64((String)value.getValue()));
        }
        return command;
    }

    private NewService convertService(ConsulService service) {
        NewService newService = new NewService();
        newService.setAddress(service.getAddress());
        newService.setId(service.getId());
        newService.setName(service.getName());
        newService.setPort(service.getPort());
        newService.setTags(service.getTags());
        NewService.Check check = new NewService.Check();
        check.setTtl(service.getTtl() + "s");
        newService.setCheck(check);
        return newService;
    }

    private ConsulService convertToConsulService(HealthService healthService) {
        ConsulService service = new ConsulService();
        HealthService.Service org = healthService.getService();
        service.setAddress(org.getAddress());
        service.setId(org.getId());
        service.setName(org.getService());
        service.setPort(org.getPort());
        service.setTags(org.getTags());
        return service;
    }

    @Override
    public void checkFail(String serviceid) {
        client.agentCheckFail("service:" + serviceid);
    }
}

