/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.yar;

import com.weibo.yar.YarException;
import com.weibo.yar.YarHeader;
import com.weibo.yar.YarRequest;
import com.weibo.yar.YarResponse;
import com.weibo.yar.packager.Packager;
import com.weibo.yar.packager.PackagerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class YarProtocol {
    public static byte[] toProtocolBytes(YarRequest request) throws IOException {
        if (request == null) {
            throw new YarException("YarRequest is null");
        }
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("i", request.getId());
        requestMap.put("m", request.getMethodName());
        requestMap.put("p", Arrays.asList(request.getParameters()));
        String packagerName = request.getPackagerName();
        return YarProtocol.toProtocolBytes(request.getId(), packagerName, requestMap);
    }

    public static byte[] toProtocolBytes(YarResponse response) throws IOException {
        if (response == null) {
            throw new YarException("YarResponse is null");
        }
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("i", response.getId());
        responseMap.put("s", response.getStatus());
        if (response.getRet() != null) {
            responseMap.put("r", response.getRet());
        }
        if (response.getOutput() != null) {
            responseMap.put("o", response.getOutput());
        }
        if (response.getError() != null) {
            responseMap.put("e", response.getError());
        }
        String packagerName = response.getPackagerName();
        return YarProtocol.toProtocolBytes(response.getId(), packagerName, responseMap);
    }

    public static YarRequest buildRequest(byte[] requestBytes) throws IOException {
        if (requestBytes == null) {
            throw new YarException("request bytes is null");
        }
        Map contentMap = YarProtocol.fetchContent(requestBytes);
        YarRequest request = new YarRequest();
        if (contentMap.containsKey("i")) {
            request.setId(((Number)contentMap.get("i")).longValue());
        }
        request.setPackagerName((String)contentMap.get("ext-packagerName"));
        if (contentMap.containsKey("m")) {
            request.setMethodName(contentMap.get("m").toString());
        }
        if (contentMap.containsKey("p")) {
            Object value = contentMap.get("p");
            if (value instanceof List) {
                request.setParameters(((List)value).toArray());
            } else if (value instanceof Map) {
                request.setParameters(((Map)value).values().toArray());
            }
        }
        return request;
    }

    public static YarResponse buildResponse(byte[] responseBytes) throws IOException {
        if (responseBytes == null) {
            throw new YarException("response bytes is null");
        }
        Map contentMap = YarProtocol.fetchContent(responseBytes);
        YarResponse response = new YarResponse();
        response.setPackagerName((String)contentMap.get("ext-packagerName"));
        if (contentMap.containsKey("i")) {
            response.setId(((Number)contentMap.get("i")).longValue());
        }
        if (contentMap.containsKey("s")) {
            response.setStatus(contentMap.get("s").toString());
        }
        if (contentMap.containsKey("o")) {
            response.setOutput(contentMap.get("o"));
        }
        if (contentMap.containsKey("e")) {
            response.setError(contentMap.get("e").toString());
        }
        if (contentMap.containsKey("r")) {
            response.setRet(contentMap.get("r"));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] toProtocolBytes(long id, String packagerName, Map<String, Object> params) throws IOException {
        byte[] bodyBytes;
        Packager packager = PackagerFactory.createPackager(packagerName);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            out.write(Arrays.copyOf(packagerName.toUpperCase().getBytes(), 8));
            out.write(packager.encode(params));
            bodyBytes = out.toByteArray();
        }
        YarHeader header = new YarHeader();
        header.setBodyLenght(bodyBytes.length);
        header.setRequestId(id);
        try (ByteArrayOutputStream totalByteArrayOutputStream = new ByteArrayOutputStream(82 + bodyBytes.length);){
            totalByteArrayOutputStream.write(header.toBytes());
            totalByteArrayOutputStream.write(bodyBytes);
            byte[] byArray = totalByteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    private static Map fetchContent(byte[] bytes) throws IOException {
        int length;
        ByteArrayInputStream responseInputStream = new ByteArrayInputStream(bytes);
        byte[] headerBytes = new byte[82];
        responseInputStream.read(headerBytes);
        YarHeader header = YarHeader.fromBytes(headerBytes);
        byte[] packagerNameBytes = new byte[8];
        responseInputStream.read(packagerNameBytes);
        for (length = 0; length < packagerNameBytes.length && packagerNameBytes[length] != 0; ++length) {
        }
        String packagerName = new String(packagerNameBytes, 0, length);
        byte[] bodyBytes = new byte[(int)(header.getBodyLenght() - 8L)];
        responseInputStream.read(bodyBytes);
        Packager packager = PackagerFactory.createPackager(packagerName);
        Map content = packager.decode(bodyBytes, Map.class);
        content.put("ext-packagerName", packagerName);
        content.put("ext-protocol-header", header);
        return content;
    }
}

