/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.yar.packager;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.weibo.yar.codec.PHPUnserializer;
import com.weibo.yar.packager.Packager;
import de.ailis.pherialize.Mixed;
import de.ailis.pherialize.Pherialize;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class PherializePackager
implements Packager {
    @Override
    public <E> byte[] encode(E value) throws IOException {
        return Pherialize.serialize(value).getBytes();
    }

    @Override
    public <E> E decode(byte[] data, Class<E> messageType) throws IOException {
        PHPUnserializer unserializer = new PHPUnserializer(new String(data, 0, data.length, "ISO-8859-1"));
        Mixed mixed = unserializer.unserializeObject();
        Object o = this.convert(mixed);
        return (E)new ObjectMapper().convertValue(o, messageType);
    }

    private Object convert(Mixed mixed) throws UnsupportedEncodingException {
        if (mixed == null) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (mixed.getType() != 9) {
            return this.convertNonArray(mixed);
        }
        boolean flag = true;
        int counter = 0;
        for (Map.Entry entry : mixed.toArray().entrySet()) {
            Mixed mixedKey = (Mixed)entry.getKey();
            map.put(mixedKey.toString(), this.convert((Mixed)entry.getValue()));
            if (!flag || (mixedKey.isInt() || mixedKey.isLong()) && (long)counter++ == mixedKey.toLong()) continue;
            flag = false;
        }
        if (flag && map.size() > 0) {
            return new ArrayList(map.values());
        }
        return map;
    }

    private Object convertNonArray(Mixed mixed) throws UnsupportedEncodingException {
        switch (mixed.getType()) {
            case 7: {
                return mixed.toBoolean();
            }
            case 0: 
            case 8: {
                return new String(mixed.toString().getBytes("ISO-8859-1"), "UTF-8");
            }
            case -1: 
            case 9: {
                if (mixed.getValue() == null) {
                    return null;
                }
                throw new UnsupportedOperationException("unknown type: " + mixed.getType());
            }
            case 5: 
            case 6: {
                return mixed.toDouble();
            }
        }
        return mixed.toLong();
    }
}

