/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.core.ComponentInitializer;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.core.ScriptComponent;
import com.yomahub.liteflow.enums.FlowParserTypeEnum;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.exception.ComponentCannotRegisterException;
import com.yomahub.liteflow.exception.NullNodeTypeException;
import com.yomahub.liteflow.flow.element.Chain;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.parser.el.LocalJsonFlowELParser;
import com.yomahub.liteflow.parser.el.LocalXmlFlowELParser;
import com.yomahub.liteflow.parser.el.LocalYmlFlowELParser;
import com.yomahub.liteflow.script.ScriptExecutorFactory;
import com.yomahub.liteflow.script.exception.ScriptLoadException;
import com.yomahub.liteflow.script.exception.ScriptSpiException;
import com.yomahub.liteflow.spi.ContextAware;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import com.yomahub.liteflow.spi.local.LocalContextAware;
import com.yomahub.liteflow.util.CopyOnWriteHashMap;
import com.yomahub.liteflow.util.LiteFlowProxyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FlowBus {
    private static final LFLog LOG = LFLoggerManager.getLogger(FlowBus.class);
    private static final Map<String, Chain> chainMap = new CopyOnWriteHashMap<String, Chain>();
    private static final Map<String, Node> nodeMap = new CopyOnWriteHashMap<String, Node>();

    private FlowBus() {
    }

    public static Chain getChain(String id) {
        return chainMap.get(id);
    }

    public static void addChain(String chainName) {
        if (!chainMap.containsKey(chainName)) {
            chainMap.put(chainName, new Chain(chainName));
        }
    }

    public static void addChain(Chain chain) {
        chainMap.put(chain.getChainId(), chain);
    }

    public static boolean containChain(String chainId) {
        return chainMap.containsKey(chainId);
    }

    public static boolean needInit() {
        return MapUtil.isEmpty(chainMap);
    }

    public static boolean containNode(String nodeId) {
        return nodeMap.containsKey(nodeId);
    }

    public static void addManagedNode(String nodeId, NodeComponent nodeComponent) {
        NodeTypeEnum type = NodeTypeEnum.guessType(nodeComponent.getClass());
        if (type == null) {
            throw new NullNodeTypeException(StrUtil.format((CharSequence)"node type is null for node[{}]", (Object[])new Object[]{nodeId}));
        }
        nodeMap.put(nodeId, new Node(ComponentInitializer.loadInstance().initComponent(nodeComponent, type, nodeComponent.getName(), nodeId)));
    }

    public static void addNode(String nodeId, String name, NodeTypeEnum type, Class<?> cmpClazz) {
        FlowBus.addNode(nodeId, name, type, cmpClazz, null, null);
    }

    public static void addNode(String nodeId, String name, NodeTypeEnum nodeType, String cmpClazzStr) {
        Class<?> cmpClazz;
        try {
            cmpClazz = Class.forName(cmpClazzStr);
        }
        catch (Exception e) {
            throw new ComponentCannotRegisterException(e.getMessage());
        }
        FlowBus.addNode(nodeId, name, nodeType, cmpClazz, null, null);
    }

    public static void addScriptNode(String nodeId, String name, NodeTypeEnum nodeType, String script, String language) {
        FlowBus.addNode(nodeId, name, nodeType, ScriptComponent.ScriptComponentClassMap.get((Object)nodeType), script, language);
    }

    private static void addNode(String nodeId, String name, NodeTypeEnum type, Class<?> cmpClazz, String script, String language) {
        try {
            List<Object> cmpInstances = new ArrayList();
            if (LiteFlowProxyUtil.isDeclareCmp(cmpClazz)) {
                ContextAware contextAware = ContextAwareHolder.loadContextAware();
                Object bean = ContextAwareHolder.loadContextAware().registerBean(nodeId, cmpClazz);
                cmpInstances = LocalContextAware.class.isAssignableFrom(contextAware.getClass()) ? LiteFlowProxyUtil.proxy2NodeComponent(bean, nodeId) : ListUtil.toList((Object[])new NodeComponent[]{(NodeComponent)bean});
            } else {
                if (!type.isScript()) {
                    cmpInstances = ListUtil.toList((Object[])new NodeComponent[]{(NodeComponent)ContextAwareHolder.loadContextAware().registerOrGet(nodeId, cmpClazz)});
                }
                cmpInstances.remove(null);
                if (cmpInstances.isEmpty()) {
                    NodeComponent cmpInstance2 = (NodeComponent)cmpClazz.newInstance();
                    cmpInstances.add(cmpInstance2);
                }
            }
            cmpInstances = cmpInstances.stream().map(cmpInstance -> ComponentInitializer.loadInstance().initComponent((NodeComponent)cmpInstance, type, name, cmpInstance.getNodeId() == null ? nodeId : cmpInstance.getNodeId())).collect(Collectors.toList());
            List nodes = cmpInstances.stream().map(Node::new).collect(Collectors.toList());
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = (Node)nodes.get(i);
                NodeComponent cmpInstance3 = (NodeComponent)cmpInstances.get(i);
                if (type.isScript()) {
                    if (StrUtil.isNotBlank((CharSequence)script)) {
                        node.setScript(script);
                        node.setLanguage(language);
                        ((ScriptComponent)((Object)cmpInstance3)).loadScript(script, language);
                    } else {
                        String errorMsg = StrUtil.format((CharSequence)"script for node[{}] is empty", (Object[])new Object[]{nodeId});
                        throw new ScriptLoadException(errorMsg);
                    }
                }
                String activeNodeId = StrUtil.isEmpty((CharSequence)cmpInstance3.getNodeId()) ? nodeId : cmpInstance3.getNodeId();
                nodeMap.put(activeNodeId, node);
            }
        }
        catch (Exception e) {
            String error = StrUtil.format((CharSequence)"component[{}] register error", (Object[])new Object[]{StrUtil.isEmpty((CharSequence)name) ? nodeId : StrUtil.format((CharSequence)"{}({})", (Object[])new Object[]{nodeId, name})});
            LOG.error(e.getMessage());
            throw new ComponentCannotRegisterException(StrUtil.format((CharSequence)"{} {}", (Object[])new Object[]{error, e.getMessage()}));
        }
    }

    public static Node getNode(String nodeId) {
        return nodeMap.get(nodeId);
    }

    public static Map<String, Node> getNodeMap() {
        return nodeMap;
    }

    public static Map<String, Chain> getChainMap() {
        return chainMap;
    }

    public static void cleanCache() {
        chainMap.clear();
        nodeMap.clear();
        FlowBus.cleanScriptCache();
    }

    public static void cleanScriptCache() {
        try {
            ScriptExecutorFactory.loadInstance().cleanScriptCache();
        }
        catch (ScriptSpiException scriptSpiException) {
            // empty catch block
        }
    }

    public static void refreshFlowMetaData(FlowParserTypeEnum type, String content) throws Exception {
        if (type.equals((Object)FlowParserTypeEnum.TYPE_EL_XML)) {
            new LocalXmlFlowELParser().parse(content);
        } else if (type.equals((Object)FlowParserTypeEnum.TYPE_EL_JSON)) {
            new LocalJsonFlowELParser().parse(content);
        } else if (type.equals((Object)FlowParserTypeEnum.TYPE_EL_YML)) {
            new LocalYmlFlowELParser().parse(content);
        }
    }

    public static boolean removeChain(String chainId) {
        if (FlowBus.containChain(chainId)) {
            chainMap.remove(chainId);
            return true;
        }
        String errMsg = StrUtil.format((CharSequence)"cannot find the chain[{}]", (Object[])new Object[]{chainId});
        LOG.error(errMsg);
        return false;
    }

    public static void removeChain(String ... chainIds) {
        Arrays.stream(chainIds).forEach(FlowBus::removeChain);
    }
}

