/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element.condition;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.exception.WhenExecuteException;
import com.yomahub.liteflow.flow.element.Condition;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.condition.FinallyCondition;
import com.yomahub.liteflow.flow.element.condition.PreCondition;
import com.yomahub.liteflow.flow.parallel.CompletableFutureTimeout;
import com.yomahub.liteflow.flow.parallel.ParallelSupplier;
import com.yomahub.liteflow.flow.parallel.WhenFutureObj;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import com.yomahub.liteflow.thread.ExecutorHelper;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class WhenCondition
extends Condition {
    private final LFLog LOG = LFLoggerManager.getLogger(this.getClass());
    private boolean ignoreError = false;
    private String group = "default";
    private boolean any = false;
    private String threadExecutorClass;
    private Integer maxWaitTime;
    private TimeUnit maxWaitTimeUnit;

    @Override
    public void executeCondition(Integer slotIndex) throws Exception {
        this.executeAsyncCondition(slotIndex);
    }

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.TYPE_WHEN;
    }

    private void executeAsyncCondition(Integer slotIndex) throws Exception {
        Slot slot = DataBus.getSlot(slotIndex);
        String currChainName = this.getCurrChainId();
        ExecutorService parallelExecutor = ExecutorHelper.loadInstance().buildWhenExecutor(this.getThreadExecutorClass());
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        boolean[] interrupted = new boolean[]{false};
        if (ObjectUtil.isNull((Object)this.getMaxWaitTime())) {
            if (ObjectUtil.isNotNull((Object)liteflowConfig.getWhenMaxWaitSeconds())) {
                this.setMaxWaitTime(liteflowConfig.getWhenMaxWaitSeconds());
                this.setMaxWaitTimeUnit(TimeUnit.SECONDS);
            } else {
                this.setMaxWaitTime(liteflowConfig.getWhenMaxWaitTime());
            }
        }
        if (ObjectUtil.isNull((Object)((Object)this.getMaxWaitTimeUnit()))) {
            this.setMaxWaitTimeUnit(liteflowConfig.getWhenMaxWaitTimeUnit());
        }
        List<CompletableFuture> completableFutureList = this.getExecutableList().stream().filter(executable -> !(executable instanceof PreCondition) && !(executable instanceof FinallyCondition)).filter(executable -> {
            try {
                return executable.isAccess(slotIndex);
            }
            catch (Exception e) {
                this.LOG.error("there was an error when executing the when component isAccess", e);
                return false;
            }
        }).map(executable -> CompletableFutureTimeout.completeOnTimeout(WhenFutureObj.timeOut(executable.getId()), CompletableFuture.supplyAsync(new ParallelSupplier((Executable)executable, currChainName, slotIndex), parallelExecutor), this.getMaxWaitTime().intValue(), this.getMaxWaitTimeUnit())).collect(Collectors.toList());
        CompletableFuture<Object> resultCompletableFuture = this.isAny() ? CompletableFuture.anyOf(completableFutureList.toArray(new CompletableFuture[0])) : CompletableFuture.allOf(completableFutureList.toArray(new CompletableFuture[0]));
        try {
            resultCompletableFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.LOG.error("there was an error when executing the CompletableFuture", e);
            interrupted[0] = true;
        }
        List allCompletableWhenFutureObjList = completableFutureList.stream().filter(f -> {
            if (f.isDone()) {
                return true;
            }
            f.cancel(true);
            return false;
        }).map(f -> {
            try {
                return (WhenFutureObj)f.get();
            }
            catch (InterruptedException | ExecutionException e) {
                interrupted[0] = true;
                return null;
            }
        }).collect(Collectors.toList());
        List<WhenFutureObj> timeOutWhenFutureObjList = allCompletableWhenFutureObjList.stream().filter(WhenFutureObj::isTimeout).collect(Collectors.toList());
        timeOutWhenFutureObjList.forEach(whenFutureObj -> this.LOG.warn("executing thread has reached max-wait-seconds, thread canceled.Execute-item: [{}]", (Object)whenFutureObj.getExecutorName()));
        if (!this.isIgnoreError()) {
            if (interrupted[0]) {
                throw new WhenExecuteException(StrUtil.format((CharSequence)"requestId [{}] when execute interrupted. errorResume [false].", (Object[])new Object[]{slot.getRequestId()}));
            }
            for (WhenFutureObj whenFutureObj2 : allCompletableWhenFutureObjList) {
                if (whenFutureObj2.isSuccess()) continue;
                this.LOG.info(StrUtil.format((CharSequence)"when-executor[{}] execute failed. errorResume [false].", (Object[])new Object[]{whenFutureObj2.getExecutorName()}));
                throw whenFutureObj2.getEx();
            }
        } else if (interrupted[0]) {
            this.LOG.warn("executing when condition timeout , but ignore with errorResume.");
        }
    }

    public boolean isIgnoreError() {
        return this.ignoreError;
    }

    public void setIgnoreError(boolean ignoreError) {
        this.ignoreError = ignoreError;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isAny() {
        return this.any;
    }

    public void setAny(boolean any) {
        this.any = any;
    }

    public String getThreadExecutorClass() {
        return this.threadExecutorClass;
    }

    public void setThreadExecutorClass(String threadExecutorClass) {
        this.threadExecutorClass = threadExecutorClass;
    }

    public Integer getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public void setMaxWaitTime(Integer maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public TimeUnit getMaxWaitTimeUnit() {
        return this.maxWaitTimeUnit;
    }

    public void setMaxWaitTimeUnit(TimeUnit maxWaitTimeUnit) {
        this.maxWaitTimeUnit = maxWaitTimeUnit;
    }
}

