/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.entity;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.enums.CmpStepTypeEnum;

public class CmpStep {
    private String nodeId;
    private String nodeName;
    private String tag;
    private CmpStepTypeEnum stepType;
    private Long timeSpent;
    private boolean success;
    private Exception exception;
    private NodeComponent instance;
    private Long rollbackTimeSpent;

    public CmpStep(String nodeId, String nodeName, CmpStepTypeEnum stepType) {
        this.nodeId = nodeId;
        this.nodeName = nodeName;
        this.stepType = stepType;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public CmpStepTypeEnum getStepType() {
        return this.stepType;
    }

    public void setStepType(CmpStepTypeEnum stepType) {
        this.stepType = stepType;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public Long getTimeSpent() {
        return this.timeSpent;
    }

    public void setTimeSpent(Long timeSpent) {
        this.timeSpent = timeSpent;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public NodeComponent getInstance() {
        return this.instance;
    }

    public void setInstance(NodeComponent instance) {
        this.instance = instance;
    }

    public Long getRollbackTimeSpent() {
        return this.rollbackTimeSpent;
    }

    public void setRollbackTimeSpent(Long rollbackTimeSpent) {
        this.rollbackTimeSpent = rollbackTimeSpent;
    }

    public String buildString() {
        if (this.stepType.equals((Object)CmpStepTypeEnum.SINGLE)) {
            if (StrUtil.isBlank((CharSequence)this.nodeName)) {
                return StrUtil.format((CharSequence)"{}", (Object[])new Object[]{this.nodeId});
            }
            return StrUtil.format((CharSequence)"{}[{}]", (Object[])new Object[]{this.nodeId, this.nodeName});
        }
        return null;
    }

    public String buildStringWithTime() {
        if (this.stepType.equals((Object)CmpStepTypeEnum.SINGLE)) {
            if (StrUtil.isBlank((CharSequence)this.nodeName)) {
                if (this.timeSpent != null) {
                    return StrUtil.format((CharSequence)"{}<{}>", (Object[])new Object[]{this.nodeId, this.timeSpent});
                }
                return StrUtil.format((CharSequence)"{}", (Object[])new Object[]{this.nodeId});
            }
            if (this.timeSpent != null) {
                return StrUtil.format((CharSequence)"{}[{}]<{}>", (Object[])new Object[]{this.nodeId, this.nodeName, this.timeSpent});
            }
            return StrUtil.format((CharSequence)"{}[{}]", (Object[])new Object[]{this.nodeId, this.nodeName});
        }
        return null;
    }

    public String buildRollbackStringWithTime() {
        if (this.stepType.equals((Object)CmpStepTypeEnum.SINGLE)) {
            if (StrUtil.isBlank((CharSequence)this.nodeName)) {
                if (this.rollbackTimeSpent != null) {
                    return StrUtil.format((CharSequence)"{}<{}>", (Object[])new Object[]{this.nodeId, this.rollbackTimeSpent});
                }
                return StrUtil.format((CharSequence)"{}", (Object[])new Object[]{this.nodeId});
            }
            if (this.rollbackTimeSpent != null) {
                return StrUtil.format((CharSequence)"{}[{}]<{}>", (Object[])new Object[]{this.nodeId, this.nodeName, this.rollbackTimeSpent});
            }
            return StrUtil.format((CharSequence)"{}[{}]", (Object[])new Object[]{this.nodeId, this.nodeName});
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (ObjectUtil.isNull((Object)obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return ((CmpStep)obj).getNodeId().equals(this.getNodeId());
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }
}

