/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.id;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.exception.RequestIdGeneratorException;
import com.yomahub.liteflow.flow.id.DefaultRequestIdGenerator;
import com.yomahub.liteflow.flow.id.RequestIdGenerator;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;

public class IdGeneratorHolder {
    private RequestIdGenerator requestIdGenerator;
    private static IdGeneratorHolder INSTANCE;

    public static void init() {
        try {
            RequestIdGenerator requestIdGenerator;
            INSTANCE = new IdGeneratorHolder();
            LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
            String requestIdGeneratorClass = liteflowConfig.getRequestIdGeneratorClass();
            if (StrUtil.isBlank((CharSequence)requestIdGeneratorClass)) {
                requestIdGenerator = new DefaultRequestIdGenerator();
            } else {
                Class<?> idGenerateClass = Class.forName(requestIdGeneratorClass);
                requestIdGenerator = (RequestIdGenerator)ContextAwareHolder.loadContextAware().registerBean(idGenerateClass);
            }
            INSTANCE.setRequestIdGenerator(requestIdGenerator);
        }
        catch (Exception e) {
            throw new RequestIdGeneratorException(e.getMessage());
        }
    }

    public static IdGeneratorHolder getInstance() {
        return INSTANCE;
    }

    public String generate() {
        if (ObjectUtil.isNull((Object)this.requestIdGenerator)) {
            IdGeneratorHolder.init();
        }
        return this.requestIdGenerator.generate();
    }

    public RequestIdGenerator getRequestIdGenerator() {
        return this.requestIdGenerator;
    }

    public void setRequestIdGenerator(RequestIdGenerator requestIdGenerator) {
        this.requestIdGenerator = requestIdGenerator;
    }
}

