/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.helper;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.yomahub.liteflow.builder.LiteFlowNodeBuilder;
import com.yomahub.liteflow.builder.el.LiteFlowChainELBuilder;
import com.yomahub.liteflow.builder.prop.NodePropBean;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.exception.ChainDuplicateException;
import com.yomahub.liteflow.exception.NodeClassNotFoundException;
import com.yomahub.liteflow.exception.NodeTypeCanNotGuessException;
import com.yomahub.liteflow.exception.NodeTypeNotSupportException;
import com.yomahub.liteflow.exception.ParseException;
import com.yomahub.liteflow.flow.FlowBus;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;

public class ParserHelper {
    private ParserHelper() {
    }

    public static void buildNode(NodePropBean nodePropBean) {
        String id = nodePropBean.getId();
        String name = nodePropBean.getName();
        String clazz = nodePropBean.getClazz();
        String script = nodePropBean.getScript();
        String type = nodePropBean.getType();
        String file = nodePropBean.getFile();
        String language = nodePropBean.getLanguage();
        if (StrUtil.isNotBlank((CharSequence)clazz)) {
            try {
                Class<?> c = Class.forName(clazz);
                NodeTypeEnum nodeType = NodeTypeEnum.guessType(c);
                if (nodeType != null) {
                    type = nodeType.getCode();
                }
            }
            catch (Exception e) {
                throw new NodeClassNotFoundException(StrUtil.format((CharSequence)"cannot find the node[{}]", (Object[])new Object[]{clazz}));
            }
        }
        if (StrUtil.isBlank((CharSequence)type)) {
            throw new NodeTypeCanNotGuessException(StrUtil.format((CharSequence)"cannot guess the type of node[{}]", (Object[])new Object[]{clazz}));
        }
        NodeTypeEnum nodeTypeEnum = NodeTypeEnum.getEnumByCode(type);
        if (ObjectUtil.isNull((Object)((Object)nodeTypeEnum))) {
            throw new NodeTypeNotSupportException(StrUtil.format((CharSequence)"type [{}] is not support", (Object[])new Object[]{type}));
        }
        LiteFlowNodeBuilder.createNode().setId(id).setName(name).setClazz(clazz).setType(nodeTypeEnum).setScript(script).setFile(file).setLanguage(language).build();
    }

    public static void parseNodeDocument(List<Document> documentList) {
        for (Document document : documentList) {
            Element rootElement = document.getRootElement();
            Element nodesElement = rootElement.element("nodes");
            if (!ObjectUtil.isNotNull((Object)nodesElement)) continue;
            List nodeList = nodesElement.elements("node");
            for (Element e : nodeList) {
                String id = e.attributeValue("id");
                String name = e.attributeValue("name");
                String clazz = e.attributeValue("class");
                String type = e.attributeValue("type");
                String script = e.getText();
                String file = e.attributeValue("file");
                String language = e.attributeValue("language");
                NodePropBean nodePropBean = new NodePropBean().setId(id).setName(name).setClazz(clazz).setScript(script).setType(type).setFile(file).setLanguage(language);
                ParserHelper.buildNode(nodePropBean);
            }
        }
    }

    public static void parseChainDocument(List<Document> documentList, Set<String> chainNameSet, Consumer<Element> parseOneChainConsumer) {
        documentList.forEach(document -> {
            List chainList = document.getRootElement().elements("chain");
            chainList.forEach(e -> {
                String chainName = Optional.ofNullable(e.attributeValue("id")).orElse(e.attributeValue("name"));
                ParserHelper.checkChainId(chainName, e.getText());
                if (!chainNameSet.add(chainName)) {
                    throw new ChainDuplicateException(String.format("[chain name duplicate] chainName=%s", chainName));
                }
                FlowBus.addChain(chainName);
            });
        });
        chainNameSet.clear();
        for (Document document2 : documentList) {
            Element rootElement = document2.getRootElement();
            List chainList = rootElement.elements("chain");
            chainList.forEach(parseOneChainConsumer);
        }
    }

    public static void parseNodeJson(List<JsonNode> flowJsonObjectList) {
        for (JsonNode flowJsonNode : flowJsonObjectList) {
            if (!flowJsonNode.get("flow").has("nodes")) continue;
            Iterator nodeIterator = flowJsonNode.get("flow").get("nodes").get("node").elements();
            while (nodeIterator.hasNext()) {
                JsonNode nodeObject = (JsonNode)nodeIterator.next();
                String id = nodeObject.get("id").textValue();
                String name = nodeObject.hasNonNull("name") ? nodeObject.get("name").textValue() : "";
                String clazz = nodeObject.hasNonNull("class") ? nodeObject.get("class").textValue() : "";
                String type = nodeObject.hasNonNull("type") ? nodeObject.get("type").textValue() : null;
                String script = nodeObject.hasNonNull("value") ? nodeObject.get("value").textValue() : "";
                String file = nodeObject.hasNonNull("file") ? nodeObject.get("file").textValue() : "";
                NodePropBean nodePropBean = new NodePropBean().setId(id).setName(name).setClazz(clazz).setScript(script).setType(type).setFile(file);
                ParserHelper.buildNode(nodePropBean);
            }
        }
    }

    public static void parseChainJson(List<JsonNode> flowJsonObjectList, Set<String> chainNameSet, Consumer<JsonNode> parseOneChainConsumer) {
        flowJsonObjectList.forEach(jsonObject -> {
            Iterator iterator = jsonObject.get("flow").get("chain").elements();
            while (iterator.hasNext()) {
                JsonNode innerJsonObject = (JsonNode)iterator.next();
                JsonNode chainNameJsonNode = Optional.ofNullable(innerJsonObject.get("id")).orElse(innerJsonObject.get("name"));
                String chainName = Optional.ofNullable(chainNameJsonNode).map(JsonNode::textValue).orElse(null);
                ParserHelper.checkChainId(chainName, innerJsonObject.toPrettyString());
                if (!chainNameSet.add(chainName)) {
                    throw new ChainDuplicateException(String.format("[chain name duplicate] chainName=%s", chainName));
                }
                FlowBus.addChain(chainName);
            }
        });
        chainNameSet.clear();
        for (JsonNode flowJsonNode : flowJsonObjectList) {
            Iterator chainIterator = flowJsonNode.get("flow").get("chain").elements();
            while (chainIterator.hasNext()) {
                JsonNode jsonNode = (JsonNode)chainIterator.next();
                parseOneChainConsumer.accept(jsonNode);
            }
        }
    }

    public static void parseOneChainEl(JsonNode chainNode) {
        String chainId = Optional.ofNullable(chainNode.get("id")).orElse(chainNode.get("name")).textValue();
        String el = chainNode.get("value").textValue();
        LiteFlowChainELBuilder chainELBuilder = LiteFlowChainELBuilder.createChain().setChainId(chainId);
        chainELBuilder.setEL(el).build();
    }

    public static void parseOneChainEl(Element e) {
        String chainId = Optional.ofNullable(e.attributeValue("id")).orElse(e.attributeValue("name"));
        String text = e.getText();
        String el = RegexUtil.removeComments(text);
        LiteFlowChainELBuilder chainELBuilder = LiteFlowChainELBuilder.createChain().setChainId(chainId);
        chainELBuilder.setEL(el).build();
    }

    private static void checkChainId(String chainId, String elData) {
        if (StrUtil.isBlank((CharSequence)chainId)) {
            throw new ParseException("missing chain id in expression \r\n" + elData);
        }
    }

    private static class RegexUtil {
        private static final String REGEX_COMMENT = "(?<!(:|@))\\/\\/.*|\\/\\*(\\s|.)*?\\*\\/";

        private RegexUtil() {
        }

        private static String removeComments(String elStr) {
            if (StrUtil.isBlank((CharSequence)elStr)) {
                return elStr;
            }
            return Pattern.compile(REGEX_COMMENT).matcher(elStr).replaceAll("");
        }
    }
}

