/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.thread;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.exception.ThreadExecutorServiceCreateException;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import com.yomahub.liteflow.thread.ExecutorBuilder;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class ExecutorHelper {
    private final LFLog LOG = LFLoggerManager.getLogger(ExecutorHelper.class);
    private final Map<String, ExecutorService> executorServiceMap = MapUtil.newConcurrentHashMap();

    private ExecutorHelper() {
    }

    public static ExecutorHelper loadInstance() {
        return Holder.INSTANCE;
    }

    public void shutdownAwaitTermination(ExecutorService pool) {
        this.shutdownAwaitTermination(pool, 60L);
    }

    public void shutdownAwaitTermination(ExecutorService pool, long timeout) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(timeout, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(timeout, TimeUnit.SECONDS)) {
                    this.LOG.error("Pool did not terminate.");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public ExecutorService buildWhenExecutor() {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        return this.buildWhenExecutor(liteflowConfig.getThreadExecutorClass());
    }

    public ExecutorService buildWhenExecutor(String clazz) {
        if (StrUtil.isBlank((CharSequence)clazz)) {
            return this.buildWhenExecutor();
        }
        return this.getExecutorService(clazz);
    }

    public ExecutorService buildMainExecutor() {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        return this.buildMainExecutor(liteflowConfig.getMainExecutorClass());
    }

    public ExecutorService buildMainExecutor(String clazz) {
        if (StrUtil.isBlank((CharSequence)clazz)) {
            return this.buildMainExecutor();
        }
        return this.getExecutorService(clazz);
    }

    public ExecutorService buildLoopParallelExecutor() {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        return this.getExecutorService(liteflowConfig.getParallelLoopExecutorClass());
    }

    private ExecutorService getExecutorService(String clazz) {
        try {
            ExecutorService executorServiceFromCache = this.executorServiceMap.get(clazz);
            if (ObjectUtil.isNotNull((Object)executorServiceFromCache)) {
                return executorServiceFromCache;
            }
            Class<?> executorClass = Class.forName(clazz);
            ExecutorBuilder executorBuilder = (ExecutorBuilder)ContextAwareHolder.loadContextAware().registerBean(executorClass);
            ExecutorService executorService = executorBuilder.buildExecutor();
            this.executorServiceMap.put(clazz, executorService);
            return executorService;
        }
        catch (Exception e) {
            this.LOG.error(e.getMessage());
            throw new ThreadExecutorServiceCreateException(e.getMessage());
        }
    }

    public void clearExecutorServiceMap() {
        if (MapUtil.isNotEmpty(this.executorServiceMap)) {
            this.executorServiceMap.clear();
        }
    }

    private static class Holder {
        static final ExecutorHelper INSTANCE = new ExecutorHelper();

        private Holder() {
        }
    }
}

