/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.thread;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Maps;
import com.yomahub.liteflow.exception.ThreadExecutorServiceCreateException;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import com.yomahub.liteflow.thread.ExecutorBuilder;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorHelper {
    private final Logger LOG = LoggerFactory.getLogger(ExecutorHelper.class);
    private final Map<String, ExecutorService> executorServiceMap = Maps.newConcurrentMap();

    private ExecutorHelper() {
    }

    public static ExecutorHelper loadInstance() {
        return Holder.INSTANCE;
    }

    public void shutdownAwaitTermination(ExecutorService pool) {
        this.shutdownAwaitTermination(pool, 60L);
    }

    public void shutdownAwaitTermination(ExecutorService pool, long timeout) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(timeout, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(timeout, TimeUnit.SECONDS)) {
                    this.LOG.error("Pool did not terminate.");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public ExecutorService buildExecutor() {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        if (!this.executorServiceMap.containsKey(liteflowConfig.getThreadExecutorClass())) {
            ExecutorService executorService = this.getExecutorBuilder(liteflowConfig.getThreadExecutorClass()).buildExecutor();
            this.executorServiceMap.put(liteflowConfig.getThreadExecutorClass(), executorService);
        }
        return this.executorServiceMap.get(liteflowConfig.getThreadExecutorClass());
    }

    public ExecutorService buildExecutor(String threadExecutorClass) {
        if (StrUtil.isBlank((CharSequence)threadExecutorClass)) {
            return this.buildExecutor();
        }
        ExecutorService executorServiceFromCache = this.executorServiceMap.get(threadExecutorClass);
        if (executorServiceFromCache != null) {
            return executorServiceFromCache;
        }
        ExecutorService executorService = this.getExecutorBuilder(threadExecutorClass).buildExecutor();
        this.executorServiceMap.put(threadExecutorClass, executorService);
        return executorService;
    }

    private ExecutorBuilder getExecutorBuilder(String threadExecutorClass) {
        try {
            Class<?> executorClass = Class.forName(threadExecutorClass);
            return (ExecutorBuilder)ContextAwareHolder.loadContextAware().registerBean(executorClass);
        }
        catch (Exception e) {
            this.LOG.error(e.getMessage(), (Throwable)e);
            throw new ThreadExecutorServiceCreateException(e.getMessage());
        }
    }

    public void clearExecutorServiceMap() {
        if (MapUtil.isNotEmpty(this.executorServiceMap)) {
            this.executorServiceMap.clear();
        }
    }

    private static class Holder {
        static final ExecutorHelper INSTANCE = new ExecutorHelper();

        private Holder() {
        }
    }
}

