/*
 * Decompiled with CFR 0.152.
 */
package io.github.yedaxia.apidocs;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.TypeParameter;
import io.github.yedaxia.apidocs.DocContext;
import io.github.yedaxia.apidocs.LogUtils;
import io.github.yedaxia.apidocs.Utils;
import io.github.yedaxia.apidocs.exception.JavaFileNotFoundException;
import io.github.yedaxia.apidocs.parser.ClassNode;
import io.github.yedaxia.apidocs.parser.FieldNode;
import io.github.yedaxia.apidocs.parser.GenericNode;
import io.github.yedaxia.apidocs.parser.MockNode;
import io.github.yedaxia.apidocs.parser.RequestNode;
import io.github.yedaxia.apidocs.parser.ResponseNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class ParseUtils {
    private static final String TYPE_MODEL = "_object";

    public static File searchJavaFile(File inJavaFile, String className) {
        String javaSrcPath;
        File file = null;
        Iterator<String> iterator = DocContext.getJavaSrcPaths().iterator();
        while (iterator.hasNext() && (file = ParseUtils.searchJavaFileInner(javaSrcPath = iterator.next(), inJavaFile, className)) == null) {
        }
        if (file == null) {
            throw new JavaFileNotFoundException("Cannot find java file , in java file : " + inJavaFile.getAbsolutePath() + ", className : " + className);
        }
        return file;
    }

    private static File searchJavaFileInner(String javaSrcPath, File inJavaFile, final String className) {
        File javaFile;
        Object javaFile2;
        CompilationUnit compilationUnit = ParseUtils.compilationUnit(inJavaFile);
        Optional<ImportDeclaration> idOp = compilationUnit.getImports().stream().filter(im -> im.getNameAsString().endsWith("." + className)).findFirst();
        if (idOp.isPresent()) {
            String[] cPaths = idOp.get().getNameAsString().split("\\.");
            return ParseUtils.backTraceJavaFileByName(javaSrcPath, cPaths);
        }
        if (ParseUtils.getInnerClassNode(compilationUnit, className).isPresent()) {
            return inJavaFile;
        }
        String[] cPaths = className.split("\\.");
        if (cPaths.length == 1) {
            File[] javaFiles = inJavaFile.getParentFile().listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equals(className + ".java");
                }
            });
            if (javaFiles != null && javaFiles.length == 1) {
                return javaFiles[0];
            }
        } else {
            final String firstPath = cPaths[0];
            File[] javaFiles = inJavaFile.getParentFile().listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    int i = name.lastIndexOf(".java");
                    if (i == -1) {
                        return false;
                    }
                    return name.substring(0, i).equals(firstPath);
                }
            });
            if (javaFiles != null && javaFiles.length > 0 && ParseUtils.getInnerClassNode(ParseUtils.compilationUnit((File)(javaFile2 = javaFiles[0])), className).isPresent()) {
                return javaFile2;
            }
        }
        if ((javaFile = ParseUtils.backTraceJavaFileByName(javaSrcPath, cPaths)) != null) {
            return javaFile;
        }
        NodeList importDeclarations = compilationUnit.getImports();
        if (importDeclarations.isNonEmpty()) {
            String packageName;
            ImportDeclaration importDeclaration;
            javaFile2 = importDeclarations.iterator();
            while (javaFile2.hasNext() && (!(importDeclaration = (ImportDeclaration)javaFile2.next()).toString().contains(".*") || (javaFile = ParseUtils.backTraceJavaFileByName(javaSrcPath, cPaths = ((packageName = importDeclaration.getNameAsString()) + "." + className).split("\\."))) == null)) {
            }
        }
        if (cPaths.length > 1) {
            try {
                File innerClassFile = ParseUtils.searchJavaFile(inJavaFile, cPaths[cPaths.length - 2]);
                if (ParseUtils.getInnerClassNode(ParseUtils.compilationUnit(innerClassFile), cPaths[cPaths.length - 1]).isPresent()) {
                    return innerClassFile;
                }
            }
            catch (JavaFileNotFoundException javaFileNotFoundException) {
                // empty catch block
            }
        }
        return javaFile;
    }

    private static Optional<TypeDeclaration> getInnerClassNode(CompilationUnit compilationUnit, String className) {
        return compilationUnit.findAll(TypeDeclaration.class).stream().filter(c -> c instanceof ClassOrInterfaceDeclaration || c instanceof EnumDeclaration).filter(c -> className.equals(c.getNameAsString())).findFirst();
    }

    private static File backTraceJavaFileByName(String javaSrcPath, String[] cPaths) {
        if (cPaths.length == 0) {
            return null;
        }
        String javaFilePath = javaSrcPath + Utils.joinArrayString(cPaths, "/") + ".java";
        File javaFile = new File(javaFilePath);
        if (javaFile.exists() && javaFile.isFile()) {
            return javaFile;
        }
        return ParseUtils.backTraceJavaFileByName(javaSrcPath, Arrays.copyOf(cPaths, cPaths.length - 1));
    }

    public static CompilationUnit compilationUnit(File javaFile) {
        try {
            return JavaParser.parse((File)javaFile);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("java file not exits , file path : " + javaFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException("parser error , file path : " + javaFile.getAbsolutePath());
        }
    }

    public static void parseClassNodeByType(File inJavaFile, ClassNode rootClassNode, com.github.javaparser.ast.type.Type classType) {
        block23: {
            if (classType.getParentNode().isPresent() && classType.getParentNode().get() instanceof ArrayType) {
                rootClassNode.setList(true);
            } else if (classType instanceof ArrayType) {
                rootClassNode.setList(true);
                classType = ((ArrayType)classType).getComponentType();
            } else if (ParseUtils.isCollectionType(classType.asString())) {
                rootClassNode.setList(true);
                List collectionType = classType.getChildNodesByType(ClassOrInterfaceType.class);
                if (collectionType.isEmpty()) {
                    LogUtils.warn("We found Collection without specified Class Type, Please check ! java file : %s", inJavaFile.getName());
                    rootClassNode.setClassName("Object");
                    return;
                }
                classType = (com.github.javaparser.ast.type.Type)collectionType.get(0);
            }
            String unifyClassType = ParseUtils.unifyType(classType.asString());
            if (TYPE_MODEL.equals(unifyClassType)) {
                if (classType instanceof ClassOrInterfaceType) {
                    String className = ((ClassOrInterfaceType)classType).getName().getIdentifier();
                    rootClassNode.setClassName(className);
                    ((ClassOrInterfaceType)classType).getTypeArguments().ifPresent(typeList -> typeList.forEach(argType -> {
                        GenericNode rootGenericNode = new GenericNode();
                        rootGenericNode.setFromJavaFile(inJavaFile);
                        rootGenericNode.setClassType((com.github.javaparser.ast.type.Type)argType);
                        rootClassNode.addGenericNode(rootGenericNode);
                    }));
                    try {
                        File modelJavaFile = ParseUtils.searchJavaFile(inJavaFile, className);
                        rootClassNode.setClassFileName(modelJavaFile.getAbsolutePath());
                        ParseUtils.parseClassNode(modelJavaFile, rootClassNode);
                    }
                    catch (JavaFileNotFoundException ex) {
                        Class modelClass = ParseUtils.getClassInJavaFile(inJavaFile, className);
                        if (modelClass == null) break block23;
                        if (rootClassNode instanceof ResponseNode) {
                            ResponseNode responseNode = (ResponseNode)rootClassNode;
                            responseNode.reset();
                            Class controllerClass = ParseUtils.getClassInJavaFile(inJavaFile, inJavaFile.getName().replace(".java", ""));
                            if (controllerClass != null) {
                                RequestNode requestNode = responseNode.getRequestNode();
                                try {
                                    Method apiMethod = null;
                                    for (Method method : controllerClass.getDeclaredMethods()) {
                                        if (!method.getName().equals(requestNode.getMethodName()) || method.getAnnotations() == null) continue;
                                        for (Annotation annotation : method.getAnnotations()) {
                                            String reqUrl = requestNode.getUrl();
                                            if (reqUrl.contains("/")) {
                                                reqUrl = reqUrl.substring(reqUrl.lastIndexOf("/") + 1);
                                            }
                                            if (!annotation.toString().contains(reqUrl)) continue;
                                            apiMethod = method;
                                        }
                                    }
                                    if (apiMethod != null) {
                                        Type returnType = apiMethod.getGenericReturnType();
                                        if (apiMethod.getReturnType().getName().equals("org.springframework.http.ResponseEntity")) {
                                            ParameterizedType parameterizedType;
                                            Type[] responseEntityTypeArguments = ((ParameterizedType)apiMethod.getGenericReturnType()).getActualTypeArguments();
                                            if (responseEntityTypeArguments.length == 1 && responseEntityTypeArguments[0] instanceof ParameterizedType && (parameterizedType = (ParameterizedType)responseEntityTypeArguments[0]).getRawType() instanceof Class) {
                                                ParseUtils.parseGenericNodesInType((Class)parameterizedType.getRawType(), parameterizedType, responseNode.getGenericNodes());
                                            }
                                        } else {
                                            ParseUtils.parseGenericNodesInType(apiMethod.getReturnType(), returnType, responseNode.getGenericNodes());
                                        }
                                    }
                                }
                                catch (Exception e2) {
                                    LogUtils.error("get method error", e2);
                                }
                            }
                        }
                        if (DocContext.getDocsConfig().getOpenReflection().booleanValue()) {
                            rootClassNode.setModelClass(modelClass);
                            ParseUtils.parseClassNodeByReflection(rootClassNode);
                        }
                    }
                }
            } else {
                rootClassNode.setClassName(unifyClassType);
            }
        }
    }

    public static void parseClassNode(File modelJavaFile, ClassNode classNode) {
        ParseUtils.innerParseClassNode(modelJavaFile, classNode);
    }

    private static void innerParseClassNode(File modelJavaFile, ClassNode classNode) {
        String resultClassName = classNode.getClassName();
        ParseUtils.compilationUnit(modelJavaFile).findAll(ClassOrInterfaceDeclaration.class).stream().filter(f -> resultClassName.endsWith(f.getNameAsString())).findFirst().ifPresent(cl -> {
            NodeList exClassTypeList;
            NodeList typeParameters = cl.getTypeParameters();
            if (typeParameters.isNonEmpty() && classNode.getGenericNodes().size() == typeParameters.size()) {
                int len = typeParameters.size();
                for (int i = 0; i != len; ++i) {
                    classNode.getGenericNode(i).setPlaceholder(((TypeParameter)typeParameters.get(i)).getName().getIdentifier());
                }
            }
            if (!(exClassTypeList = cl.getExtendedTypes()).isEmpty()) {
                ParseUtils.parseClassNodeByType(modelJavaFile, classNode, (com.github.javaparser.ast.type.Type)exClassTypeList.get(0));
            }
            cl.findAll(FieldDeclaration.class).stream().filter(fd -> !fd.getModifiers().contains(Modifier.STATIC)).forEach(fd -> {
                ClassOrInterfaceDeclaration cClDeclaration = (ClassOrInterfaceDeclaration)fd.getParentNode().get();
                if (!resultClassName.equals(cClDeclaration.getNameAsString()) && !resultClassName.endsWith("." + cClDeclaration.getNameAsString())) {
                    return;
                }
                if (fd.getAnnotationByName("Ignore").isPresent()) {
                    return;
                }
                boolean notNull = ParseUtils.isFieldNotNull(fd);
                fd.getVariables().forEach(field -> {
                    FieldNode fieldNode = new FieldNode();
                    fieldNode.setNotNull(notNull);
                    fieldNode.setClassNode(classNode);
                    classNode.addChildNode(fieldNode);
                    fd.getComment().ifPresent(c -> fieldNode.setDescription(Utils.cleanCommentContent(c.getContent())));
                    if (!Utils.isNotEmpty(fieldNode.getDescription())) {
                        field.getComment().ifPresent(c -> fieldNode.setDescription(Utils.cleanCommentContent(c.getContent())));
                    }
                    fd.getAnnotationByName("RapMock").ifPresent(an -> {
                        if (an instanceof NormalAnnotationExpr) {
                            NormalAnnotationExpr normalAnExpr = (NormalAnnotationExpr)an;
                            MockNode mockNode = new MockNode();
                            for (MemberValuePair mvPair : normalAnExpr.getPairs()) {
                                String name = mvPair.getName().asString();
                                if ("limit".equalsIgnoreCase(name)) {
                                    mockNode.setLimit(Utils.removeQuotations(mvPair.getValue().toString()));
                                    continue;
                                }
                                if (!"value".equalsIgnoreCase(name)) continue;
                                mockNode.setValue(Utils.removeQuotations(mvPair.getValue().toString()));
                            }
                            fieldNode.setMockNode(mockNode);
                        } else if (an instanceof SingleMemberAnnotationExpr) {
                            SingleMemberAnnotationExpr singleAnExpr = (SingleMemberAnnotationExpr)an;
                            MockNode mockNode = new MockNode();
                            mockNode.setValue(Utils.removeQuotations(singleAnExpr.getMemberValue().toString()));
                            fieldNode.setMockNode(mockNode);
                        }
                    });
                    fieldNode.setName(field.getNameAsString());
                    com.github.javaparser.ast.type.Type fieldType = fd.getElementType();
                    ParseUtils.parseFieldNode(fieldNode, modelJavaFile, fieldType);
                });
            });
        });
        classNode.setClassName(resultClassName);
    }

    private static boolean isFieldNotNull(FieldDeclaration fd) {
        for (AnnotationExpr annotationExpr : fd.getAnnotations()) {
            if (!ParseUtils.isNotNullAnnotation(annotationExpr.getNameAsString())) continue;
            return true;
        }
        return false;
    }

    private static void parseFieldNode(FieldNode fieldNode, File inJavaFile, com.github.javaparser.ast.type.Type fieldType) {
        block21: {
            Boolean isList;
            String fieldClassType;
            GenericNode genericNode = fieldNode.getClassNode().getGenericNode(fieldType.asString());
            if (genericNode == null && !fieldType.asString().contains("<") && TYPE_MODEL.equals(ParseUtils.unifyType(fieldClassType = fieldType.asString()))) {
                Optional<EnumDeclaration> ed = null;
                try {
                    File childJavaFile = ParseUtils.searchJavaFile(inJavaFile, fieldClassType);
                    ed = ParseUtils.compilationUnit(childJavaFile).getChildNodesByType(EnumDeclaration.class).stream().filter(em -> fieldClassType.endsWith(em.getNameAsString())).findFirst();
                }
                catch (JavaFileNotFoundException ex) {
                    LogUtils.info("we think %s should not be an enum type", fieldClassType);
                }
                if (ed != null && ed.isPresent()) {
                    fieldNode.setType("enum");
                    List constants = ed.get().getChildNodesByType(EnumConstantDeclaration.class);
                    StringBuilder sb = new StringBuilder(fieldNode.getDescription() == null ? "" : fieldNode.getDescription());
                    sb.append(" [");
                    int size = constants.size();
                    for (int i = 0; i != size; ++i) {
                        sb.append(((EnumConstantDeclaration)constants.get(i)).getNameAsString());
                        if (i == size - 1) continue;
                        sb.append(",");
                    }
                    sb.append("]");
                    fieldNode.setDescription(sb.toString());
                    return;
                }
            }
            if (genericNode != null) {
                fieldType = genericNode.getClassType();
                inJavaFile = genericNode.getFromJavaFile();
            }
            if (fieldType.getParentNode().get() instanceof ArrayType) {
                isList = true;
            } else if (fieldType instanceof ArrayType) {
                isList = true;
                fieldType = ((ArrayType)fieldType).getComponentType();
                GenericNode arrayTypeNode = fieldNode.getClassNode().getGenericNode(fieldType.asString());
                if (arrayTypeNode != null) {
                    fieldType = arrayTypeNode.getClassType();
                    inJavaFile = arrayTypeNode.getFromJavaFile();
                }
            } else if (ParseUtils.isCollectionType(fieldType.asString())) {
                isList = true;
                List collectionType = fieldType.getChildNodesByType(ClassOrInterfaceType.class);
                if (collectionType.isEmpty()) {
                    LogUtils.warn("We found Collection without specified Class Type, Please check ! java file : %s", inJavaFile.getName());
                    fieldNode.setType("Object[]");
                    return;
                }
                GenericNode collectionGenericNode = fieldNode.getClassNode().getGenericNode(((ClassOrInterfaceType)collectionType.get(0)).asString());
                if (collectionGenericNode != null) {
                    fieldType = collectionGenericNode.getClassType();
                    inJavaFile = collectionGenericNode.getFromJavaFile();
                } else {
                    fieldType = (com.github.javaparser.ast.type.Type)collectionType.get(0);
                }
            } else {
                isList = false;
            }
            String fieldClassType2 = fieldType instanceof ClassOrInterfaceType ? ((ClassOrInterfaceType)fieldType).getName().getIdentifier() : fieldType.asString();
            String unifyType = ParseUtils.unifyType(fieldClassType2);
            if (TYPE_MODEL.equals(unifyType)) {
                ClassNode childNode = new ClassNode();
                childNode.setParentNode(fieldNode.getClassNode());
                childNode.setList(isList);
                childNode.setClassName(fieldClassType2);
                fieldNode.setChildNode(childNode);
                fieldNode.setType(isList != false ? fieldClassType2 + "[]" : fieldClassType2);
                File childJavaFile = inJavaFile;
                ((ClassOrInterfaceType)fieldType).getTypeArguments().ifPresent(typeList -> typeList.forEach(argType -> {
                    GenericNode childClassGenericNode = new GenericNode();
                    if (argType instanceof ArrayType) {
                        GenericNode arrayTypeNode = fieldNode.getClassNode().getGenericNode(((ArrayType)argType).getComponentType().asString());
                        if (arrayTypeNode != null) {
                            ((ArrayType)argType).setComponentType(arrayTypeNode.getClassType());
                        }
                    } else {
                        GenericNode arrayTypeNode = fieldNode.getClassNode().getGenericNode(argType.asString());
                        if (arrayTypeNode != null) {
                            argType = arrayTypeNode.getClassType();
                        }
                    }
                    childClassGenericNode.setClassType((com.github.javaparser.ast.type.Type)argType);
                    childClassGenericNode.setFromJavaFile(childJavaFile);
                    childNode.addGenericNode(childClassGenericNode);
                }));
                try {
                    File childNodeJavaFile = ParseUtils.searchJavaFile(inJavaFile, fieldClassType2);
                    childNode.setClassFileName(childNodeJavaFile.getAbsolutePath());
                    if (!ParseUtils.inClassDependencyTree(fieldNode, fieldNode.getClassNode())) {
                        ParseUtils.parseClassNode(childNodeJavaFile, childNode);
                        break block21;
                    }
                    fieldNode.setLoopNode(Boolean.TRUE);
                }
                catch (JavaFileNotFoundException ex) {
                    LogUtils.warn(ex.getMessage() + ", we cannot found more information of it, you've better to make it a JavaBean", new Object[0]);
                    fieldNode.setType(isList != false ? "Object[]" : "Object");
                }
            } else {
                fieldNode.setType(isList != false ? unifyType + "[]" : unifyType);
            }
        }
    }

    private static boolean inClassDependencyTree(FieldNode fieldNode, ClassNode parentClassNode) {
        if (fieldNode.getChildNode().getModelClass() != null && parentClassNode.getModelClass() != null ? fieldNode.getChildNode().getModelClass().equals(parentClassNode.getModelClass()) : fieldNode.getChildNode().getClassFileName() != null && fieldNode.getChildNode().getClassFileName().equals(parentClassNode.getClassFileName()) && fieldNode.getChildNode().getClassName().equals(parentClassNode.getClassName())) {
            return true;
        }
        if (parentClassNode.getParentNode() == null) {
            return false;
        }
        return ParseUtils.inClassDependencyTree(fieldNode, parentClassNode.getParentNode());
    }

    public static boolean isModelType(String className) {
        return TYPE_MODEL.equals(ParseUtils.unifyType(className));
    }

    public static String unifyType(String className) {
        String[] cPaths = className.replace("[]", "").split("\\.");
        String rawType = cPaths[cPaths.length - 1];
        if ("byte".equalsIgnoreCase(rawType)) {
            return "byte";
        }
        if ("short".equalsIgnoreCase(rawType)) {
            return "short";
        }
        if ("int".equalsIgnoreCase(rawType) || "Integer".equalsIgnoreCase(rawType) || "BigInteger".equalsIgnoreCase(rawType)) {
            return "int";
        }
        if ("long".equalsIgnoreCase(rawType)) {
            return "long";
        }
        if ("float".equalsIgnoreCase(rawType)) {
            return "float";
        }
        if ("double".equalsIgnoreCase(rawType) || "BigDecimal".equalsIgnoreCase(rawType)) {
            return "double";
        }
        if ("boolean".equalsIgnoreCase(rawType)) {
            return "boolean";
        }
        if ("char".equalsIgnoreCase(rawType) || "Character".equalsIgnoreCase(rawType)) {
            return "char";
        }
        if ("String".equalsIgnoreCase(rawType)) {
            return "string";
        }
        if ("date".equalsIgnoreCase(rawType) || "ZonedDateTime".equalsIgnoreCase(rawType) || "LocalDateTime".equals(rawType)) {
            return "date";
        }
        if ("file".equalsIgnoreCase(rawType) || "MultipartFile".equalsIgnoreCase(rawType)) {
            return "file";
        }
        return TYPE_MODEL;
    }

    public static boolean isCollectionType(String className) {
        String[] cPaths = className.split("\\.");
        String genericType = cPaths[cPaths.length - 1];
        for (String cPath : cPaths) {
            if (!cPath.contains("<")) continue;
            genericType = cPath;
        }
        int genericLeftIndex = genericType.indexOf("<");
        String rawType = genericLeftIndex != -1 ? genericType.substring(0, genericLeftIndex) : genericType;
        String collectionClassName = "java.util." + rawType;
        try {
            Class<?> collectionClass = Class.forName(collectionClassName);
            return Collection.class.isAssignableFrom(collectionClass);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isExcludeParam(Parameter param) {
        String type = param.getTypeAsString();
        return type.equals("HttpServletRequest") || type.equals("HttpServletResponse") || type.equals("HttpSession");
    }

    public static Class getClassInJavaFile(File inJavaFile, String className) {
        Class<?> modelClass = null;
        CompilationUnit compilationUnit = ParseUtils.compilationUnit(inJavaFile);
        for (ImportDeclaration importDeclaration : compilationUnit.getImports()) {
            String importName = importDeclaration.getNameAsString();
            if (importName.endsWith("." + className)) {
                try {
                    modelClass = Class.forName(importName);
                    break;
                }
                catch (Exception e) {
                    LogUtils.error("ClassNotFoundException: " + className, e);
                    continue;
                }
            }
            if (!importName.endsWith(".*")) continue;
            try {
                modelClass = Class.forName(importName.replace("*", className));
            }
            catch (Exception exception) {}
        }
        try {
            modelClass = Class.forName(((PackageDeclaration)compilationUnit.getPackageDeclaration().get()).getNameAsString().concat(".").concat(className));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modelClass;
    }

    public static void parseClassNodeByReflection(ClassNode classNode) {
        Class modelClass = classNode.getModelClass();
        if (modelClass.getPackage().getName().startsWith("java.") || modelClass.isInterface()) {
            return;
        }
        List<FieldNode> childNodes = classNode.getChildNodes();
        classNode.setClassName(modelClass.getName());
        for (Field field : modelClass.getDeclaredFields()) {
            if (java.lang.reflect.Modifier.isStatic(field.getModifiers())) continue;
            FieldNode fieldNode = new FieldNode();
            childNodes.add(fieldNode);
            Annotation[] annotations = field.getAnnotations();
            if (annotations != null) {
                for (Annotation annotation : annotations) {
                    if (!ParseUtils.isNotNullAnnotation(annotation.getClass().getSimpleName())) continue;
                    fieldNode.setNotNull(true);
                    break;
                }
            }
            fieldNode.setName(field.getName());
            if (field.getType().isEnum()) {
                fieldNode.setType("enum");
                continue;
            }
            ClassNode childClassNode = new ClassNode();
            childClassNode.setParentNode(classNode);
            Class childNodeClass = null;
            Type childGenericType = null;
            Class fieldClass = field.getType();
            if (fieldClass.isArray()) {
                Class componentType = fieldClass.getComponentType();
                String unifyFieldType = ParseUtils.unifyType(componentType.getSimpleName());
                fieldNode.setType(unifyFieldType + "[]");
                if (!unifyFieldType.equals(TYPE_MODEL)) continue;
                childClassNode.setList(true);
                childNodeClass = componentType;
                childGenericType = field.getGenericType();
            }
            if (Collection.class.isAssignableFrom(fieldClass)) {
                Type boxType;
                fieldNode.setType("[]");
                Type genericType = field.getGenericType();
                if (!(genericType instanceof ParameterizedType)) continue;
                childGenericType = boxType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
                Class boxClass = null;
                if (boxType instanceof ParameterizedType) {
                    boxClass = (Class)((ParameterizedType)boxType).getRawType();
                } else if (boxType instanceof TypeVariable) {
                    GenericNode genericNode = classNode.getGenericNode(((TypeVariable)boxType).getName());
                    if (genericNode == null) continue;
                    boxClass = genericNode.getModelClass();
                    childClassNode.setGenericNodes(genericNode.getChildGenericNode());
                } else if (boxType instanceof Class) {
                    boxClass = (Class)boxType;
                }
                if (boxClass == null) continue;
                String unifyFieldType = ParseUtils.unifyType(boxClass.getSimpleName());
                if (unifyFieldType.equals(TYPE_MODEL)) {
                    childClassNode.setList(true);
                    childNodeClass = boxClass;
                } else {
                    fieldNode.setType(unifyFieldType + "[]");
                    continue;
                }
            }
            if (childNodeClass == null) {
                childNodeClass = fieldClass;
                childGenericType = field.getGenericType();
                if (childGenericType instanceof TypeVariable) {
                    GenericNode genericNode = classNode.getGenericNode(((TypeVariable)childGenericType).getName());
                    if (genericNode == null) continue;
                    childNodeClass = genericNode.getModelClass();
                    childClassNode.setGenericNodes(genericNode.getChildGenericNode());
                } else if (childGenericType instanceof ParameterizedType) {
                    Type[] paramTypes;
                    for (Type paramType : paramTypes = ((ParameterizedType)childGenericType).getActualTypeArguments()) {
                        GenericNode genericNode;
                        if (!(paramType instanceof TypeVariable) || (genericNode = classNode.getGenericNode(((TypeVariable)paramType).getName())) == null) continue;
                        childClassNode.addGenericNode(genericNode);
                    }
                }
                String unifyFieldType = ParseUtils.unifyType(childNodeClass.getSimpleName());
                if (!unifyFieldType.equals(TYPE_MODEL)) {
                    fieldNode.setType(unifyFieldType);
                    continue;
                }
            }
            ParseUtils.parseGenericNodesInType(childNodeClass, childGenericType, childClassNode.getGenericNodes());
            childClassNode.setClassName(childNodeClass.getName());
            childClassNode.setModelClass(childNodeClass);
            fieldNode.setChildNode(childClassNode);
            if (ParseUtils.inClassDependencyTree(fieldNode, classNode)) continue;
            ParseUtils.parseClassNodeByReflection(childClassNode);
        }
        Class superClass = modelClass.getSuperclass();
        if (superClass != null) {
            Type superType = modelClass.getGenericSuperclass();
            if (superType instanceof ParameterizedType) {
                classNode.getGenericNodes().clear();
                ParseUtils.parseGenericNodesInType(superClass, superType, classNode.getGenericNodes());
            }
            classNode.setModelClass(modelClass.getSuperclass());
            ParseUtils.parseClassNodeByReflection(classNode);
            classNode.setClassName(modelClass.getName());
            classNode.setModelClass(modelClass);
        }
    }

    public static void parseGenericNodesInType(Class fieldClass, Type fieldGenericType, List<GenericNode> genericNodeList) {
        if (fieldGenericType instanceof GenericArrayType) {
            fieldGenericType = ((GenericArrayType)fieldGenericType).getGenericComponentType();
        }
        if (fieldGenericType instanceof ParameterizedType) {
            TypeVariable<Class<T>>[] typeVariables = fieldClass.getTypeParameters();
            Type[] paramTypes = ((ParameterizedType)fieldGenericType).getActualTypeArguments();
            if (typeVariables.length == 0 || typeVariables.length != paramTypes.length) {
                return;
            }
            int paramIndex = 0;
            for (Type paramType : paramTypes) {
                Class boxClass;
                GenericNode paramGenericNode = new GenericNode();
                String placeholder = typeVariables[paramIndex++].getName();
                paramGenericNode.setPlaceholder(placeholder);
                if (paramType instanceof ParameterizedType) {
                    boxClass = (Class)((ParameterizedType)paramType).getRawType();
                    paramGenericNode.setModelClass(boxClass);
                    genericNodeList.add(paramGenericNode);
                    Type[] childTypeArguments = ((ParameterizedType)paramType).getActualTypeArguments();
                    TypeVariable<Class<T>>[] boxClassTypeVariables = boxClass.getTypeParameters();
                    if (childTypeArguments == null || childTypeArguments.length == 0 || childTypeArguments.length != boxClassTypeVariables.length) continue;
                    ArrayList<GenericNode> childGenericNodeList = new ArrayList<GenericNode>();
                    paramGenericNode.setChildGenericNode(childGenericNodeList);
                    int childParamIndex = 0;
                    for (Type childGenericType : childTypeArguments) {
                        if (childGenericType instanceof Class) {
                            GenericNode childGenericNode = new GenericNode();
                            childGenericNode.setModelClass((Class)childGenericType);
                            childGenericNode.setPlaceholder(boxClassTypeVariables[childParamIndex++].getName());
                            childGenericNodeList.add(childGenericNode);
                            continue;
                        }
                        ParseUtils.parseGenericNodesInType(boxClass, childGenericType, childGenericNodeList);
                    }
                    continue;
                }
                if (!(paramType instanceof Class)) continue;
                boxClass = (Class)paramType;
                paramGenericNode.setModelClass(boxClass);
                genericNodeList.add(paramGenericNode);
            }
        }
    }

    public static boolean isNotNullAnnotation(String annotationName) {
        return annotationName.endsWith("NotEmpty") || annotationName.endsWith("NotNull") || annotationName.endsWith("NotBlank");
    }
}

