/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.pool;

import io.milvus.pool.PoolClientFactory;
import io.milvus.pool.PoolConfig;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;

public class ClientPool<C, T> {
    protected GenericKeyedObjectPool<String, T> clientPool;
    protected PoolConfig config;
    protected PoolClientFactory<C, T> clientFactory;

    protected ClientPool() {
    }

    protected ClientPool(PoolConfig config, PoolClientFactory clientFactory) {
        this.config = config;
        this.clientFactory = clientFactory;
        GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
        poolConfig.setMaxIdlePerKey(config.getMaxIdlePerKey());
        poolConfig.setMinIdlePerKey(config.getMinIdlePerKey());
        poolConfig.setMaxTotal(config.getMaxTotal());
        poolConfig.setMaxTotalPerKey(config.getMaxTotalPerKey());
        poolConfig.setBlockWhenExhausted(config.isBlockWhenExhausted());
        poolConfig.setMaxWait(config.getMaxBlockWaitDuration());
        poolConfig.setTestOnBorrow(config.isTestOnBorrow());
        poolConfig.setTestOnReturn(config.isTestOnReturn());
        poolConfig.setTestOnCreate(false);
        poolConfig.setTestWhileIdle(false);
        poolConfig.setTimeBetweenEvictionRuns(config.getEvictionPollingInterval());
        poolConfig.setNumTestsPerEvictionRun(5);
        poolConfig.setMinEvictableIdleTime(config.getMinEvictableIdleDuration());
        this.clientPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)clientFactory, poolConfig);
    }

    public T getClient(String key) {
        try {
            return (T)this.clientPool.borrowObject((Object)key);
        }
        catch (Exception e) {
            System.out.println("Failed to get client, exception: " + e.getMessage());
            return null;
        }
    }

    public void returnClient(String key, T grpcClient) {
        try {
            this.clientPool.returnObject((Object)key, grpcClient);
        }
        catch (Exception e) {
            System.out.println("Failed to return client, exception: " + e.getMessage());
            throw e;
        }
    }

    public void close() {
        if (this.clientPool != null && !this.clientPool.isClosed()) {
            this.clientPool.close();
            this.clientPool = null;
        }
    }

    public void clear() {
        if (this.clientPool != null && !this.clientPool.isClosed()) {
            this.clientPool.clear();
        }
    }

    public void clear(String key) {
        if (this.clientPool != null && !this.clientPool.isClosed()) {
            this.clientPool.clear((Object)key);
        }
    }

    public int getIdleClientNumber(String key) {
        return this.clientPool.getNumIdle((Object)key);
    }

    public int getActiveClientNumber(String key) {
        return this.clientPool.getNumActive((Object)key);
    }

    public int getTotalIdleClientNumber() {
        return this.clientPool.getNumIdle();
    }

    public int getTotalActiveClientNumber() {
        return this.clientPool.getNumActive();
    }
}

