/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.response;

import io.milvus.exception.IllegalResponseException;
import io.milvus.grpc.ShowCollectionsResponse;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class ShowCollResponseWrapper {
    private final ShowCollectionsResponse response;

    public ShowCollResponseWrapper(@NonNull ShowCollectionsResponse response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        this.response = response;
    }

    public List<String> getCollectionNames() {
        return this.response.getCollectionNamesList();
    }

    public List<CollectionInfo> getCollectionsInfo() throws IllegalResponseException {
        if (this.response.getCollectionNamesCount() != this.response.getCollectionIdsCount() || this.response.getCollectionNamesCount() != this.response.getCreatedUtcTimestampsCount()) {
            throw new IllegalResponseException("Collection information count doesn't match");
        }
        ArrayList<CollectionInfo> results = new ArrayList<CollectionInfo>();
        for (int i = 0; i < this.response.getCollectionNamesCount(); ++i) {
            CollectionInfo info = new CollectionInfo(this.response.getCollectionNames(i), this.response.getCollectionIds(i), this.response.getCreatedUtcTimestamps(i));
            if (this.response.getInMemoryPercentagesCount() > i) {
                info.SetInMemoryPercentage(this.response.getInMemoryPercentages(i));
            }
            results.add(info);
        }
        return results;
    }

    public CollectionInfo getCollectionInfoByName(@NonNull String collectionName) {
        if (collectionName == null) {
            throw new NullPointerException("collectionName is marked non-null but is null");
        }
        for (int i = 0; i < this.response.getCollectionNamesCount(); ++i) {
            if (collectionName.compareTo(this.response.getCollectionNames(i)) != 0) continue;
            CollectionInfo info = new CollectionInfo(this.response.getCollectionNames(i), this.response.getCollectionIds(i), this.response.getCreatedUtcTimestamps(i));
            if (this.response.getInMemoryPercentagesCount() > i) {
                info.SetInMemoryPercentage(this.response.getInMemoryPercentages(i));
            }
            return info;
        }
        return null;
    }

    public String toString() {
        return "Collections{" + this.getCollectionsInfo().toString() + '}';
    }

    public static final class CollectionInfo {
        private final String name;
        private final long id;
        private final long utcTimestamp;
        private long inMemoryPercentage = 0L;

        public CollectionInfo(String name, long id, long utcTimestamp) {
            this.name = name;
            this.id = id;
            this.utcTimestamp = utcTimestamp;
        }

        public void SetInMemoryPercentage(long inMemoryPercentage) {
            this.inMemoryPercentage = inMemoryPercentage;
        }

        public String toString() {
            return "(name: " + this.getName() + " id: " + this.getId() + " utcTimestamp: " + this.getUtcTimestamp() + " inMemoryPercentage: " + this.getInMemoryPercentage() + ")";
        }

        public String getName() {
            return this.name;
        }

        public long getId() {
            return this.id;
        }

        public long getUtcTimestamp() {
            return this.utcTimestamp;
        }

        public long getInMemoryPercentage() {
            return this.inMemoryPercentage;
        }
    }
}

