/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.compressor;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.loader.LoadLevel;
import io.seata.common.util.CollectionUtils;
import io.seata.core.compressor.Compressor;
import io.seata.core.compressor.CompressorType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CompressorFactory {
    protected static final Map<CompressorType, Compressor> COMPRESSOR_MAP = new ConcurrentHashMap<CompressorType, Compressor>();

    public static Compressor getCompressor(byte code) {
        CompressorType type = CompressorType.getByCode(code);
        return (Compressor)CollectionUtils.computeIfAbsent(COMPRESSOR_MAP, (Object)((Object)type), key -> (Compressor)EnhancedServiceLoader.load(Compressor.class, (String)type.name()));
    }

    static {
        COMPRESSOR_MAP.put(CompressorType.NONE, new NoneCompressor());
    }

    @LoadLevel(name="NONE")
    public static class NoneCompressor
    implements Compressor {
        @Override
        public byte[] compress(byte[] bytes) {
            return bytes;
        }

        @Override
        public byte[] decompress(byte[] bytes) {
            return bytes;
        }
    }
}

