/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.lock;

import io.seata.common.XID;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.core.exception.TransactionException;
import io.seata.core.lock.Locker;
import io.seata.core.lock.RowLock;
import io.seata.core.model.LockStatus;
import io.seata.server.lock.LockManager;
import io.seata.server.session.BranchSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLockManager
implements LockManager {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractLockManager.class);

    @Override
    public boolean acquireLock(BranchSession branchSession) throws TransactionException {
        return this.acquireLock(branchSession, true, false);
    }

    @Override
    public boolean acquireLock(BranchSession branchSession, boolean autoCommit, boolean skipCheckLock) throws TransactionException {
        if (branchSession == null) {
            throw new IllegalArgumentException("branchSession can't be null for memory/file locker.");
        }
        String lockKey = branchSession.getLockKey();
        if (StringUtils.isNullOrEmpty((String)lockKey)) {
            return true;
        }
        List<RowLock> locks = this.collectRowLocks(branchSession);
        if (CollectionUtils.isEmpty(locks)) {
            return true;
        }
        return this.getLocker(branchSession).acquireLock(locks, autoCommit, skipCheckLock);
    }

    @Override
    public boolean releaseLock(BranchSession branchSession) throws TransactionException {
        if (branchSession == null) {
            throw new IllegalArgumentException("branchSession can't be null for memory/file locker.");
        }
        List<RowLock> locks = this.collectRowLocks(branchSession);
        try {
            return this.getLocker(branchSession).releaseLock(locks);
        }
        catch (Exception t) {
            LOGGER.error("unLock error, branchSession:{}", (Object)branchSession, (Object)t);
            return false;
        }
    }

    @Override
    public boolean isLockable(String xid, String resourceId, String lockKey) throws TransactionException {
        if (StringUtils.isBlank((String)lockKey)) {
            return true;
        }
        List<RowLock> locks = this.collectRowLocks(lockKey, resourceId, xid);
        try {
            return this.getLocker().isLockable(locks);
        }
        catch (Exception t) {
            LOGGER.error("isLockable error, xid:{} resourceId:{}, lockKey:{}", new Object[]{xid, resourceId, lockKey, t});
            return false;
        }
    }

    @Override
    public void cleanAllLocks() throws TransactionException {
        this.getLocker().cleanAllLocks();
    }

    protected Locker getLocker() {
        return this.getLocker(null);
    }

    protected abstract Locker getLocker(BranchSession var1);

    @Override
    public List<RowLock> collectRowLocks(BranchSession branchSession) {
        if (branchSession == null || StringUtils.isBlank((String)branchSession.getLockKey())) {
            return Collections.emptyList();
        }
        String lockKey = branchSession.getLockKey();
        String resourceId = branchSession.getResourceId();
        String xid = branchSession.getXid();
        long transactionId = branchSession.getTransactionId();
        long branchId = branchSession.getBranchId();
        return this.collectRowLocks(lockKey, resourceId, xid, transactionId, branchId);
    }

    protected List<RowLock> collectRowLocks(String lockKey, String resourceId, String xid) {
        return this.collectRowLocks(lockKey, resourceId, xid, XID.getTransactionId((String)xid), null);
    }

    protected List<RowLock> collectRowLocks(String lockKey, String resourceId, String xid, Long transactionId, Long branchID) {
        String[] tableGroupedLockKeys;
        ArrayList<RowLock> locks = new ArrayList<RowLock>();
        for (String tableGroupedLockKey : tableGroupedLockKeys = lockKey.split(";")) {
            int idx = tableGroupedLockKey.indexOf(":");
            if (idx < 0) {
                return locks;
            }
            String tableName = tableGroupedLockKey.substring(0, idx);
            String mergedPKs = tableGroupedLockKey.substring(idx + 1);
            if (StringUtils.isBlank((String)mergedPKs)) {
                return locks;
            }
            String[] pks = mergedPKs.split(",");
            if (pks == null || pks.length == 0) {
                return locks;
            }
            for (String pk : pks) {
                if (!StringUtils.isNotBlank((String)pk)) continue;
                RowLock rowLock = new RowLock();
                rowLock.setXid(xid);
                rowLock.setTransactionId(transactionId);
                rowLock.setBranchId(branchID);
                rowLock.setTableName(tableName);
                rowLock.setPk(pk);
                rowLock.setResourceId(resourceId);
                locks.add(rowLock);
            }
        }
        return locks;
    }

    @Override
    public void updateLockStatus(String xid, LockStatus lockStatus) {
        this.getLocker().updateLockStatus(xid, lockStatus);
    }
}

