/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.storage;

import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.core.model.BranchStatus;
import io.seata.core.model.BranchType;
import io.seata.core.model.GlobalStatus;
import io.seata.core.store.BranchTransactionDO;
import io.seata.core.store.GlobalTransactionDO;
import io.seata.server.console.vo.BranchSessionVO;
import io.seata.server.console.vo.GlobalSessionVO;
import io.seata.server.session.BranchSession;
import io.seata.server.session.GlobalSession;
import io.seata.server.store.SessionStorable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeanUtils;

public class SessionConverter {
    public static GlobalSession convertGlobalSession(GlobalTransactionDO globalTransactionDO, boolean lazyLoadBranch) {
        if (globalTransactionDO == null) {
            return null;
        }
        GlobalSession session = new GlobalSession(globalTransactionDO.getApplicationId(), globalTransactionDO.getTransactionServiceGroup(), globalTransactionDO.getTransactionName(), globalTransactionDO.getTimeout(), lazyLoadBranch);
        session.setXid(globalTransactionDO.getXid());
        session.setTransactionId(globalTransactionDO.getTransactionId());
        session.setStatus(GlobalStatus.get((int)globalTransactionDO.getStatus()));
        session.setApplicationData(globalTransactionDO.getApplicationData());
        session.setBeginTime(globalTransactionDO.getBeginTime());
        return session;
    }

    public static GlobalSession convertGlobalSession(GlobalTransactionDO globalTransactionDO) {
        return SessionConverter.convertGlobalSession(globalTransactionDO, false);
    }

    public static BranchSession convertBranchSession(BranchTransactionDO branchTransactionDO) {
        if (branchTransactionDO == null) {
            return null;
        }
        BranchSession branchSession = new BranchSession();
        branchSession.setXid(branchTransactionDO.getXid());
        branchSession.setTransactionId(branchTransactionDO.getTransactionId());
        branchSession.setApplicationData(branchTransactionDO.getApplicationData());
        branchSession.setBranchId(branchTransactionDO.getBranchId());
        branchSession.setBranchType(BranchType.valueOf((String)branchTransactionDO.getBranchType()));
        branchSession.setResourceId(branchTransactionDO.getResourceId());
        branchSession.setClientId(branchTransactionDO.getClientId());
        branchSession.setResourceGroupId(branchTransactionDO.getResourceGroupId());
        branchSession.setStatus(BranchStatus.get((int)branchTransactionDO.getStatus()));
        return branchSession;
    }

    public static GlobalTransactionDO convertGlobalTransactionDO(SessionStorable session) {
        if (session == null || !(session instanceof GlobalSession)) {
            throw new IllegalArgumentException("The parameter of SessionStorable is not available, SessionStorable:" + StringUtils.toString((Object)session));
        }
        GlobalSession globalSession = (GlobalSession)session;
        GlobalTransactionDO globalTransactionDO = new GlobalTransactionDO();
        globalTransactionDO.setXid(globalSession.getXid());
        globalTransactionDO.setStatus(globalSession.getStatus().getCode());
        globalTransactionDO.setApplicationId(globalSession.getApplicationId());
        globalTransactionDO.setBeginTime(globalSession.getBeginTime());
        globalTransactionDO.setTimeout(globalSession.getTimeout());
        globalTransactionDO.setTransactionId(globalSession.getTransactionId());
        globalTransactionDO.setTransactionName(globalSession.getTransactionName());
        globalTransactionDO.setTransactionServiceGroup(globalSession.getTransactionServiceGroup());
        globalTransactionDO.setApplicationData(globalSession.getApplicationData());
        return globalTransactionDO;
    }

    public static BranchTransactionDO convertBranchTransactionDO(SessionStorable session) {
        if (session == null || !(session instanceof BranchSession)) {
            throw new IllegalArgumentException("The parameter of SessionStorable is not available, SessionStorable:" + StringUtils.toString((Object)session));
        }
        BranchSession branchSession = (BranchSession)session;
        BranchTransactionDO branchTransactionDO = new BranchTransactionDO();
        branchTransactionDO.setXid(branchSession.getXid());
        branchTransactionDO.setBranchId(branchSession.getBranchId());
        branchTransactionDO.setBranchType(branchSession.getBranchType().name());
        branchTransactionDO.setClientId(branchSession.getClientId());
        branchTransactionDO.setResourceGroupId(branchSession.getResourceGroupId());
        branchTransactionDO.setTransactionId(branchSession.getTransactionId());
        branchTransactionDO.setApplicationData(branchSession.getApplicationData());
        branchTransactionDO.setResourceId(branchSession.getResourceId());
        branchTransactionDO.setStatus(branchSession.getStatus().getCode());
        return branchTransactionDO;
    }

    public static void convertToGlobalSessionVo(List<GlobalSessionVO> result, List<GlobalSession> globalSessions) {
        if (CollectionUtils.isNotEmpty(globalSessions)) {
            for (GlobalSession globalSession : globalSessions) {
                GlobalSessionVO globalSessionVO = new GlobalSessionVO();
                BeanUtils.copyProperties((Object)globalSession, (Object)globalSessionVO);
                globalSessionVO.setStatus(globalSession.getStatus().getCode());
                globalSessionVO.setTimeout(Long.valueOf(globalSession.getTimeout()));
                globalSessionVO.setBranchSessionVOs(SessionConverter.converToBranchSession(globalSession.getBranchSessions()));
                result.add(globalSessionVO);
            }
        }
    }

    public static Set<BranchSessionVO> converToBranchSession(List<BranchSession> branchSessions) {
        HashSet<BranchSessionVO> branchSessionVOs = new HashSet<BranchSessionVO>(branchSessions.size());
        if (CollectionUtils.isNotEmpty(branchSessions)) {
            for (BranchSession branchSession : branchSessions) {
                BranchSessionVO branchSessionVONew = new BranchSessionVO();
                BeanUtils.copyProperties((Object)branchSession, (Object)branchSessionVONew);
                branchSessionVONew.setBranchType(branchSession.getBranchType().name());
                branchSessionVONew.setStatus(branchSession.getStatus().getCode());
                branchSessionVOs.add(branchSessionVONew);
            }
        }
        return branchSessionVOs;
    }

    public static List<GlobalSessionVO> convertGlobalSession(List<GlobalSession> filteredSessions) {
        if (CollectionUtils.isEmpty(filteredSessions)) {
            return Collections.emptyList();
        }
        ArrayList<GlobalSessionVO> result = new ArrayList<GlobalSessionVO>(filteredSessions.size());
        for (GlobalSession session : filteredSessions) {
            result.add(new GlobalSessionVO(session.getXid(), session.getTransactionId(), session.getStatus().getCode(), session.getApplicationId(), session.getTransactionServiceGroup(), session.getTransactionName(), Long.valueOf(session.getTimeout()), session.getBeginTime(), session.getApplicationData(), SessionConverter.convertBranchSession(session.getBranchSessions())));
        }
        return result;
    }

    public static Set<BranchSessionVO> convertBranchSession(List<BranchSession> branchSessions) {
        if (CollectionUtils.isEmpty(branchSessions)) {
            return Collections.emptySet();
        }
        HashSet<BranchSessionVO> result = new HashSet<BranchSessionVO>(branchSessions.size());
        for (BranchSession session : branchSessions) {
            result.add(new BranchSessionVO(session.getXid(), session.getTransactionId(), session.getBranchId(), session.getResourceGroupId(), session.getResourceId(), session.getBranchType().name(), session.getStatus().getCode(), session.getClientId(), session.getApplicationData()));
        }
        return result;
    }
}

