/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonb;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbException;
import org.apache.johnzon.jsonb.extension.JsonValueReader;
import org.apache.johnzon.jsonb.extension.JsonValueWriter;
import org.apache.johnzon.mapper.Mapper;
import org.apache.johnzon.mapper.MapperException;
import org.apache.johnzon.mapper.reflection.JohnzonParameterizedType;

public class JohnzonJsonb
implements Jsonb,
AutoCloseable {
    private final Mapper delegate;

    public JohnzonJsonb(Mapper build) {
        this.delegate = build;
    }

    public <T> T fromJson(String str, Class<T> type) throws JsonbException {
        try {
            if (this.isArray(type)) {
                return (T)this.delegate.readTypedArray((Reader)new StringReader(str), type.getComponentType(), type);
            }
            if (Collection.class.isAssignableFrom(type)) {
                return (T)this.delegate.readCollection((Reader)new StringReader(str), (ParameterizedType)new JohnzonParameterizedType(type, new Type[]{Object.class}));
            }
            Type mappingType = this.unwrapPrimitiveOptional(type);
            Object object = this.delegate.readObject(str, mappingType);
            if (mappingType != type) {
                return this.wrapPrimitiveOptional(object, type);
            }
            return (T)object;
        }
        catch (MapperException me) {
            throw new JsonbException(me.getMessage(), (Throwable)me);
        }
    }

    private <T> T wrapPrimitiveOptional(Object object, Type type) {
        if (OptionalDouble.class == type) {
            if (object == null) {
                return (T)OptionalDouble.empty();
            }
            return (T)OptionalDouble.of(((Number)Number.class.cast(object)).doubleValue());
        }
        if (OptionalInt.class == type) {
            if (object == null) {
                return (T)OptionalInt.empty();
            }
            return (T)OptionalInt.of(((Number)Number.class.cast(object)).intValue());
        }
        if (OptionalLong.class == type) {
            if (object == null) {
                return (T)OptionalLong.empty();
            }
            return (T)OptionalLong.of(((Number)Number.class.cast(object)).longValue());
        }
        return (T)Optional.ofNullable(object);
    }

    private Type unwrapPrimitiveOptional(Type type) {
        ParameterizedType pt;
        if (OptionalDouble.class == type) {
            return Double.TYPE;
        }
        if (OptionalInt.class == type) {
            return Integer.TYPE;
        }
        if (OptionalLong.class == type) {
            return Long.TYPE;
        }
        if (ParameterizedType.class.isInstance(type) && Optional.class == (pt = (ParameterizedType)ParameterizedType.class.cast(type)).getRawType()) {
            return pt.getActualTypeArguments()[0];
        }
        return type;
    }

    public <T> T fromJson(String str, Type runtimeType) throws JsonbException {
        try {
            if (this.isArray(runtimeType)) {
                Class cast = (Class)Class.class.cast(runtimeType);
                return (T)this.delegate.readTypedArray((Reader)new StringReader(str), cast.getComponentType(), cast);
            }
            if (this.isCollection(runtimeType)) {
                return (T)this.delegate.readCollection((Reader)new StringReader(str), (ParameterizedType)ParameterizedType.class.cast(runtimeType));
            }
            Type mappingType = this.unwrapPrimitiveOptional(runtimeType);
            Object object = this.delegate.readObject(str, mappingType);
            if (mappingType != runtimeType) {
                return this.wrapPrimitiveOptional(object, runtimeType);
            }
            return (T)object;
        }
        catch (MapperException me) {
            throw new JsonbException(me.getMessage(), (Throwable)me);
        }
    }

    public <T> T fromJson(Reader reader, Class<T> type) throws JsonbException {
        if (JsonValueReader.class.isInstance(reader)) {
            return (T)this.delegate.readObject(((JsonValueReader)JsonValueReader.class.cast(reader)).getInput(), type);
        }
        try {
            if (this.isArray(type)) {
                return (T)this.delegate.readTypedArray(reader, type.getComponentType(), type);
            }
            if (Collection.class.isAssignableFrom(type)) {
                return (T)this.delegate.readCollection(reader, (ParameterizedType)new JohnzonParameterizedType(type, new Type[]{Object.class}));
            }
            Type mappingType = this.unwrapPrimitiveOptional(type);
            Object object = this.delegate.readObject(reader, mappingType);
            if (mappingType != type) {
                return this.wrapPrimitiveOptional(object, type);
            }
            return (T)object;
        }
        catch (MapperException me) {
            throw new JsonbException(me.getMessage(), (Throwable)me);
        }
    }

    public <T> T fromJson(Reader reader, Type runtimeType) throws JsonbException {
        if (JsonValueReader.class.isInstance(reader)) {
            return (T)this.delegate.readObject(((JsonValueReader)JsonValueReader.class.cast(reader)).getInput(), runtimeType);
        }
        try {
            if (this.isArray(runtimeType)) {
                Class type = (Class)Class.class.cast(runtimeType);
                return (T)this.delegate.readTypedArray(reader, type.getComponentType(), type);
            }
            if (this.isCollection(runtimeType)) {
                return (T)this.delegate.readCollection(reader, (ParameterizedType)ParameterizedType.class.cast(runtimeType));
            }
            Type mappingType = this.unwrapPrimitiveOptional(runtimeType);
            Object object = this.delegate.readObject(reader, mappingType);
            if (mappingType != runtimeType) {
                return this.wrapPrimitiveOptional(object, runtimeType);
            }
            return (T)object;
        }
        catch (MapperException me) {
            throw new JsonbException(me.getMessage(), (Throwable)me);
        }
    }

    public <T> T fromJson(InputStream stream, Class<T> type) throws JsonbException {
        try {
            if (this.isArray(type)) {
                return (T)this.delegate.readTypedArray(stream, type.getComponentType(), type);
            }
            if (Collection.class.isAssignableFrom(type)) {
                return (T)this.delegate.readCollection(stream, (ParameterizedType)new JohnzonParameterizedType(type, new Type[]{Object.class}));
            }
            Type mappingType = this.unwrapPrimitiveOptional(type);
            Object object = this.delegate.readObject(stream, mappingType);
            if (mappingType != type) {
                return this.wrapPrimitiveOptional(object, type);
            }
            return (T)object;
        }
        catch (MapperException me) {
            throw new JsonbException(me.getMessage(), (Throwable)me);
        }
    }

    public <T> T fromJson(InputStream stream, Type runtimeType) throws JsonbException {
        try {
            if (this.isArray(runtimeType)) {
                Class type = (Class)Class.class.cast(runtimeType);
                return (T)this.delegate.readTypedArray(stream, type.getComponentType(), type);
            }
            if (this.isCollection(runtimeType)) {
                return (T)this.delegate.readCollection(stream, (ParameterizedType)ParameterizedType.class.cast(runtimeType));
            }
            Type mappingType = this.unwrapPrimitiveOptional(runtimeType);
            Object object = this.delegate.readObject(stream, mappingType);
            if (mappingType != runtimeType) {
                return this.wrapPrimitiveOptional(object, runtimeType);
            }
            return (T)object;
        }
        catch (MapperException me) {
            throw new JsonbException(me.getMessage(), (Throwable)me);
        }
    }

    public String toJson(Object inObject) throws JsonbException {
        try {
            Object object = this.unwrapOptional(inObject);
            if (object == null) {
                return "null";
            }
            if (this.isArray(object.getClass())) {
                return this.delegate.writeArrayAsString(this.toArray(object));
            }
            if (Collection.class.isInstance(object)) {
                return this.delegate.writeArrayAsString((Collection)Collection.class.cast(object));
            }
            return this.delegate.writeObjectAsString(object);
        }
        catch (MapperException me) {
            throw new JsonbException(me.getMessage(), (Throwable)me);
        }
    }

    private Object[] toArray(Object object) {
        Object[] array;
        Class<?> componentType = object.getClass().getComponentType();
        if (Integer.TYPE == componentType) {
            int length = Array.getLength(object);
            array = new Integer[length];
            for (int i = 0; i < length; ++i) {
                array[i] = Array.getInt(object, i);
            }
        } else if (Double.TYPE == componentType) {
            int length = Array.getLength(object);
            array = new Integer[length];
            for (int i = 0; i < length; ++i) {
                array[i] = Array.getDouble(object, i);
            }
        } else if (Byte.TYPE == componentType) {
            int length = Array.getLength(object);
            array = new Integer[length];
            for (int i = 0; i < length; ++i) {
                array[i] = Array.getByte(object, i);
            }
        } else if (Character.TYPE == componentType) {
            int length = Array.getLength(object);
            array = new Integer[length];
            for (int i = 0; i < length; ++i) {
                array[i] = Character.valueOf(Array.getChar(object, i));
            }
        } else if (Float.TYPE == componentType) {
            int length = Array.getLength(object);
            array = new Integer[length];
            for (int i = 0; i < length; ++i) {
                array[i] = Float.valueOf(Array.getFloat(object, i));
            }
        } else if (Long.TYPE == componentType) {
            int length = Array.getLength(object);
            array = new Integer[length];
            for (int i = 0; i < length; ++i) {
                array[i] = Array.getLong(object, i);
            }
        } else if (Short.TYPE == componentType) {
            int length = Array.getLength(object);
            array = new Integer[length];
            for (int i = 0; i < length; ++i) {
                array[i] = Array.getShort(object, i);
            }
        } else {
            array = (Object[])object;
        }
        return array;
    }

    public String toJson(Object inObject, Type runtimeType) throws JsonbException {
        Object object = this.unwrapOptional(inObject);
        if (object != null && this.isArray(runtimeType)) {
            return this.delegate.writeArrayAsString((Object[])object);
        }
        if (this.isCollection(runtimeType)) {
            return this.delegate.writeArrayAsString((Collection)Collection.class.cast(object));
        }
        return this.delegate.writeObjectAsString(object);
    }

    public void toJson(Object inObject, Writer writer) throws JsonbException {
        if (JsonValueWriter.class.isInstance(writer)) {
            ((JsonValueWriter)JsonValueWriter.class.cast(writer)).setResult(this.delegate.toStructure(inObject));
            return;
        }
        Object object = this.unwrapOptional(inObject);
        if (object != null && this.isArray(object.getClass())) {
            this.delegate.writeArray((Object[])object, writer);
        } else if (Collection.class.isInstance(object)) {
            this.delegate.writeArray((Collection)Collection.class.cast(object), writer);
        } else {
            this.delegate.writeObject(object, writer);
        }
    }

    public void toJson(Object inObject, Type runtimeType, Writer writer) throws JsonbException {
        if (JsonValueWriter.class.isInstance(writer)) {
            ((JsonValueWriter)JsonValueWriter.class.cast(writer)).setResult(this.delegate.toStructure(inObject));
            return;
        }
        Object object = this.unwrapOptional(inObject);
        if (object != null && this.isArray(runtimeType)) {
            this.delegate.writeArray((Object[])object, writer);
        } else if (this.isCollection(runtimeType)) {
            this.delegate.writeArray((Collection)Collection.class.cast(object), writer);
        } else {
            this.delegate.writeObject(object, writer);
        }
    }

    public void toJson(Object inObject, OutputStream stream) throws JsonbException {
        Object object = this.unwrapOptional(inObject);
        if (object != null && this.isArray(object.getClass())) {
            this.delegate.writeArray((Object[])object, stream);
        } else if (Collection.class.isInstance(object)) {
            this.delegate.writeArray((Collection)Collection.class.cast(object), stream);
        } else {
            this.delegate.writeObject(object, stream);
        }
    }

    public void toJson(Object inObject, Type runtimeType, OutputStream stream) throws JsonbException {
        Object object = this.unwrapOptional(inObject);
        if (object != null && this.isArray(runtimeType)) {
            this.delegate.writeArray((Object[])object, stream);
        } else if (this.isCollection(runtimeType)) {
            this.delegate.writeArray((Collection)Collection.class.cast(object), stream);
        } else {
            this.delegate.writeObject(object, stream);
        }
    }

    private Object unwrapOptional(Object inObject) {
        if (Optional.class.isInstance(inObject)) {
            return ((Optional)Optional.class.cast(inObject)).orElse(null);
        }
        if (OptionalInt.class.isInstance(inObject)) {
            OptionalInt optionalInt = (OptionalInt)OptionalInt.class.cast(inObject);
            return optionalInt.isPresent() ? Integer.valueOf(optionalInt.getAsInt()) : null;
        }
        if (OptionalLong.class.isInstance(inObject)) {
            OptionalLong optionalLong = (OptionalLong)OptionalLong.class.cast(inObject);
            return optionalLong.isPresent() ? Long.valueOf(optionalLong.getAsLong()) : null;
        }
        if (OptionalDouble.class.isInstance(inObject)) {
            OptionalDouble optionalDouble = (OptionalDouble)OptionalDouble.class.cast(inObject);
            return optionalDouble.isPresent() ? Double.valueOf(optionalDouble.getAsDouble()) : null;
        }
        return inObject;
    }

    private boolean isArray(Type runtimeType) {
        return Class.class.isInstance(runtimeType) && ((Class)Class.class.cast(runtimeType)).isArray();
    }

    private boolean isCollection(Type runtimeType) {
        if (!ParameterizedType.class.isInstance(runtimeType)) {
            return false;
        }
        Type rawType = ((ParameterizedType)ParameterizedType.class.cast(runtimeType)).getRawType();
        return Class.class.isInstance(rawType) && Collection.class.isAssignableFrom((Class)Class.class.cast(rawType));
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

