/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.ui.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.dto.ApiResult;
import org.dromara.warm.flow.core.dto.DefJson;
import org.dromara.warm.flow.core.dto.FlowDto;
import org.dromara.warm.flow.core.dto.FlowParams;
import org.dromara.warm.flow.core.entity.Form;
import org.dromara.warm.flow.core.entity.Instance;
import org.dromara.warm.flow.core.exception.FlowException;
import org.dromara.warm.flow.core.invoker.FrameInvoker;
import org.dromara.warm.flow.core.utils.ExceptionUtil;
import org.dromara.warm.flow.ui.dto.HandlerQuery;
import org.dromara.warm.flow.ui.service.HandlerDictService;
import org.dromara.warm.flow.ui.service.HandlerSelectService;
import org.dromara.warm.flow.ui.service.NodeExtService;
import org.dromara.warm.flow.ui.vo.Dict;
import org.dromara.warm.flow.ui.vo.HandlerSelectVo;
import org.dromara.warm.flow.ui.vo.NodeExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/warm-flow"})
public class WarmFlowController {
    private static final Logger log = LoggerFactory.getLogger(WarmFlowController.class);

    @PostMapping(value={"/save-json"})
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Void> saveJson(@RequestBody DefJson defJson) throws Exception {
        FlowEngine.defService().saveDef(defJson);
        return ApiResult.ok();
    }

    @GetMapping(value={"/query-def/{id}"})
    public ApiResult<DefJson> queryDef(@PathVariable(value="id") Long id) {
        try {
            return ApiResult.ok((Object)FlowEngine.defService().queryDesign(id));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6d41\u7a0bjson\u5b57\u7b26\u4e32", (Throwable)e);
            throw new FlowException(ExceptionUtil.handleMsg((String)"\u83b7\u53d6\u6d41\u7a0bjson\u5b57\u7b26\u4e32\u5931\u8d25", (Exception)e));
        }
    }

    @GetMapping(value={"/handler-type"})
    public ApiResult<List<String>> handlerType() {
        try {
            HandlerSelectService handlerSelectService = (HandlerSelectService)FrameInvoker.getBean(HandlerSelectService.class);
            if (handlerSelectService == null) {
                return ApiResult.ok(Collections.emptyList());
            }
            List handlerType = handlerSelectService.getHandlerType();
            return ApiResult.ok((Object)handlerType);
        }
        catch (Exception e) {
            log.error("\u529e\u7406\u4eba\u6743\u9650\u8bbe\u7f6e\u5217\u8868tabs\u9875\u7b7e\u5f02\u5e38", (Throwable)e);
            throw new FlowException(ExceptionUtil.handleMsg((String)"\u529e\u7406\u4eba\u6743\u9650\u8bbe\u7f6e\u5217\u8868tabs\u9875\u7b7e\u5931\u8d25", (Exception)e));
        }
    }

    @GetMapping(value={"/handler-result"})
    public ApiResult<HandlerSelectVo> handlerResult(HandlerQuery query) {
        try {
            HandlerSelectService handlerSelectService = (HandlerSelectService)FrameInvoker.getBean(HandlerSelectService.class);
            if (handlerSelectService == null) {
                return ApiResult.ok((Object)new HandlerSelectVo());
            }
            HandlerSelectVo handlerSelectVo = handlerSelectService.getHandlerSelect(query);
            return ApiResult.ok((Object)handlerSelectVo);
        }
        catch (Exception e) {
            log.error("\u529e\u7406\u4eba\u6743\u9650\u8bbe\u7f6e\u5217\u8868\u7ed3\u679c\u5f02\u5e38", (Throwable)e);
            throw new FlowException(ExceptionUtil.handleMsg((String)"\u529e\u7406\u4eba\u6743\u9650\u8bbe\u7f6e\u5217\u8868\u7ed3\u679c\u5931\u8d25", (Exception)e));
        }
    }

    @GetMapping(value={"/handler-dict"})
    public ApiResult<List<Dict>> handlerDict() {
        try {
            HandlerDictService handlerDictService = (HandlerDictService)FrameInvoker.getBean(HandlerDictService.class);
            if (handlerDictService == null) {
                ArrayList<Dict> dictList = new ArrayList<Dict>();
                Dict dict = new Dict();
                dict.setLabel("\u9ed8\u8ba4\u8868\u8fbe\u5f0f");
                dict.setValue("${handler}");
                Dict dict1 = new Dict();
                dict1.setLabel("spel\u8868\u8fbe\u5f0f");
                dict1.setValue("#{@user.evalVar(#handler)}");
                Dict dict2 = new Dict();
                dict2.setLabel("\u5176\u4ed6");
                dict2.setValue("");
                dictList.add(dict);
                dictList.add(dict1);
                dictList.add(dict2);
                return ApiResult.ok(dictList);
            }
            return ApiResult.ok((Object)handlerDictService.getHandlerDict());
        }
        catch (Exception e) {
            log.error("\u529e\u7406\u4eba\u6743\u9650\u8bbe\u7f6e\u5217\u8868\u7ed3\u679c\u5f02\u5e38", (Throwable)e);
            throw new FlowException(ExceptionUtil.handleMsg((String)"\u529e\u7406\u4eba\u6743\u9650\u8bbe\u7f6e\u5217\u8868\u7ed3\u679c\u5931\u8d25", (Exception)e));
        }
    }

    @GetMapping(value={"/published-form"})
    public ApiResult<List<Form>> publishedForm() {
        try {
            return ApiResult.ok((Object)FlowEngine.formService().list((Object)FlowEngine.newForm().setIsPublish(Integer.valueOf(1))));
        }
        catch (Exception e) {
            log.error("\u5df2\u53d1\u5e03\u8868\u5355\u5217\u8868\u5f02\u5e38", (Throwable)e);
            throw new FlowException(ExceptionUtil.handleMsg((String)"\u5df2\u53d1\u5e03\u8868\u5355\u5217\u8868\u5f02\u5e38", (Exception)e));
        }
    }

    @GetMapping(value={"/form-content/{id}"})
    public ApiResult<String> getFormContent(@PathVariable(value="id") Long id) {
        try {
            return ApiResult.ok((Object)FlowEngine.formService().getById(id).getFormContent());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8868\u5355\u5185\u5bb9\u5b57\u7b26\u4e32", (Throwable)e);
            throw new FlowException(ExceptionUtil.handleMsg((String)"\u83b7\u53d6\u8868\u5355\u5185\u5bb9\u5b57\u7b26\u4e32\u5931\u8d25", (Exception)e));
        }
    }

    @PostMapping(value={"/form-content"})
    public ApiResult<Void> saveFormContent(@RequestBody FlowDto flowDto) {
        FlowEngine.formService().saveContent(flowDto.getId(), flowDto.getFormContent());
        return ApiResult.ok();
    }

    @GetMapping(value={"/execute/load/{taskId}"})
    public ApiResult<FlowDto> load(@PathVariable(value="taskId") Long taskId) {
        FlowParams flowParams = FlowParams.build();
        return ApiResult.ok((Object)FlowEngine.taskService().load(taskId, flowParams));
    }

    @GetMapping(value={"/execute/hisLoad/{taskId}"})
    public ApiResult<FlowDto> hisLoad(@PathVariable(value="taskId") Long hisTaskId) {
        FlowParams flowParams = FlowParams.build();
        return ApiResult.ok((Object)FlowEngine.taskService().hisLoad(hisTaskId, flowParams));
    }

    @Transactional
    @PostMapping(value={"/execute/handle"})
    public ApiResult<Instance> handle(@RequestBody Map<String, Object> formData, @RequestParam(value="taskId") Long taskId, @RequestParam(value="taskId") String skipType, @RequestParam(value="taskId") String message, @RequestParam(value="taskId") String nodeCode) {
        FlowParams flowParams = FlowParams.build().skipType(skipType).nodeCode(nodeCode).message(message);
        flowParams.formData(formData);
        return ApiResult.ok((Object)FlowEngine.taskService().skip(taskId, flowParams));
    }

    @GetMapping(value={"/node-ext"})
    public ApiResult<List<NodeExt>> nodeExt() {
        try {
            NodeExtService nodeExtService = (NodeExtService)FrameInvoker.getBean(NodeExtService.class);
            if (nodeExtService == null) {
                return ApiResult.ok(Collections.emptyList());
            }
            List nodeExts = nodeExtService.getNodeExt();
            return ApiResult.ok((Object)nodeExts);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8282\u70b9\u6269\u5c55\u5c5e\u6027", (Throwable)e);
            throw new FlowException(ExceptionUtil.handleMsg((String)"\u83b7\u53d6\u8282\u70b9\u6269\u5c55\u5c5e\u6027\u5931\u8d25", (Exception)e));
        }
    }
}

