/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.access.hc;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.eclipse.jkube.kit.build.api.auth.AuthConfig;
import org.eclipse.jkube.kit.build.service.docker.access.BuildOptions;
import org.eclipse.jkube.kit.build.service.docker.access.CreateImageOptions;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccess;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccessException;
import org.eclipse.jkube.kit.build.service.docker.access.UrlBuilder;
import org.eclipse.jkube.kit.build.service.docker.access.chunked.BuildJsonResponseHandler;
import org.eclipse.jkube.kit.build.service.docker.access.chunked.PullOrPushResponseJsonHandler;
import org.eclipse.jkube.kit.build.service.docker.access.hc.ApacheHttpClientDelegate;
import org.eclipse.jkube.kit.build.service.docker.access.hc.HcChunkedResponseHandlerWrapper;
import org.eclipse.jkube.kit.build.service.docker.access.hc.http.HttpClientBuilder;
import org.eclipse.jkube.kit.build.service.docker.access.hc.unix.UnixSocketClientBuilder;
import org.eclipse.jkube.kit.build.service.docker.access.hc.util.ClientBuilder;
import org.eclipse.jkube.kit.build.service.docker.access.hc.win.NamedPipeClientBuilder;
import org.eclipse.jkube.kit.common.JsonFactory;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.archive.ArchiveCompression;
import org.eclipse.jkube.kit.config.image.ImageName;

public class DockerAccessWithHcClient
implements DockerAccess {
    private static final String UNIX_URL = "unix://127.0.0.1:1/";
    private static final String NPIPE_URL = "npipe://127.0.0.1:1/";
    public static final String API_VERSION = "1.18";
    private final KitLogger log;
    private final ApacheHttpClientDelegate delegate;
    private final UrlBuilder urlBuilder;

    public DockerAccessWithHcClient(String baseUrl, String certPath, int maxConnections, KitLogger log) throws IOException {
        URI uri = URI.create(Objects.requireNonNull(baseUrl, "Docker daemon baseUrl is required"));
        if (uri.getScheme() == null) {
            throw new IllegalArgumentException("The docker access url '" + baseUrl + "' must contain a schema tcp://, unix:// or npipe://");
        }
        if (uri.getScheme().equalsIgnoreCase("unix")) {
            this.delegate = this.createHttpClient(new UnixSocketClientBuilder(uri.getPath(), maxConnections, log));
            baseUrl = UNIX_URL;
        } else if (uri.getScheme().equalsIgnoreCase("npipe")) {
            this.delegate = this.createHttpClient(new NamedPipeClientBuilder(uri.getPath(), maxConnections, log), false);
            baseUrl = NPIPE_URL;
        } else {
            this.delegate = this.createHttpClient(new HttpClientBuilder(DockerAccessWithHcClient.isSSL(baseUrl) ? certPath : null, maxConnections));
        }
        while (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        this.urlBuilder = new UrlBuilder(baseUrl, "v" + this.fetchApiVersionFromServer(baseUrl, this.delegate));
        this.log = log;
    }

    @Override
    public void buildImage(String image, File dockerArchive, BuildOptions options) throws DockerAccessException {
        try {
            String url = this.urlBuilder.buildImage(image, options);
            this.delegate.post(url, (Object)dockerArchive, this.createBuildResponseHandler(), 200);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to build image [%s]", image);
        }
    }

    @Override
    public boolean hasImage(String name) throws DockerAccessException {
        String url = this.urlBuilder.inspectImage(name);
        try {
            return this.delegate.get(url, new ApacheHttpClientDelegate.StatusCodeResponseHandler(), 200, 404) == 200;
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to check image [%s]", name);
        }
    }

    @Override
    public String getImageId(String name) throws DockerAccessException {
        ApacheHttpClientDelegate.HttpBodyAndStatus response = this.inspectImage(name);
        if (response.getStatusCode() == 404) {
            return null;
        }
        JsonObject imageDetails = JsonFactory.newJsonObject((String)response.getBody());
        return imageDetails.get("Id").getAsString().substring(0, 12);
    }

    private ApacheHttpClientDelegate.HttpBodyAndStatus inspectImage(String name) throws DockerAccessException {
        String url = this.urlBuilder.inspectImage(name);
        try {
            return this.delegate.get(url, new ApacheHttpClientDelegate.BodyAndStatusResponseHandler(), 200, 404);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to inspect image [%s]", name);
        }
    }

    @Override
    public void loadImage(String image, File tarArchive) throws DockerAccessException {
        String url = this.urlBuilder.loadImage();
        try {
            this.delegate.post(url, (Object)tarArchive, new ApacheHttpClientDelegate.BodyAndStatusResponseHandler(), 200);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to load %s", tarArchive);
        }
    }

    @Override
    public void pullImage(String image, AuthConfig authConfig, String registry, CreateImageOptions options) throws DockerAccessException {
        String pullUrl = this.urlBuilder.pullImage(options);
        try {
            this.delegate.post(pullUrl, null, this.createAuthHeader(authConfig), this.createPullOrPushResponseHandler(), 200);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to pull '%s'%s", image, registry != null ? " from registry '" + registry + "'" : "");
        }
    }

    @Override
    public void pushImage(String image, AuthConfig authConfig, String registry, int retries) throws DockerAccessException {
        ImageName name = new ImageName(image);
        String pushUrl = this.urlBuilder.pushImage(name, registry);
        TemporaryImageHandler temporaryImageHandler = this.tagTemporaryImage(name, registry);
        DockerAccessException dae = null;
        try {
            this.doPushImage(pushUrl, this.createAuthHeader(authConfig), this.createPullOrPushResponseHandler(), 200, retries);
        }
        catch (IOException e) {
            dae = new DockerAccessException(e, "Unable to push '%s'%s", image, registry != null ? " to registry '" + registry + "'" : "");
            throw dae;
        }
        finally {
            temporaryImageHandler.handle(dae);
        }
    }

    @Override
    public void saveImage(String image, String filename, ArchiveCompression compression) throws DockerAccessException {
        ImageName name = new ImageName(image);
        String url = this.urlBuilder.getImage(name);
        try {
            this.delegate.get(url, this.getImageResponseHandler(filename, compression), 200);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to save '%s' to '%s'", image, filename);
        }
    }

    private ResponseHandler<Object> getImageResponseHandler(String filename, ArchiveCompression compression) {
        return response -> {
            try (InputStream stream = response.getEntity().getContent();
                 OutputStream out = compression.wrapOutputStream((OutputStream)new FileOutputStream(filename));){
                IOUtils.copy((InputStream)stream, (OutputStream)out, (int)65536);
            }
            return null;
        };
    }

    @Override
    public void tag(String sourceImage, String targetImage, boolean force) throws DockerAccessException {
        ImageName source = new ImageName(sourceImage);
        ImageName target = new ImageName(targetImage);
        try {
            String url = this.urlBuilder.tagContainer(source, target, force);
            this.delegate.post(url, 201);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to add tag [%s] to image [%s]", targetImage, sourceImage, e);
        }
    }

    @Override
    public boolean removeImage(String image, boolean ... forceOpt) throws DockerAccessException {
        boolean force = forceOpt != null && forceOpt.length > 0 && forceOpt[0];
        try {
            String url = this.urlBuilder.deleteImage(image, force);
            ApacheHttpClientDelegate.HttpBodyAndStatus response = this.delegate.delete(url, new ApacheHttpClientDelegate.BodyAndStatusResponseHandler(), 200, 404);
            if (this.log.isDebugEnabled()) {
                this.logRemoveResponse(JsonFactory.newJsonArray((String)response.getBody()));
            }
            return response.getStatusCode() == 200;
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to remove image [%s]", image);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void shutdown() {
        try {
            this.delegate.close();
        }
        catch (IOException exp) {
            this.log.error("Error while closing HTTP client: " + exp, new Object[]{exp});
        }
    }

    ApacheHttpClientDelegate createHttpClient(ClientBuilder builder) throws IOException {
        return this.createHttpClient(builder, true);
    }

    ApacheHttpClientDelegate createHttpClient(ClientBuilder builder, boolean pooled) throws IOException {
        return new ApacheHttpClientDelegate(builder, pooled);
    }

    private HcChunkedResponseHandlerWrapper createBuildResponseHandler() {
        return new HcChunkedResponseHandlerWrapper(new BuildJsonResponseHandler(this.log));
    }

    private HcChunkedResponseHandlerWrapper createPullOrPushResponseHandler() {
        return new HcChunkedResponseHandlerWrapper(new PullOrPushResponseJsonHandler(this.log));
    }

    private Map<String, String> createAuthHeader(AuthConfig authConfig) {
        if (authConfig == null) {
            authConfig = AuthConfig.EMPTY_AUTH_CONFIG;
        }
        return Collections.singletonMap("X-Registry-Auth", authConfig.toHeaderValue(this.log));
    }

    private boolean isRetryableErrorCode(int errorCode) {
        return errorCode == 500;
    }

    private void doPushImage(String url, Map<String, String> header, HcChunkedResponseHandlerWrapper handler, int status, int retries) throws IOException {
        for (int i = 0; i <= retries; ++i) {
            try {
                this.delegate.post(url, null, header, handler, 200);
                return;
            }
            catch (HttpResponseException e) {
                if (!this.isRetryableErrorCode(e.getStatusCode()) || i == retries) {
                    throw e;
                }
                this.log.warn("failed to push image to [{}], retrying...", new Object[]{url});
                continue;
            }
        }
    }

    private TemporaryImageHandler tagTemporaryImage(ImageName name, String registry) throws DockerAccessException {
        String targetImage = name.getFullName(registry);
        String fullName = name.getFullName();
        if (name.isFullyQualifiedName() && name.hasRegistry() || targetImage.equals(fullName) || registry == null) {
            return () -> this.log.info("Temporary image tag skipped. Target image '%s' already has registry set or no registry is available", new Object[]{targetImage});
        }
        boolean alreadyHasImage = this.hasImage(targetImage);
        if (alreadyHasImage) {
            this.log.warn("Target image '%s' already exists. Tagging of '%s' will replace existing image", new Object[]{targetImage, fullName});
        }
        this.tag(fullName, targetImage, false);
        return alreadyHasImage ? () -> this.log.info("Tagged image '%s' won't be removed after tagging as it already existed", new Object[]{targetImage}) : new RemovingTemporaryImageHandler(targetImage);
    }

    private void logRemoveResponse(JsonArray logElements) {
        for (int i = 0; i < logElements.size(); ++i) {
            JsonObject entry = logElements.get(i).getAsJsonObject();
            for (Object key : entry.keySet()) {
                this.log.debug("%s: %s", new Object[]{key, entry.get(key.toString())});
            }
        }
    }

    private static boolean isSSL(String url) {
        return url != null && url.toLowerCase().startsWith("https");
    }

    public String fetchApiVersionFromServer(String baseUrl, ApacheHttpClientDelegate delegate) throws IOException {
        HttpGet get = new HttpGet(baseUrl + (baseUrl.endsWith("/") ? "" : "/") + "version");
        get.addHeader("Accept", "*/*");
        get.addHeader("Content-Type", "application/json");
        try (CloseableHttpResponse response = delegate.getHttpClient().execute((HttpUriRequest)get);){
            String string = response.getFirstHeader("Api-Version") != null ? response.getFirstHeader("Api-Version").getValue() : API_VERSION;
            return string;
        }
    }

    private final class RemovingTemporaryImageHandler
    implements TemporaryImageHandler {
        private final String targetImage;

        private RemovingTemporaryImageHandler(String targetImage) {
            this.targetImage = targetImage;
        }

        @Override
        public void handle() throws DockerAccessException {
            boolean imageRemoved = DockerAccessWithHcClient.this.removeImage(this.targetImage, true);
            if (imageRemoved) {
                return;
            }
            throw new DockerAccessException("Image %s could be pushed, but the temporary tag could not be removed", this.targetImage);
        }
    }

    @FunctionalInterface
    private static interface TemporaryImageHandler {
        public void handle() throws DockerAccessException;

        default public void handle(DockerAccessException interruptingError) throws DockerAccessException {
            this.handle();
            if (interruptingError == null) {
                return;
            }
            throw interruptingError;
        }
    }
}

