/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.auth;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.jkube.kit.build.api.auth.AuthConfig;
import org.eclipse.jkube.kit.build.api.helper.DockerFileUtil;
import org.eclipse.jkube.kit.build.api.helper.KubernetesConfigAuthUtil;
import org.eclipse.jkube.kit.build.service.docker.auth.CredentialHelperClient;
import org.eclipse.jkube.kit.build.service.docker.auth.ecr.AwsSdkAuthConfigFactory;
import org.eclipse.jkube.kit.build.service.docker.auth.ecr.AwsSdkHelper;
import org.eclipse.jkube.kit.build.service.docker.auth.ecr.EcrExtendedAuth;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.RegistryServerConfiguration;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.common.util.Serialization;

public class AuthConfigFactory {
    private static final String AUTH_USERNAME = "username";
    private static final String AUTH_PASSWORD = "password";
    private static final String AUTH_EMAIL = "email";
    private static final String AUTH_AUTHTOKEN = "authToken";
    private static final String AUTH_USE_OPENSHIFT_AUTH = "useOpenShiftAuth";
    private static final String DOCKER_LOGIN_DEFAULT_REGISTRY = "https://index.docker.io/v1/";
    private final KitLogger log;
    private final AwsSdkHelper awsSdkHelper;
    private static final String[] DEFAULT_REGISTRIES = new String[]{"docker.io", "index.docker.io", "registry.hub.docker.com"};

    public AuthConfigFactory(KitLogger log) {
        this(log, new AwsSdkHelper());
    }

    AuthConfigFactory(KitLogger log, AwsSdkHelper awsSdkHelper) {
        this.log = log;
        this.awsSdkHelper = awsSdkHelper;
    }

    public AuthConfig createAuthConfig(boolean isPush, boolean skipExtendedAuth, Map authConfig, List<RegistryServerConfiguration> settings, String user, String registry, UnaryOperator<String> passwordDecryptionMethod) throws IOException {
        AuthConfig ret = AuthConfigFactory.createStandardAuthConfig(isPush, authConfig, settings, user, registry, passwordDecryptionMethod, this.log, this.awsSdkHelper);
        if (ret != null) {
            if (registry == null || skipExtendedAuth) {
                return ret;
            }
            try {
                return this.extendedAuthentication(ret, registry);
            }
            catch (IOException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        ret = AuthConfigFactory.getAuthConfigFromDockerConfig(registry, this.log);
        if (ret != null) {
            this.log.debug("AuthConfig: credentials from ~/.docker/config.json", new Object[0]);
            return ret;
        }
        this.log.debug("AuthConfig: no credentials found", new Object[0]);
        return null;
    }

    private AuthConfig extendedAuthentication(AuthConfig standardAuthConfig, String registry) throws IOException {
        EcrExtendedAuth ecr = new EcrExtendedAuth(this.log, registry);
        if (ecr.isAwsRegistry()) {
            return ecr.extendedAuth(standardAuthConfig);
        }
        return standardAuthConfig;
    }

    private static AuthConfig createStandardAuthConfig(boolean isPush, Map authConfigMap, List<RegistryServerConfiguration> settings, String user, String registry, UnaryOperator<String> passwordDecryptionMethod, KitLogger log, AwsSdkHelper awsSdkHelper) throws IOException {
        AuthConfig ret;
        for (LookupMode lookupMode : new LookupMode[]{AuthConfigFactory.getLookupMode(isPush), LookupMode.DEFAULT}) {
            ret = AuthConfigFactory.getAuthConfigFromSystemProperties(lookupMode, passwordDecryptionMethod);
            if (ret != null) {
                log.debug("AuthConfig: credentials from system properties", new Object[0]);
                return ret;
            }
            ret = AuthConfigFactory.getAuthConfigFromOpenShiftConfig(lookupMode, authConfigMap);
            if (ret != null) {
                log.debug("AuthConfig: OpenShift credentials", new Object[0]);
                return ret;
            }
            ret = AuthConfigFactory.getAuthConfigFromPluginConfiguration(lookupMode, authConfigMap, passwordDecryptionMethod);
            if (ret == null) continue;
            log.debug("AuthConfig: credentials from plugin config", new Object[0]);
            return ret;
        }
        ret = AuthConfigFactory.getAuthConfigFromSettings(settings, user, registry, passwordDecryptionMethod);
        if (ret != null) {
            log.debug("AuthConfig: credentials from ~/.m2/setting.xml", new Object[0]);
            return ret;
        }
        if (EcrExtendedAuth.isAwsRegistry(registry)) {
            ret = AuthConfigFactory.getAuthConfigViaAwsSdk(awsSdkHelper, log);
            if (ret != null) {
                log.debug("AuthConfig: AWS credentials from AWS SDK", new Object[0]);
                return ret;
            }
            ret = AuthConfigFactory.getAuthConfigFromAwsEnvironmentVariables(awsSdkHelper, log);
            if (ret != null) {
                log.debug("AuthConfig: AWS credentials from ENV variables", new Object[0]);
                return ret;
            }
            try {
                ret = AuthConfigFactory.getAuthConfigFromEC2InstanceRole(log);
            }
            catch (ConnectTimeoutException ex) {
                log.debug("Connection timeout while retrieving instance meta-data, likely not an EC2 instance (%s)", new Object[]{ex.getMessage()});
            }
            catch (IOException ex) {
                log.warn("Error while retrieving EC2 instance credentials: %s", new Object[]{ex.getMessage()});
            }
            if (ret != null) {
                log.debug("AuthConfig: credentials from EC2 instance role", new Object[0]);
                return ret;
            }
            try {
                ret = AuthConfigFactory.getAuthConfigFromTaskRole(awsSdkHelper, log);
            }
            catch (ConnectTimeoutException ex) {
                log.debug("Connection timeout while retrieving ECS meta-data, likely not an ECS instance (%s)", new Object[]{ex.getMessage()});
            }
            catch (IOException ex) {
                log.warn("Error while retrieving ECS Task role credentials: %s", new Object[]{ex.getMessage()});
            }
            if (ret != null) {
                log.debug("AuthConfig: credentials from ECS Task role", new Object[0]);
                return ret;
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static AuthConfig getAuthConfigFromEC2InstanceRole(KitLogger log) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static AuthConfig getAuthConfigFromSystemProperties(LookupMode lookupMode, UnaryOperator<String> passwordDecryptionMethod) throws IOException {
        String passwordKey = lookupMode.asSysProperty(AUTH_PASSWORD);
        String username = System.getProperty(lookupMode.asSysProperty(AUTH_USERNAME));
        String password = System.getProperty(passwordKey);
        if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isBlank((CharSequence)password)) {
            throw new IOException("No " + passwordKey + " provided for username " + username);
        }
        if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
            return new AuthConfig(username, (String)passwordDecryptionMethod.apply(password), System.getProperty(lookupMode.asSysProperty(AUTH_EMAIL)), System.getProperty(lookupMode.asSysProperty(AUTH_AUTHTOKEN)));
        }
        return null;
    }

    protected static AuthConfig getAuthConfigFromOpenShiftConfig(LookupMode lookupMode, Map authConfigMap) {
        String useOpenAuthModeKey = lookupMode.asSysProperty(AUTH_USE_OPENSHIFT_AUTH);
        String useOpenAuthMode = System.getProperty(useOpenAuthModeKey);
        if (StringUtils.isNotBlank((CharSequence)useOpenAuthMode)) {
            boolean useOpenShift = Boolean.parseBoolean(useOpenAuthMode);
            if (useOpenShift) {
                return AuthConfigFactory.validateMandatoryOpenShiftLogin(KubernetesConfigAuthUtil.readKubeConfigAuth(), useOpenAuthModeKey);
            }
            return null;
        }
        Map<String, String> mapToCheck = AuthConfigFactory.getAuthConfigMapToCheck(lookupMode, authConfigMap);
        if (mapToCheck != null && mapToCheck.containsKey(AUTH_USE_OPENSHIFT_AUTH) && Boolean.parseBoolean(mapToCheck.get(AUTH_USE_OPENSHIFT_AUTH))) {
            return AuthConfigFactory.validateMandatoryOpenShiftLogin(KubernetesConfigAuthUtil.readKubeConfigAuth(), useOpenAuthModeKey);
        }
        return null;
    }

    protected static AuthConfig getAuthConfigFromPluginConfiguration(LookupMode lookupMode, Map<String, ?> authConfig, UnaryOperator<String> passwordDecryptionMethod) {
        Map<String, String> mapToCheck = AuthConfigFactory.getAuthConfigMapToCheck(lookupMode, authConfig);
        if (mapToCheck != null && mapToCheck.containsKey(AUTH_USERNAME)) {
            if (!mapToCheck.containsKey(AUTH_PASSWORD)) {
                throw new IllegalStateException("No 'password' given while using <authConfig> in configuration for mode " + (Object)((Object)lookupMode));
            }
            HashMap<String, String> cloneConfig = new HashMap<String, String>(mapToCheck);
            cloneConfig.put(AUTH_PASSWORD, (String)passwordDecryptionMethod.apply((String)cloneConfig.get(AUTH_PASSWORD)));
            return AuthConfig.fromMap(cloneConfig);
        }
        return null;
    }

    protected static AuthConfig getAuthConfigFromSettings(List<RegistryServerConfiguration> settings, String user, String registry, UnaryOperator<String> passwordDecryptionMethod) {
        RegistryServerConfiguration defaultServer = null;
        for (RegistryServerConfiguration server : settings) {
            RegistryServerConfiguration found;
            String id = server.getId();
            if (defaultServer == null) {
                defaultServer = AuthConfigFactory.checkForServer(server, id, registry, null);
            }
            if ((found = AuthConfigFactory.checkForServer(server, id, registry, user)) == null) continue;
            return AuthConfigFactory.createAuthConfigFromServer(found, passwordDecryptionMethod);
        }
        return defaultServer != null ? AuthConfigFactory.createAuthConfigFromServer(defaultServer, passwordDecryptionMethod) : null;
    }

    protected static AuthConfig getAuthConfigFromDockerConfig(String registry, KitLogger log) throws IOException {
        Map credHelpers;
        String registryToLookup;
        Map dockerConfig = DockerFileUtil.readDockerConfig();
        if (dockerConfig == null) {
            return null;
        }
        String string = registryToLookup = registry != null ? registry : DOCKER_LOGIN_DEFAULT_REGISTRY;
        if (dockerConfig.containsKey("credHelpers") && (credHelpers = (Map)dockerConfig.get("credHelpers")).containsKey(registryToLookup)) {
            return AuthConfigFactory.extractAuthConfigFromCredentialsHelper(registryToLookup, credHelpers.get(registryToLookup).toString(), log);
        }
        if (dockerConfig.containsKey("credsStore")) {
            return AuthConfigFactory.extractAuthConfigFromCredentialsHelper(registryToLookup, dockerConfig.get("credsStore").toString(), log);
        }
        if (dockerConfig.containsKey("auths")) {
            return AuthConfigFactory.extractAuthConfigFromAuths(registryToLookup, (Map)dockerConfig.get("auths"));
        }
        return null;
    }

    private static AuthConfig extractAuthConfigFromAuths(String registryToLookup, Map<String, Object> auths) {
        Map<String, Object> credentials = AuthConfigFactory.getCredentialsNode(auths, registryToLookup);
        if (credentials == null || !credentials.containsKey("auth")) {
            return null;
        }
        String auth = credentials.get("auth").toString();
        String email = credentials.containsKey(AUTH_EMAIL) ? credentials.get(AUTH_EMAIL).toString() : null;
        return AuthConfig.fromCredentialsEncoded((String)auth, (String)email);
    }

    private static AuthConfig extractAuthConfigFromCredentialsHelper(String registryToLookup, String credConfig, KitLogger log) throws IOException {
        CredentialHelperClient credentialHelper = new CredentialHelperClient(log, credConfig);
        String version = credentialHelper.getVersion();
        log.debug("AuthConfig: credentials from credential helper/store %s%s", new Object[]{credentialHelper.getName(), version != null ? " version " + version : ""});
        return credentialHelper.getAuthConfig(registryToLookup);
    }

    private static Map<String, Object> getCredentialsNode(Map<String, Object> auths, String registryToLookup) {
        if (auths.containsKey(registryToLookup)) {
            return (Map)auths.get(registryToLookup);
        }
        String registryWithScheme = EnvUtil.ensureRegistryHttpUrl((String)registryToLookup);
        if (auths.containsKey(registryWithScheme)) {
            return (Map)auths.get(registryWithScheme);
        }
        return Collections.emptyMap();
    }

    private static AuthConfig getAuthConfigFromTaskRole(AwsSdkHelper awsSdkHelper, KitLogger log) throws IOException {
        log.debug("No user and password set for ECR, checking ECS Task role", new Object[0]);
        URI uri = AuthConfigFactory.getMetadataEndpointForCredentials(awsSdkHelper, log);
        if (uri == null) {
            return null;
        }
        log.debug("Getting temporary security credentials from: %s", new Object[]{uri});
        try (CloseableHttpClient client = HttpClients.custom().useSystemProperties().build();){
            RequestConfig conf = RequestConfig.custom().setConnectionRequestTimeout(1000).setConnectTimeout(1000).setSocketTimeout(1000).build();
            HttpGet request = new HttpGet(uri);
            request.setConfig(conf);
            AuthConfig authConfig = AuthConfigFactory.readAwsCredentials(client, request, log);
            return authConfig;
        }
    }

    private static AuthConfig readAwsCredentials(CloseableHttpClient client, HttpGet request, KitLogger log) throws IOException {
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
            if (response.getStatusLine().getStatusCode() != 200) {
                log.debug("No security credential found, return code was %d", new Object[]{response.getStatusLine().getStatusCode()});
                AuthConfig authConfig = null;
                return authConfig;
            }
            Map securityCredentials = (Map)Serialization.unmarshal((InputStream)response.getEntity().getContent(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            String user = securityCredentials.getOrDefault("AccessKeyId", "").toString();
            String password = securityCredentials.getOrDefault("SecretAccessKey", "").toString();
            String token = securityCredentials.getOrDefault("Token", "").toString();
            log.debug("Received temporary access key %s...", new Object[]{user.substring(0, 8)});
            AuthConfig authConfig = AuthConfig.builder().username(user).password(password).email("none").auth(token).build();
            return authConfig;
        }
    }

    private static URI getMetadataEndpointForCredentials(AwsSdkHelper awsSdkHelper, KitLogger log) {
        String awsContainerCredentialsUri = awsSdkHelper.getAwsContainerCredentialsRelativeUri();
        if (awsContainerCredentialsUri == null) {
            log.debug("System environment not set for variable AWS_CONTAINER_CREDENTIALS_RELATIVE_URI, no task role found", new Object[0]);
            return null;
        }
        if (awsContainerCredentialsUri.charAt(0) != '/') {
            awsContainerCredentialsUri = "/" + awsContainerCredentialsUri;
        }
        try {
            return new URI(awsSdkHelper.getEcsMetadataEndpoint() + awsContainerCredentialsUri);
        }
        catch (URISyntaxException e) {
            log.warn("Failed to construct path to ECS metadata endpoint for credentials", new Object[]{e});
            return null;
        }
    }

    private static AuthConfig getAuthConfigViaAwsSdk(AwsSdkHelper awsSdkHelper, KitLogger log) {
        boolean credProviderPresent = awsSdkHelper.isDefaultAWSCredentialsProviderChainPresentInClassPath();
        if (!credProviderPresent) {
            log.info("It appears that you're using AWS ECR. Consider integrating the AWS SDK in order to make use of common AWS authentication mechanisms, see https://www.eclipse.dev/jkube/docs/kubernetes-maven-plugin#extended-authentication", new Object[0]);
            return null;
        }
        return new AwsSdkAuthConfigFactory(log, awsSdkHelper).createAuthConfig();
    }

    private static AuthConfig getAuthConfigFromAwsEnvironmentVariables(AwsSdkHelper awsSdkHelper, KitLogger log) {
        String accessKeyId = awsSdkHelper.getAwsAccessKeyIdEnvVar();
        if (accessKeyId == null) {
            log.debug("System environment not set for variable AWS_ACCESS_KEY_ID, no AWS credentials found", new Object[0]);
            return null;
        }
        String secretAccessKey = awsSdkHelper.getAwsSecretAccessKeyEnvVar();
        if (secretAccessKey == null) {
            log.warn("System environment set for variable AWS_ACCESS_KEY_ID, but NOT for variable AWS_SECRET_ACCESS_KEY!", new Object[0]);
            return null;
        }
        return AuthConfig.builder().username(accessKeyId).password(secretAccessKey).email("none").auth(awsSdkHelper.getAwsSessionTokenEnvVar()).build();
    }

    private static Map<String, String> getAuthConfigMapToCheck(LookupMode lookupMode, Map<?, ?> authConfigMap) {
        String configMapKey = lookupMode.getConfigMapKey();
        if (configMapKey == null) {
            return authConfigMap;
        }
        if (authConfigMap != null) {
            return (Map)((Object)authConfigMap.get(configMapKey));
        }
        return null;
    }

    private static AuthConfig validateMandatoryOpenShiftLogin(AuthConfig openShiftAuthConfig, String useOpenAuthModeProp) {
        if (openShiftAuthConfig != null) {
            return openShiftAuthConfig;
        }
        String kubeConfigEnv = System.getenv("KUBECONFIG");
        throw new IllegalStateException(String.format("System property %s set, but not active user and/or token found in %s. Please use 'oc login' for connecting to OpenShift.", useOpenAuthModeProp, kubeConfigEnv != null ? kubeConfigEnv : "~/.kube/config"));
    }

    private static RegistryServerConfiguration checkForServer(RegistryServerConfiguration server, String id, String registry, String user) {
        String[] registries;
        String[] stringArray;
        if (registry != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = registry;
        } else {
            stringArray = DEFAULT_REGISTRIES;
        }
        for (String reg : registries = stringArray) {
            if (!id.equals(user == null ? reg : reg + "/" + user)) continue;
            return server;
        }
        return null;
    }

    private static AuthConfig createAuthConfigFromServer(RegistryServerConfiguration server, UnaryOperator<String> passwordDecryptionMethod) {
        return new AuthConfig(server.getUsername(), (String)passwordDecryptionMethod.apply(server.getPassword()), AuthConfigFactory.extractFromServerConfiguration(server.getConfiguration(), AUTH_EMAIL), AuthConfigFactory.extractFromServerConfiguration(server.getConfiguration(), "auth"));
    }

    private static String extractFromServerConfiguration(Map<String, Object> configuration, String prop) {
        if (configuration != null && configuration.containsKey(prop)) {
            return configuration.get(prop).toString();
        }
        return null;
    }

    private static LookupMode getLookupMode(boolean isPush) {
        return isPush ? LookupMode.PUSH : LookupMode.PULL;
    }

    protected static enum LookupMode {
        PUSH("jkube.docker.push.", "push"),
        PULL("jkube.docker.pull.", "pull"),
        DEFAULT("jkube.docker.", null);

        private final String sysPropPrefix;
        private final String configMapKey;

        private LookupMode(String sysPropPrefix, String configMapKey) {
            this.sysPropPrefix = sysPropPrefix;
            this.configMapKey = configMapKey;
        }

        public String asSysProperty(String prop) {
            return this.sysPropPrefix + prop;
        }

        public String getConfigMapKey() {
            return this.configMapKey;
        }
    }
}

