/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.api.util;

import com.fasterxml.jackson.core.type.TypeReference;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.util.KindFilenameMapperUtil;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.Serialization;
import org.eclipse.jkube.kit.config.resource.MappingConfig;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;

public class KubernetesResourceFragments {
    private static final Map<String, MappingConfig> FILENAME_TO_MAPPING_CONFIG_MAPPER = new HashMap<String, MappingConfig>();
    private static final Map<String, String> KIND_TO_FILENAME_MAPPER = new HashMap<String, String>();
    private static final Consumer<MappingConfig> KIND_FILENAME_MAPPER_UPDATER = mappingConfig -> {
        String[] fileNameTypes;
        if (!mappingConfig.isValid()) {
            throw new IllegalArgumentException(String.format("Invalid mapping for Kind %s and Filename Types %s", mappingConfig.getKind(), mappingConfig.getFilenameTypes()));
        }
        for (String filenameType : fileNameTypes = mappingConfig.getFilenamesAsArray()) {
            FILENAME_TO_MAPPING_CONFIG_MAPPER.put(filenameType.toLowerCase(), (MappingConfig)mappingConfig);
        }
        KIND_TO_FILENAME_MAPPER.put(mappingConfig.getKind(), fileNameTypes[fileNameTypes.length - 1]);
    };
    static final Set<String> EXCLUDED_RESOURCE_FILENAME_SUFFIXES = new HashSet<String>();

    private KubernetesResourceFragments() {
    }

    public static void updateKindFilenameMappings(List<MappingConfig> mappings) {
        if (mappings != null) {
            mappings.forEach(KIND_FILENAME_MAPPER_UPDATER);
        }
    }

    public static String getNameWithSuffix(String name, String kind) {
        String suffix = KIND_TO_FILENAME_MAPPER.get(kind);
        return String.format("%s-%s", name.replace(".", "_"), suffix != null ? suffix : "cr");
    }

    public static KubernetesListBuilder readResourceFragmentsFrom(File ... resourceFiles) throws IOException {
        KubernetesListBuilder builder = new KubernetesListBuilder();
        if (resourceFiles != null) {
            for (File file : resourceFiles) {
                if (!EXCLUDED_RESOURCE_FILENAME_SUFFIXES.stream().noneMatch(s -> file.getName().toLowerCase(Locale.ROOT).endsWith((String)s))) continue;
                builder.addToItems(new HasMetadata[]{KubernetesResourceFragments.getResource(file)});
            }
        }
        return builder;
    }

    private static HasMetadata getResource(File file) throws IOException {
        Map fragment = Optional.ofNullable(Serialization.unmarshal((File)file, (TypeReference)new TypeReference<Map<String, Object>>(){})).orElse(new HashMap());
        if (StringUtils.isBlank((CharSequence)((String)fragment.get("apiVersion"))) || StringUtils.isBlank((CharSequence)((String)fragment.get("kind"))) || StringUtils.isBlank((CharSequence)((String)KubernetesResourceFragments.getOrInitMetadata(fragment).get("name")))) {
            KubernetesResourceFragments.enrichFragment(fragment, file);
        }
        try {
            return (HasMetadata)Serialization.convertValue((Object)fragment, HasMetadata.class);
        }
        catch (ClassCastException exp) {
            throw new IllegalArgumentException(String.format("Resource fragment %s has an invalid syntax (%s)", file.getPath(), exp.getMessage()));
        }
    }

    private static void enrichFragment(Map<String, Object> fragment, File file) {
        Map<String, Object> metadata = KubernetesResourceFragments.getOrInitMetadata(fragment);
        Matcher matcher = KubernetesHelper.FILENAME_PATTERN.matcher(file.getName());
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Resource file name '%s' does not match pattern <name>-<type>.(yaml|yml|json)", file.getName()));
        }
        String nameFromFile = matcher.group("name");
        String typeFromFile = matcher.group("type");
        boolean nameFromFileIsKind = false;
        MappingConfig mcFromType = typeFromFile == null ? null : FILENAME_TO_MAPPING_CONFIG_MAPPER.get(typeFromFile.toLowerCase());
        MappingConfig mcFromName = FILENAME_TO_MAPPING_CONFIG_MAPPER.get(nameFromFile.toLowerCase());
        if (fragment.get("kind") == null) {
            if (mcFromType == null && mcFromName == null) {
                throw new IllegalArgumentException("No type given as part of the file name (e.g. 'app-rc.yml') and no 'kind' defined in resource descriptor " + file.getName() + ".\nMust be one of: " + StringUtils.join(FILENAME_TO_MAPPING_CONFIG_MAPPER.keySet().iterator(), (String)", "));
            }
            nameFromFileIsKind = mcFromType == null;
            fragment.put("kind", nameFromFileIsKind ? mcFromName.getKind() : mcFromType.getKind());
        }
        if (StringUtils.isNotBlank((CharSequence)nameFromFile) && !nameFromFileIsKind) {
            metadata.putIfAbsent("name", nameFromFile);
        }
        String apiVersion = mcFromName != null && mcFromName.getApiVersion() != null ? mcFromName.getApiVersion() : (mcFromType != null && mcFromType.getApiVersion() != null ? mcFromType.getApiVersion() : KubernetesResourceUtil.DEFAULT_RESOURCE_VERSIONING.getForKind((String)fragment.get("kind")));
        fragment.putIfAbsent("apiVersion", apiVersion);
    }

    private static Map<String, Object> getOrInitMetadata(Map<String, Object> fragment) {
        Object mo = fragment.get("metadata");
        if (mo == null) {
            HashMap<String, Object> meta = new HashMap<String, Object>();
            fragment.put("metadata", meta);
            return meta;
        }
        if (mo instanceof Map) {
            return (Map)mo;
        }
        throw new IllegalArgumentException("Metadata is expected to be a Map, not a " + mo.getClass());
    }

    static {
        EXCLUDED_RESOURCE_FILENAME_SUFFIXES.add(".helm.yaml");
        EXCLUDED_RESOURCE_FILENAME_SUFFIXES.add(".helm.yml");
        KindFilenameMapperUtil.loadMappings().entrySet().stream().map(mc -> MappingConfig.builder().kind((String)mc.getKey()).filenameTypes(String.join((CharSequence)",", (Iterable)mc.getValue())).build()).forEach(KIND_FILENAME_MAPPER_UPDATER);
    }
}

