/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff.cv;

import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.pecoff.cv.CVDebugInfo;
import com.oracle.objectfile.pecoff.cv.CVUtil;
import java.util.HashMap;
import java.util.Map;

abstract class CVSymbolSubrecord {
    private int subrecordStartPosition;
    private final short cmd;
    CVDebugInfo cvDebugInfo;

    CVSymbolSubrecord(CVDebugInfo cvDebugInfo, short cmd) {
        this.cvDebugInfo = cvDebugInfo;
        this.cmd = cmd;
    }

    final int computeFullContents(byte[] buffer, int initialPos) {
        this.subrecordStartPosition = initialPos;
        int pos = initialPos;
        pos += 2;
        pos = CVUtil.putShort(this.cmd, buffer, pos);
        pos = this.computeContents(buffer, pos);
        short length = (short)(pos - initialPos - 2);
        CVUtil.putShort(length, buffer, initialPos);
        return pos;
    }

    public String toString() {
        return String.format("CVSymbolSubrecord(pos=0x%06x cmd=0x%04x)", this.subrecordStartPosition, this.cmd);
    }

    public int getPos() {
        return this.subrecordStartPosition;
    }

    public int getCommand() {
        return this.cmd;
    }

    protected abstract int computeContents(byte[] var1, int var2);

    public static class CVSymbolEndRecord
    extends CVSymbolSubrecord {
        CVSymbolEndRecord(CVDebugInfo cvDebugInfo, short cmd) {
            super(cvDebugInfo, cmd);
        }

        CVSymbolEndRecord(CVDebugInfo cvDebugInfo) {
            this(cvDebugInfo, 6);
        }

        @Override
        protected int computeContents(byte[] buffer, int initialPos) {
            return initialPos;
        }

        @Override
        public String toString() {
            return "S_END";
        }
    }

    public static final class CVSymbolFrameProcRecord
    extends CVSymbolSubrecord {
        int framelen;
        int padLen;
        int padOffset;
        int saveRegsCount;
        int ehOffset;
        short ehSection;
        int flags;

        CVSymbolFrameProcRecord(CVDebugInfo cvDebugInfo, int framelen, int padLen, int padOffset, int saveRegsCount, int ehOffset, short ehSection, int flags) {
            super(cvDebugInfo, (short)4114);
            this.framelen = framelen;
            this.padLen = padLen;
            this.padOffset = padOffset;
            this.saveRegsCount = saveRegsCount;
            this.ehOffset = ehOffset;
            this.ehSection = ehSection;
            this.flags = flags;
        }

        CVSymbolFrameProcRecord(CVDebugInfo cvDebugInfo, int framelen, int flags) {
            this(cvDebugInfo, framelen, 0, 0, 0, 0, 0, flags);
        }

        @Override
        protected int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putInt(this.framelen, buffer, initialPos);
            pos = CVUtil.putInt(this.padLen, buffer, pos);
            pos = CVUtil.putInt(this.padOffset, buffer, pos);
            pos = CVUtil.putInt(this.saveRegsCount, buffer, pos);
            pos = CVUtil.putInt(this.ehOffset, buffer, pos);
            pos = CVUtil.putShort(this.ehSection, buffer, pos);
            pos = CVUtil.putInt(this.flags, buffer, pos);
            return pos;
        }

        @Override
        public String toString() {
            return String.format("S_FRAMEPROC len=0x%x padlen=0x%x paddOffset=0x%x regCount=%d flags=0x%x ", this.framelen, this.padLen, this.padOffset, this.saveRegsCount, this.flags);
        }
    }

    public static class CVSymbolGProc32Record
    extends CVSymbolSubrecord {
        int pparent;
        int pend;
        int pnext;
        int proclen;
        int debugStart;
        int debugEnd;
        int typeIndex;
        int offset;
        short segment;
        byte flags;
        String externalName;
        String debuggerName;

        CVSymbolGProc32Record(CVDebugInfo cvDebugInfo, short cmd, String externalName, String debuggerName, int pparent, int pend, int pnext, int proclen, int debugStart, int debugEnd, int typeIndex, int offset, short segment, byte flags) {
            super(cvDebugInfo, cmd);
            this.externalName = externalName;
            this.debuggerName = debuggerName;
            this.pparent = pparent;
            this.pend = pend;
            this.pnext = pnext;
            this.proclen = proclen;
            this.debugStart = debugStart;
            this.debugEnd = debugEnd;
            this.typeIndex = typeIndex;
            this.offset = offset;
            this.segment = segment;
            this.flags = flags;
        }

        CVSymbolGProc32Record(CVDebugInfo cvDebugInfo, String externalName, String debuggerName, int pparent, int pend, int pnext, int proclen, int debugStart, int debugEnd, int typeIndex, int offset, short segment, byte flags) {
            this(cvDebugInfo, 4368, externalName, debuggerName, pparent, pend, pnext, proclen, debugStart, debugEnd, typeIndex, offset, segment, flags);
        }

        @Override
        protected int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putInt(this.pparent, buffer, initialPos);
            pos = CVUtil.putInt(this.pend, buffer, pos);
            pos = CVUtil.putInt(this.pnext, buffer, pos);
            pos = CVUtil.putInt(this.proclen, buffer, pos);
            pos = CVUtil.putInt(this.debugStart, buffer, pos);
            pos = CVUtil.putInt(this.debugEnd, buffer, pos);
            pos = CVUtil.putInt(this.typeIndex, buffer, pos);
            if (buffer != null) {
                this.cvDebugInfo.getCVSymbolSection().markRelocationSite(pos, ObjectFile.RelocationKind.SECREL_4, this.externalName, false, 1L);
            }
            pos = CVUtil.putInt(0, buffer, pos);
            if (buffer != null) {
                this.cvDebugInfo.getCVSymbolSection().markRelocationSite(pos, ObjectFile.RelocationKind.SECTION_2, this.externalName, false, 1L);
            }
            pos = CVUtil.putShort((short)0, buffer, pos);
            pos = CVUtil.putByte(this.flags, buffer, pos);
            pos = CVUtil.putUTF8StringBytes(this.debuggerName, buffer, pos);
            return pos;
        }

        @Override
        public String toString() {
            return String.format("S_GPROC32   name=%s/%s parent=%d debugstart=0x%x debugend=0x%x len=0x%x offset=0x%x type=0x%x flags=0x%x)", this.debuggerName, this.externalName, this.pparent, this.debugStart, this.debugEnd, this.proclen, this.offset, this.typeIndex, this.flags);
        }
    }

    public static final class CVEnvBlockRecord
    extends CVSymbolSubrecord {
        private static final int ENVMAP_INITIAL_CAPACITY = 10;
        private Map<String, String> map = new HashMap<String, String>(10);

        CVEnvBlockRecord(CVDebugInfo cvDebugInfo) {
            super(cvDebugInfo, (short)4413);
            this.map.put("cwd", System.getProperty("user.dir"));
            String fn = CVEnvBlockRecord.findFirstFile(cvDebugInfo);
            if (fn != null) {
                this.map.put("src", fn);
            }
        }

        private static String findFirstFile(CVDebugInfo cvDebugInfo) {
            String fn = null;
            for (ClassEntry classEntry : cvDebugInfo.getPrimaryClasses()) {
                if (classEntry.getFileName() == null) continue;
                fn = classEntry.getFileEntry().getFileName();
                break;
            }
            return fn;
        }

        @Override
        protected int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putByte((byte)0, buffer, initialPos);
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                pos = CVUtil.putUTF8StringBytes(entry.getKey(), buffer, pos);
                pos = CVUtil.putUTF8StringBytes(entry.getValue(), buffer, pos);
            }
            pos = CVUtil.putUTF8StringBytes("", buffer, pos);
            return pos;
        }

        @Override
        public String toString() {
            return "S_ENVBLOCK " + this.map.size() + " entries";
        }
    }

    public static final class CVCompile3Record
    extends CVSymbolSubrecord {
        private static final byte HAS_DEBUG_FLAG = 0;
        private static final byte HAS_NO_DEBUG_FLAG = -128;
        private byte language = 0;
        private byte cf1 = 0;
        private byte cf2 = 0;
        private byte padding = 0;
        private short machine = (short)208;
        private short feMajor = (short)2;
        private short feMinor = (short)3;
        private short feBuild = (short)4;
        private short feQFE = (short)5;
        private short beMajor = (short)6;
        private short beMinor = (short)7;
        private short beBuild = (short)8;
        private short beQFE = (short)9;
        private String compiler = "graal";

        CVCompile3Record(CVDebugInfo cvDebugInfo) {
            super(cvDebugInfo, (short)4412);
        }

        @Override
        protected int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putByte(this.language, buffer, initialPos);
            pos = CVUtil.putByte(this.cf1, buffer, pos);
            pos = CVUtil.putByte(this.cf2, buffer, pos);
            pos = CVUtil.putByte(this.padding, buffer, pos);
            pos = CVUtil.putShort(this.machine, buffer, pos);
            pos = CVUtil.putShort(this.feMajor, buffer, pos);
            pos = CVUtil.putShort(this.feMinor, buffer, pos);
            pos = CVUtil.putShort(this.feBuild, buffer, pos);
            pos = CVUtil.putShort(this.feQFE, buffer, pos);
            pos = CVUtil.putShort(this.beMajor, buffer, pos);
            pos = CVUtil.putShort(this.beMinor, buffer, pos);
            pos = CVUtil.putShort(this.beBuild, buffer, pos);
            pos = CVUtil.putShort(this.beQFE, buffer, pos);
            pos = CVUtil.putUTF8StringBytes(this.compiler, buffer, pos);
            return pos;
        }

        @Override
        public String toString() {
            return String.format("S_COMPILE3 machine=%d fe=%d.%d.%d.%d be=%d.%d.%d%d compiler=%s", this.machine, this.feMajor, this.feMinor, this.feBuild, this.feQFE, this.beMajor, this.beMinor, this.beBuild, this.beQFE, this.compiler);
        }
    }

    public static final class CVObjectNameRecord
    extends CVSymbolSubrecord {
        String objName;

        CVObjectNameRecord(CVDebugInfo cvDebugInfo, String objName) {
            super(cvDebugInfo, (short)4353);
            this.objName = objName;
        }

        CVObjectNameRecord(CVDebugInfo cvDebugInfo) {
            this(cvDebugInfo, CVObjectNameRecord.findObjectName(cvDebugInfo));
        }

        private static String findObjectName(CVDebugInfo cvDebugInfo) {
            String fn = null;
            for (ClassEntry classEntry : cvDebugInfo.getPrimaryClasses()) {
                if (classEntry.getFileName() == null) continue;
                fn = classEntry.getFileEntry().getFileName();
                if (!fn.endsWith(".java")) break;
                fn = fn.substring(0, fn.lastIndexOf(".java")) + ".obj";
                break;
            }
            return fn;
        }

        boolean isValid() {
            return this.objName != null;
        }

        @Override
        protected int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putInt(0, buffer, initialPos);
            pos = CVUtil.putUTF8StringBytes(this.objName, buffer, pos);
            return pos;
        }

        @Override
        public String toString() {
            return "S_OBJNAME " + this.objName;
        }
    }
}

