/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.validation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.Config;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.dom.DOMVisitAfter;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXUtil;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;
import org.milyn.payload.FilterResult;
import org.milyn.resource.URIResourceLocator;
import org.milyn.rules.RuleEvalResult;
import org.milyn.rules.RuleProvider;
import org.milyn.rules.RuleProviderAccessor;
import org.milyn.util.FreeMarkerTemplate;
import org.milyn.validation.OnFail;
import org.milyn.validation.OnFailResult;
import org.milyn.validation.ValidationException;
import org.milyn.validation.ValidationResult;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@VisitBeforeReport(condition="false")
@VisitAfterReport(summary="Applied validation rule '${resource.parameters.name}'.")
public final class Validator
implements SAXVisitBefore,
SAXVisitAfter,
DOMVisitAfter {
    private static Log logger = LogFactory.getLog(Validator.class);
    private String compositRuleName;
    private String ruleProviderName;
    private String ruleName;
    private RuleProvider ruleProvider;
    private OnFail onFail = OnFail.ERROR;
    @AppContext
    private ApplicationContext appContext;
    @Config
    private SmooksResourceConfiguration config;
    private String targetAttribute;
    private String messageBundleBaseName;
    private int maxFails;

    public Validator() {
    }

    @Initialize
    public void initialize() {
        this.targetAttribute = this.config.getTargetAttribute();
    }

    public Validator(String compositRuleName, OnFail onFail) {
        this.setCompositRuleName(compositRuleName);
        this.onFail = onFail;
    }

    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException {
        if (this.targetAttribute == null) {
            element.accumulateText();
        }
    }

    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException {
        if (this.targetAttribute != null) {
            OnFailResultImpl result = this._validate(element.getAttribute(this.targetAttribute), executionContext);
            if (result != null) {
                result.setFailFragmentPath(SAXUtil.getXPath((SAXElement)element) + "/@" + this.targetAttribute);
                this.assertValidationException(result, executionContext);
            }
        } else {
            OnFailResultImpl result = this._validate(element.getTextContent(), executionContext);
            if (result != null) {
                result.setFailFragmentPath(SAXUtil.getXPath((SAXElement)element));
                this.assertValidationException(result, executionContext);
            }
        }
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        if (this.targetAttribute != null) {
            OnFailResultImpl result = this._validate(element.getAttribute(this.targetAttribute), executionContext);
            if (result != null) {
                result.setFailFragmentPath(DomUtils.getXPath((Node)element) + "/@" + this.targetAttribute);
                this.assertValidationException(result, executionContext);
            }
        } else {
            OnFailResultImpl result = this._validate(element.getTextContent(), executionContext);
            if (result != null) {
                result.setFailFragmentPath(DomUtils.getXPath((Node)element));
                this.assertValidationException(result, executionContext);
            }
        }
    }

    private void assertValidationException(OnFailResultImpl result, ExecutionContext executionContext) {
        if (this.onFail == OnFail.FATAL) {
            throw new ValidationException("A FATAL validation failure has occured " + result, result);
        }
        ValidationResult validationResult = this.getValidationResult(executionContext);
        if (validationResult != null && validationResult.getNumFailures() > this.maxFails) {
            throw new ValidationException("The maximum number of allowed validation failures (" + this.maxFails + ") has been exceeded.", result);
        }
    }

    void validate(String text, ExecutionContext executionContext) throws ValidationException {
        OnFailResultImpl result = this._validate(text, executionContext);
        if (result != null) {
            this.assertValidationException(result, executionContext);
        }
    }

    private OnFailResultImpl _validate(String text, ExecutionContext executionContext) throws ValidationException {
        if (this.ruleProvider == null) {
            this.setRuleProvider(executionContext);
        }
        RuleEvalResult result = this.ruleProvider.evaluate(this.ruleName, (CharSequence)text, executionContext);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)result);
        }
        if (!result.matched()) {
            ValidationResult validationResult = this.getValidationResult(executionContext);
            OnFailResultImpl onFailResult = new OnFailResultImpl();
            onFailResult.setRuleResult(result);
            onFailResult.setBeanContext(executionContext.getBeanContext().getBeanMap());
            validationResult.addResult(onFailResult, this.onFail);
            return onFailResult;
        }
        return null;
    }

    private ValidationResult getValidationResult(ExecutionContext executionContext) {
        ValidationResult validationResult = (ValidationResult)((Object)FilterResult.getResult((ExecutionContext)executionContext, ValidationResult.class));
        if (validationResult == null) {
            validationResult = new ValidationResult();
        }
        return validationResult;
    }

    private synchronized void setRuleProvider(ExecutionContext executionContext) {
        if (this.ruleProvider != null) {
            return;
        }
        this.ruleProvider = RuleProviderAccessor.get((ApplicationContext)this.appContext, (String)this.ruleProviderName);
        if (this.ruleProvider == null) {
            throw new SmooksException("Unknown rule provider '" + this.ruleProviderName + "'.");
        }
        this.setMessageBundleBaseName();
        String maxFailsConfig = executionContext.getConfigParameter("validation.maxFails");
        if (maxFailsConfig != null) {
            try {
                this.maxFails = Integer.parseInt(maxFailsConfig.trim());
            }
            catch (NumberFormatException e) {
                throw new SmooksConfigurationException("Invalid config value '" + maxFailsConfig.trim() + "' for global parameter '" + "validation.maxFails" + "'.  Must be a valid Integer value.");
            }
        } else {
            this.maxFails = Integer.MAX_VALUE;
        }
    }

    private void setMessageBundleBaseName() {
        String ruleSource = this.ruleProvider.getSrc();
        File srcFile = new File(ruleSource);
        String srcFileName = srcFile.getName();
        int indexOfExt = srcFileName.lastIndexOf(46);
        File parentFolder = srcFile.getParentFile();
        this.messageBundleBaseName = indexOfExt != -1 ? srcFileName.substring(0, indexOfExt) : ruleSource;
        this.messageBundleBaseName = parentFolder != null ? parentFolder.getPath() + "/i18n/" + this.messageBundleBaseName : "i18n/" + this.messageBundleBaseName;
        this.messageBundleBaseName = this.messageBundleBaseName.replace('\\', '/');
    }

    public String toString() {
        return String.format("%s [rule=%s, onFail=%s]", new Object[]{this.getClass().getSimpleName(), this.compositRuleName, this.onFail});
    }

    @ConfigParam(name="name")
    public void setCompositRuleName(String compositRuleName) {
        this.compositRuleName = compositRuleName;
        this.ruleProviderName = RuleProviderAccessor.parseRuleProviderName((String)compositRuleName);
        this.ruleName = RuleProviderAccessor.parseRuleName((String)compositRuleName);
    }

    public String getCompositRuleName() {
        return this.compositRuleName;
    }

    @ConfigParam(defaultVal="ERROR")
    public void setOnFail(OnFail onFail) {
        this.onFail = onFail;
    }

    public OnFail getOnFail() {
        return this.onFail;
    }

    public Validator setAppContext(ApplicationContext appContext) {
        this.appContext = appContext;
        return this;
    }

    private class ResourceBundleClassLoader
    extends ClassLoader {
        private ResourceBundleClassLoader() {
        }

        public InputStream getResourceAsStream(String name) {
            try {
                return new URIResourceLocator().getResource(name);
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OnFailResultImpl
    implements OnFailResult {
        private String failFragmentPath;
        private RuleEvalResult ruleResult;
        public Map<String, Object> beanContext;

        private OnFailResultImpl() {
        }

        public void setFailFragmentPath(String failFragmentPath) {
            this.failFragmentPath = failFragmentPath;
        }

        @Override
        public String getFailFragmentPath() {
            return this.failFragmentPath;
        }

        public void setRuleResult(RuleEvalResult ruleResult) {
            this.ruleResult = ruleResult;
        }

        @Override
        public RuleEvalResult getFailRuleResult() {
            return this.ruleResult;
        }

        public void setBeanContext(Map<String, Object> beanContext) {
            this.beanContext = new HashMap<String, Object>();
            this.beanContext.putAll(beanContext);
        }

        @Override
        public String getMessage() {
            return this.getMessage(Locale.getDefault());
        }

        @Override
        public String getMessage(Locale locale) {
            if (this.ruleResult.getEvalException() != null) {
                return this.ruleResult.getEvalException().getMessage();
            }
            String message = this.getMessage(locale, Validator.this.ruleName);
            if (message == null) {
                return this.toString();
            }
            if (message.startsWith("ftl:")) {
                FreeMarkerTemplate template = new FreeMarkerTemplate(message.substring("ftl:".length()));
                this.beanContext.put("ruleResult", this.ruleResult);
                this.beanContext.put("path", this.failFragmentPath);
                message = template.apply(this.beanContext);
            }
            return message;
        }

        private String getMessage(Locale locale, String messageName) {
            ResourceBundle bundle = this.getMessageBundle(locale);
            if (messageName == null || bundle == null) {
                return null;
            }
            return bundle.getString(messageName);
        }

        private ResourceBundle getMessageBundle(Locale locale) {
            try {
                return ResourceBundle.getBundle(Validator.this.messageBundleBaseName, locale, new ResourceBundleClassLoader());
            }
            catch (MissingResourceException e) {
                logger.warn((Object)("Failed to load Validation rule message bundle '" + Validator.this.messageBundleBaseName + "'.  This resource must be on the classpath!"), (Throwable)e);
                return null;
            }
        }

        public String toString() {
            return "[" + this.failFragmentPath + "] " + this.ruleResult.toString();
        }
    }
}

