/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.config;

import java.net.URI;
import org.neo4j.ogm.authentication.Credentials;
import org.neo4j.ogm.authentication.UsernamePasswordCredentials;
import org.neo4j.ogm.config.Configuration;

public class DriverConfiguration {
    public static final String[] DRIVER = new String[]{"neo4j.ogm.driver", "spring.data.neo4j.driver", "driver"};
    public static final String[] CREDENTIALS = new String[]{"neo4j.ogm.credentials", "spring.data.neo4j.credentials", "credentials"};
    public static final String[] URI = new String[]{"neo4j.ogm.URI", "spring.data.neo4j.URI", "URI"};
    public static final String[] USERNAME = new String[]{"neo4j.ogm.username", "spring.data.neo4j.username", "username"};
    public static final String[] PASSWORD = new String[]{"neo4j.ogm.password", "spring.data.neo4j.password", "password"};
    public static final String[] CONNECTION_POOL_SIZE = new String[]{"connection.pool.size"};
    public static final String[] CONNECTION_LIVELINESS_CHECK_TIMEOUT = new String[]{"connection.liveliness.check.timeout"};
    public static final String[] ENCRYPTION_LEVEL = new String[]{"encryption.level"};
    public static final String[] TRUST_STRATEGY = new String[]{"trust.strategy"};
    public static final String[] TRUST_CERT_FILE = new String[]{"trust.certificate.file"};
    public static final String[] NEO4J_HA_PROPERTIES_FILE = new String[]{"neo4j.ha.properties.file"};
    private static final int CONNECTION_POOL_SIZE_DEFAULT = 50;
    private final Configuration configuration;

    public DriverConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public DriverConfiguration setDriverClassName(String driverClassName) {
        this.configuration.set(DRIVER[0], driverClassName);
        return this;
    }

    public DriverConfiguration setURI(String uri) {
        this.configuration.set(URI[0], uri);
        try {
            URI url = new URI(uri);
            String userInfo = url.getUserInfo();
            if (userInfo != null) {
                String[] userPass = userInfo.split(":");
                this.setCredentials(userPass[0], userPass[1]);
                this.configuration.set(URI[0], this.removePasswordFromUri(uri));
            }
            if (this.configuration.driverConfiguration().getDriverClassName() == null) {
                this.determineDefaultDriverName(url);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    private String removePasswordFromUri(String uri) {
        return uri.replaceFirst("[^/^:]+:[^:^@^/]+@", "");
    }

    public DriverConfiguration setCredentials(Credentials credentials) {
        this.configuration.set(CREDENTIALS[0], credentials);
        return this;
    }

    public DriverConfiguration setCredentials(String username, String password) {
        this.configuration.set(CREDENTIALS[0], new UsernamePasswordCredentials(username, password));
        return this;
    }

    public DriverConfiguration setConnectionPoolSize(Integer sessionPoolSize) {
        this.configuration.set(CONNECTION_POOL_SIZE[0], sessionPoolSize.toString());
        return this;
    }

    public DriverConfiguration setConnectionLivenessCheckTimeout(Integer timeoutInMs) {
        this.configuration.set(CONNECTION_LIVELINESS_CHECK_TIMEOUT[0], timeoutInMs.toString());
        return this;
    }

    public DriverConfiguration setEncryptionLevel(String encryptionLevel) {
        this.configuration.set(ENCRYPTION_LEVEL[0], encryptionLevel);
        return this;
    }

    public DriverConfiguration setTrustStrategy(String trustStrategy) {
        this.configuration.set(TRUST_STRATEGY[0], trustStrategy);
        return this;
    }

    public DriverConfiguration setTrustCertFile(String trustCertFile) {
        this.configuration.set(TRUST_CERT_FILE[0], trustCertFile);
        return this;
    }

    public Credentials getCredentials() {
        if (this.configuration.get(CREDENTIALS) == null) {
            this.setURI((String)this.configuration.get(URI));
        }
        if (this.configuration.get(CREDENTIALS) == null) {
            String username = (String)this.configuration.get(USERNAME);
            String password = (String)this.configuration.get(PASSWORD);
            if (username != null && password != null) {
                this.setCredentials(username, password);
            }
        }
        return (Credentials)this.configuration.get(CREDENTIALS);
    }

    public String getURI() {
        return (String)this.configuration.get(URI);
    }

    public String getDriverClassName() {
        return (String)this.configuration.get(DRIVER);
    }

    public Integer getConnectionPoolSize() {
        if (this.configuration.get(CONNECTION_POOL_SIZE) != null) {
            return Integer.valueOf((String)this.configuration.get(CONNECTION_POOL_SIZE));
        }
        return 50;
    }

    public Integer getConnectionLivenessCheckTimeout() {
        if (this.configuration.get(CONNECTION_LIVELINESS_CHECK_TIMEOUT) != null) {
            return Integer.valueOf((String)this.configuration.get(CONNECTION_LIVELINESS_CHECK_TIMEOUT));
        }
        return null;
    }

    public String getEncryptionLevel() {
        if (this.configuration.get(ENCRYPTION_LEVEL) != null) {
            return (String)this.configuration.get(ENCRYPTION_LEVEL);
        }
        return null;
    }

    public String getTrustStrategy() {
        if (this.configuration.get(TRUST_STRATEGY) != null) {
            return (String)this.configuration.get(TRUST_STRATEGY);
        }
        return null;
    }

    public String getTrustCertFile() {
        if (this.configuration.get(TRUST_CERT_FILE) != null) {
            return (String)this.configuration.get(TRUST_CERT_FILE);
        }
        return null;
    }

    public String getNeo4jHaPropertiesFile() {
        if (this.configuration.get(NEO4J_HA_PROPERTIES_FILE) != null) {
            return (String)this.configuration.get(NEO4J_HA_PROPERTIES_FILE);
        }
        return null;
    }

    private void determineDefaultDriverName(URI uri) {
        switch (uri.getScheme()) {
            case "http": 
            case "https": {
                this.setDriverClassName("org.neo4j.ogm.drivers.http.driver.HttpDriver");
                break;
            }
            case "bolt": {
                this.setDriverClassName("org.neo4j.ogm.drivers.bolt.driver.BoltDriver");
                break;
            }
            default: {
                this.setDriverClassName("org.neo4j.ogm.drivers.embedded.driver.EmbeddedDriver");
            }
        }
    }
}

