/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow.websocket;

import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.boot.undertow.websocket._CallbackImpl;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.socketd.ProtocolManager;
import org.noear.solon.socketd.SessionBase;

public class _SocketServerSession
extends SessionBase {
    public static final Map<WebSocketChannel, Session> sessions = new HashMap<WebSocketChannel, Session>();
    private final WebSocketChannel real;
    private final String _sessionId = Utils.guid();
    private URI _uri;
    private String _path;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session get(WebSocketChannel real) {
        Object tmp = sessions.get(real);
        if (tmp == null) {
            WebSocketChannel webSocketChannel = real;
            synchronized (webSocketChannel) {
                tmp = sessions.get(real);
                if (tmp == null) {
                    tmp = new _SocketServerSession(real);
                    sessions.put(real, (Session)tmp);
                }
            }
        }
        return tmp;
    }

    public static void remove(WebSocketChannel real) {
        sessions.remove(real);
    }

    public _SocketServerSession(WebSocketChannel real) {
        this.real = real;
    }

    public Object real() {
        return this.real;
    }

    public String sessionId() {
        return this._sessionId;
    }

    public MethodType method() {
        return MethodType.WEBSOCKET;
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.real.getUrl());
        }
        return this._uri;
    }

    public String path() {
        if (this._path == null) {
            this._path = this.uri().getPath();
        }
        return this._path;
    }

    public void sendAsync(String message) {
        if (Solon.app().enableWebSocketD()) {
            ByteBuffer buf = ProtocolManager.encode((Message)Message.wrap((String)message));
            WebSockets.sendBinary((ByteBuffer)buf, (WebSocketChannel)this.real, _CallbackImpl.instance);
        } else {
            WebSockets.sendText((String)message, (WebSocketChannel)this.real, _CallbackImpl.instance);
        }
    }

    public void sendAsync(Message message) {
        super.send(message);
        if (Solon.app().enableWebSocketD()) {
            ByteBuffer buf = ProtocolManager.encode((Message)message);
            WebSockets.sendBinary((ByteBuffer)buf, (WebSocketChannel)this.real, _CallbackImpl.instance);
        } else if (message.isString()) {
            WebSockets.sendText((String)message.bodyAsString(), (WebSocketChannel)this.real, _CallbackImpl.instance);
        } else {
            ByteBuffer buf = ByteBuffer.wrap(message.body());
            WebSockets.sendBinary((ByteBuffer)buf, (WebSocketChannel)this.real, _CallbackImpl.instance);
        }
    }

    public void send(String message) {
        try {
            if (Solon.app().enableWebSocketD()) {
                ByteBuffer buf = ProtocolManager.encode((Message)Message.wrap((String)message));
                WebSockets.sendBinaryBlocking((ByteBuffer)buf, (WebSocketChannel)this.real);
            } else {
                WebSockets.sendTextBlocking((String)message, (WebSocketChannel)this.real);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void send(Message message) {
        super.send(message);
        try {
            if (Solon.app().enableWebSocketD()) {
                ByteBuffer buf = ProtocolManager.encode((Message)message);
                WebSockets.sendBinaryBlocking((ByteBuffer)buf, (WebSocketChannel)this.real);
            } else if (message.isString()) {
                WebSockets.sendTextBlocking((String)message.bodyAsString(), (WebSocketChannel)this.real);
            } else {
                ByteBuffer buf = ByteBuffer.wrap(message.body());
                WebSockets.sendBinaryBlocking((ByteBuffer)buf, (WebSocketChannel)this.real);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
        if (this.real == null) {
            return;
        }
        this.real.close();
        sessions.remove(this.real);
    }

    public boolean isValid() {
        if (this.real == null) {
            return false;
        }
        return this.real.isOpen();
    }

    public boolean isSecure() {
        return this.real.isSecure();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.real.getSourceAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return this.real.getDestinationAddress();
    }

    public void setAttachment(Object obj) {
        this.real.setAttribute("attachment", obj);
    }

    public <T> T getAttachment() {
        return (T)this.real.getAttribute("attachment");
    }

    public Collection<Session> getOpenSessions() {
        return Collections.unmodifiableCollection(sessions.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        _SocketServerSession that = (_SocketServerSession)((Object)o);
        return Objects.equals(this.real, that.real);
    }

    public int hashCode() {
        return Objects.hash(this.real);
    }
}

