/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class BoolQuery
extends QueryBase
implements QueryVariant {
    private final List<Query> filter;
    @Nullable
    private final String minimumShouldMatch;
    private final List<Query> must;
    private final List<Query> mustNot;
    private final List<Query> should;
    public static final JsonpDeserializer<BoolQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BoolQuery::setupBoolQueryDeserializer);

    private BoolQuery(Builder builder) {
        super(builder);
        this.filter = ApiTypeHelper.unmodifiable(builder.filter);
        this.minimumShouldMatch = builder.minimumShouldMatch;
        this.must = ApiTypeHelper.unmodifiable(builder.must);
        this.mustNot = ApiTypeHelper.unmodifiable(builder.mustNot);
        this.should = ApiTypeHelper.unmodifiable(builder.should);
    }

    public static BoolQuery of(Function<Builder, ObjectBuilder<BoolQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Bool;
    }

    public final List<Query> filter() {
        return this.filter;
    }

    @Nullable
    public final String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public final List<Query> must() {
        return this.must;
    }

    public final List<Query> mustNot() {
        return this.mustNot;
    }

    public final List<Query> should() {
        return this.should;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.filter)) {
            generator.writeKey("filter");
            generator.writeStartArray();
            for (Query item0 : this.filter) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.minimumShouldMatch != null) {
            generator.writeKey("minimum_should_match");
            generator.write(this.minimumShouldMatch);
        }
        if (ApiTypeHelper.isDefined(this.must)) {
            generator.writeKey("must");
            generator.writeStartArray();
            for (Query item0 : this.must) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.mustNot)) {
            generator.writeKey("must_not");
            generator.writeStartArray();
            for (Query item0 : this.mustNot) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.should)) {
            generator.writeKey("should");
            generator.writeStartArray();
            for (Query item0 : this.should) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public Builder toBuilder() {
        return new Builder().filter(this.filter).minimumShouldMatch(this.minimumShouldMatch).must(this.must).mustNot(this.mustNot).should(this.should);
    }

    protected static void setupBoolQueryDeserializer(ObjectDeserializer<Builder> op) {
        BoolQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::filter, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "filter");
        op.add(Builder::minimumShouldMatch, JsonpDeserializer.stringDeserializer(), "minimum_should_match");
        op.add(Builder::must, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "must");
        op.add(Builder::mustNot, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "must_not");
        op.add(Builder::should, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "should");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<BoolQuery> {
        @Nullable
        private List<Query> filter;
        @Nullable
        private String minimumShouldMatch;
        @Nullable
        private List<Query> must;
        @Nullable
        private List<Query> mustNot;
        @Nullable
        private List<Query> should;

        public final Builder filter(List<Query> list) {
            this.filter = Builder._listAddAll(this.filter, list);
            return this;
        }

        public final Builder filter(Query value, Query ... values) {
            this.filter = Builder._listAdd(this.filter, value, values);
            return this;
        }

        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build(), new Query[0]);
        }

        public final Builder minimumShouldMatch(@Nullable String value) {
            this.minimumShouldMatch = value;
            return this;
        }

        public final Builder must(List<Query> list) {
            this.must = Builder._listAddAll(this.must, list);
            return this;
        }

        public final Builder must(Query value, Query ... values) {
            this.must = Builder._listAdd(this.must, value, values);
            return this;
        }

        public final Builder must(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.must(fn.apply(new Query.Builder()).build(), new Query[0]);
        }

        public final Builder mustNot(List<Query> list) {
            this.mustNot = Builder._listAddAll(this.mustNot, list);
            return this;
        }

        public final Builder mustNot(Query value, Query ... values) {
            this.mustNot = Builder._listAdd(this.mustNot, value, values);
            return this;
        }

        public final Builder mustNot(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.mustNot(fn.apply(new Query.Builder()).build(), new Query[0]);
        }

        public final Builder should(List<Query> list) {
            this.should = Builder._listAddAll(this.should, list);
            return this;
        }

        public final Builder should(Query value, Query ... values) {
            this.should = Builder._listAdd(this.should, value, values);
            return this;
        }

        public final Builder should(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.should(fn.apply(new Query.Builder()).build(), new Query[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BoolQuery build() {
            this._checkSingleUse();
            return new BoolQuery(this);
        }
    }
}

