/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import org.assertj.core.api.AssertProvider;
import org.springframework.boot.test.json.ObjectContentAssert;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

public final class ObjectContent<T>
implements AssertProvider<ObjectContentAssert<T>> {
    private final ResolvableType type;
    private final T object;

    public ObjectContent(ResolvableType type, T object) {
        Assert.notNull(object, (String)"'object' must not be null");
        this.type = type;
        this.object = object;
    }

    public ObjectContentAssert<T> assertThat() {
        return new ObjectContentAssert<T>(this.object);
    }

    public T getObject() {
        return this.object;
    }

    public String toString() {
        String createdFrom = this.type != null ? " created from " + String.valueOf(this.type) : "";
        return "ObjectContent " + String.valueOf(this.object) + createdFrom;
    }
}

