/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.tomcat.autoconfigure;

import java.time.Duration;
import java.util.List;
import java.util.function.ObjIntConsumer;
import java.util.stream.Collectors;
import org.apache.catalina.Valve;
import org.apache.catalina.core.AprLifecycleListener;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.catalina.valves.ErrorReportValve;
import org.apache.catalina.valves.RemoteIpValve;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.coyote.http2.Http2Protocol;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.tomcat.ConfigurableTomcatWebServerFactory;
import org.springframework.boot.tomcat.autoconfigure.TomcatServerProperties;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.unit.DataSize;

public class TomcatWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableTomcatWebServerFactory>,
Ordered {
    static final int ORDER = 0;
    private final Environment environment;
    private final ServerProperties serverProperties;
    private final TomcatServerProperties tomcatProperties;
    private final WebProperties webProperties;

    public TomcatWebServerFactoryCustomizer(Environment environment, ServerProperties serverProperties, TomcatServerProperties tomcatProperties, WebProperties webProperties) {
        this.environment = environment;
        this.serverProperties = serverProperties;
        this.tomcatProperties = tomcatProperties;
        this.webProperties = webProperties;
    }

    public int getOrder() {
        return 0;
    }

    public void customize(ConfigurableTomcatWebServerFactory factory) {
        PropertyMapper map = PropertyMapper.get();
        map.from(this.tomcatProperties::getBasedir).to(factory::setBaseDirectory);
        map.from(this.tomcatProperties::getBackgroundProcessorDelay).as(Duration::getSeconds).as(Long::intValue).to(factory::setBackgroundProcessorDelay);
        this.customizeRemoteIpValve(factory);
        TomcatServerProperties.Threads threadProperties = this.tomcatProperties.getThreads();
        map.from(threadProperties::getMax).when(this::isPositive).to(maxThreads -> this.customizeMaxThreads(factory, (int)maxThreads));
        map.from(threadProperties::getMinSpare).when(this::isPositive).to(minSpareThreads -> this.customizeMinThreads(factory, (int)minSpareThreads));
        map.from(threadProperties::getMaxQueueCapacity).when(this::isPositive).to(maxQueueCapacity -> this.customizeMaxQueueCapacity(factory, (int)maxQueueCapacity));
        map.from((Object)this.serverProperties.getMaxHttpRequestHeaderSize()).asInt(DataSize::toBytes).when(this::isPositive).to(maxHttpRequestHeaderSize -> this.customizeMaxHttpRequestHeaderSize(factory, (int)maxHttpRequestHeaderSize));
        map.from(this.tomcatProperties::getMaxHttpResponseHeaderSize).asInt(DataSize::toBytes).when(this::isPositive).to(maxHttpResponseHeaderSize -> this.customizeMaxHttpResponseHeaderSize(factory, (int)maxHttpResponseHeaderSize));
        map.from(this.tomcatProperties::getMaxSwallowSize).asInt(DataSize::toBytes).to(maxSwallowSize -> this.customizeMaxSwallowSize(factory, (int)maxSwallowSize));
        map.from(this.tomcatProperties::getMaxHttpFormPostSize).asInt(DataSize::toBytes).when(maxHttpFormPostSize -> maxHttpFormPostSize != 0).to(maxHttpFormPostSize -> this.customizeMaxHttpFormPostSize(factory, (int)maxHttpFormPostSize));
        map.from(this.tomcatProperties::getMaxParameterCount).to(maxParameterCount -> this.customizeMaxParameterCount(factory, (int)maxParameterCount));
        map.from(this.tomcatProperties::getMaxPartHeaderSize).asInt(DataSize::toBytes).to(maxPartHeaderSize -> this.customizeMaxPartHeaderSize(factory, (int)maxPartHeaderSize));
        map.from(this.tomcatProperties::getMaxPartCount).to(maxPartCount -> this.customizeMaxPartCount(factory, (int)maxPartCount));
        map.from(this.tomcatProperties::getAccesslog).when(TomcatServerProperties.Accesslog::isEnabled).to(enabled -> this.customizeAccessLog(factory));
        map.from(this.tomcatProperties::getUriEncoding).to(factory::setUriEncoding);
        map.from(this.tomcatProperties::getConnectionTimeout).to(connectionTimeout -> this.customizeConnectionTimeout(factory, (Duration)connectionTimeout));
        map.from(this.tomcatProperties::getMaxConnections).when(this::isPositive).to(maxConnections -> this.customizeMaxConnections(factory, (int)maxConnections));
        map.from(this.tomcatProperties::getAcceptCount).when(this::isPositive).to(acceptCount -> this.customizeAcceptCount(factory, (int)acceptCount));
        map.from(this.tomcatProperties::getProcessorCache).to(processorCache -> this.customizeProcessorCache(factory, (int)processorCache));
        map.from(this.tomcatProperties::getKeepAliveTimeout).to(keepAliveTimeout -> this.customizeKeepAliveTimeout(factory, (Duration)keepAliveTimeout));
        map.from(this.tomcatProperties::getMaxKeepAliveRequests).to(maxKeepAliveRequests -> this.customizeMaxKeepAliveRequests(factory, (int)maxKeepAliveRequests));
        map.from(this.tomcatProperties::getRelaxedPathChars).as(this::joinCharacters).whenHasText().to(relaxedChars -> this.customizeRelaxedPathChars(factory, (String)relaxedChars));
        map.from(this.tomcatProperties::getRelaxedQueryChars).as(this::joinCharacters).whenHasText().to(relaxedChars -> this.customizeRelaxedQueryChars(factory, (String)relaxedChars));
        map.from(this.tomcatProperties.getMbeanregistry()::isEnabled).as(enable -> enable == false).to(factory::setDisableMBeanRegistry);
        this.customizeStaticResources(factory);
        this.customizeErrorReportValve(this.webProperties.getError(), factory);
        factory.setUseApr(this.getUseApr(this.tomcatProperties.getUseApr()));
    }

    private boolean getUseApr(TomcatServerProperties.UseApr useApr) {
        return switch (useApr) {
            default -> throw new IncompatibleClassChangeError();
            case TomcatServerProperties.UseApr.ALWAYS -> {
                Assert.state((boolean)this.isAprAvailable(), (String)"APR has been configured to 'ALWAYS', but it's not available");
                yield true;
            }
            case TomcatServerProperties.UseApr.WHEN_AVAILABLE -> this.isAprAvailable();
            case TomcatServerProperties.UseApr.NEVER -> false;
        };
    }

    private boolean isAprAvailable() {
        new AprLifecycleListener();
        return AprLifecycleListener.isAprAvailable();
    }

    private boolean isPositive(int value) {
        return value > 0;
    }

    private void customizeMaxThreads(ConfigurableTomcatWebServerFactory factory, int maxThreads) {
        this.customizeHandler(factory, maxThreads, AbstractProtocol.class, AbstractProtocol::setMaxThreads);
    }

    private void customizeMinThreads(ConfigurableTomcatWebServerFactory factory, int minSpareThreads) {
        this.customizeHandler(factory, minSpareThreads, AbstractProtocol.class, AbstractProtocol::setMinSpareThreads);
    }

    private void customizeMaxQueueCapacity(ConfigurableTomcatWebServerFactory factory, int maxQueueCapacity) {
        this.customizeHandler(factory, maxQueueCapacity, AbstractProtocol.class, AbstractProtocol::setMaxQueueSize);
    }

    private void customizeAcceptCount(ConfigurableTomcatWebServerFactory factory, int acceptCount) {
        this.customizeHandler(factory, acceptCount, AbstractProtocol.class, AbstractProtocol::setAcceptCount);
    }

    private void customizeProcessorCache(ConfigurableTomcatWebServerFactory factory, int processorCache) {
        this.customizeHandler(factory, processorCache, AbstractProtocol.class, AbstractProtocol::setProcessorCache);
    }

    private void customizeKeepAliveTimeout(ConfigurableTomcatWebServerFactory factory, Duration keepAliveTimeout) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            for (UpgradeProtocol upgradeProtocol : handler.findUpgradeProtocols()) {
                if (!(upgradeProtocol instanceof Http2Protocol)) continue;
                Http2Protocol protocol = (Http2Protocol)upgradeProtocol;
                protocol.setKeepAliveTimeout(keepAliveTimeout.toMillis());
            }
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setKeepAliveTimeout((int)keepAliveTimeout.toMillis());
            }
        });
    }

    private void customizeMaxKeepAliveRequests(ConfigurableTomcatWebServerFactory factory, int maxKeepAliveRequests) {
        this.customizeHandler(factory, maxKeepAliveRequests, AbstractHttp11Protocol.class, AbstractHttp11Protocol::setMaxKeepAliveRequests);
    }

    private void customizeMaxConnections(ConfigurableTomcatWebServerFactory factory, int maxConnections) {
        this.customizeHandler(factory, maxConnections, AbstractProtocol.class, AbstractProtocol::setMaxConnections);
    }

    private void customizeConnectionTimeout(ConfigurableTomcatWebServerFactory factory, Duration connectionTimeout) {
        this.customizeHandler(factory, (int)connectionTimeout.toMillis(), AbstractProtocol.class, AbstractProtocol::setConnectionTimeout);
    }

    private void customizeRelaxedPathChars(ConfigurableTomcatWebServerFactory factory, String relaxedChars) {
        factory.addConnectorCustomizers(connector -> connector.setProperty("relaxedPathChars", relaxedChars));
    }

    private void customizeRelaxedQueryChars(ConfigurableTomcatWebServerFactory factory, String relaxedChars) {
        factory.addConnectorCustomizers(connector -> connector.setProperty("relaxedQueryChars", relaxedChars));
    }

    private String joinCharacters(List<Character> content) {
        return content.stream().map(String::valueOf).collect(Collectors.joining());
    }

    private void customizeRemoteIpValve(ConfigurableTomcatWebServerFactory factory) {
        TomcatServerProperties.Remoteip remoteIpProperties = this.tomcatProperties.getRemoteip();
        String protocolHeader = remoteIpProperties.getProtocolHeader();
        String remoteIpHeader = remoteIpProperties.getRemoteIpHeader();
        if (StringUtils.hasText((String)protocolHeader) || StringUtils.hasText((String)remoteIpHeader) || this.getOrDeduceUseForwardHeaders()) {
            RemoteIpValve valve = new RemoteIpValve();
            valve.setProtocolHeader(StringUtils.hasLength((String)protocolHeader) ? protocolHeader : "X-Forwarded-Proto");
            if (StringUtils.hasLength((String)remoteIpHeader)) {
                valve.setRemoteIpHeader(remoteIpHeader);
            }
            valve.setTrustedProxies(remoteIpProperties.getTrustedProxies());
            valve.setInternalProxies(remoteIpProperties.getInternalProxies());
            try {
                valve.setHostHeader(remoteIpProperties.getHostHeader());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            valve.setPortHeader(remoteIpProperties.getPortHeader());
            valve.setProtocolHeaderHttpsValue(remoteIpProperties.getProtocolHeaderHttpsValue());
            factory.addEngineValves(new Valve[]{valve});
        }
    }

    private boolean getOrDeduceUseForwardHeaders() {
        if (this.serverProperties.getForwardHeadersStrategy() == null) {
            CloudPlatform platform = CloudPlatform.getActive((Environment)this.environment);
            return platform != null && platform.isUsingForwardHeaders();
        }
        return this.serverProperties.getForwardHeadersStrategy() == ServerProperties.ForwardHeadersStrategy.NATIVE;
    }

    private void customizeMaxHttpRequestHeaderSize(ConfigurableTomcatWebServerFactory factory, int maxHttpRequestHeaderSize) {
        this.customizeHandler(factory, maxHttpRequestHeaderSize, AbstractHttp11Protocol.class, AbstractHttp11Protocol::setMaxHttpRequestHeaderSize);
    }

    private void customizeMaxHttpResponseHeaderSize(ConfigurableTomcatWebServerFactory factory, int maxHttpResponseHeaderSize) {
        this.customizeHandler(factory, maxHttpResponseHeaderSize, AbstractHttp11Protocol.class, AbstractHttp11Protocol::setMaxHttpResponseHeaderSize);
    }

    private void customizeMaxSwallowSize(ConfigurableTomcatWebServerFactory factory, int maxSwallowSize) {
        this.customizeHandler(factory, maxSwallowSize, AbstractHttp11Protocol.class, AbstractHttp11Protocol::setMaxSwallowSize);
    }

    private <T extends ProtocolHandler> void customizeHandler(ConfigurableTomcatWebServerFactory factory, int value, Class<T> type, ObjIntConsumer<T> consumer) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (type.isAssignableFrom(handler.getClass())) {
                consumer.accept((ProtocolHandler)type.cast(handler), value);
            }
        });
    }

    private void customizeMaxHttpFormPostSize(ConfigurableTomcatWebServerFactory factory, int maxHttpFormPostSize) {
        factory.addConnectorCustomizers(connector -> connector.setMaxPostSize(maxHttpFormPostSize));
    }

    private void customizeMaxParameterCount(ConfigurableTomcatWebServerFactory factory, int maxParameterCount) {
        factory.addConnectorCustomizers(connector -> connector.setMaxParameterCount(maxParameterCount));
    }

    private void customizeMaxPartCount(ConfigurableTomcatWebServerFactory factory, int maxPartCount) {
        factory.addConnectorCustomizers(connector -> {
            try {
                connector.setMaxPartCount(maxPartCount);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        });
    }

    private void customizeMaxPartHeaderSize(ConfigurableTomcatWebServerFactory factory, int maxPartHeaderSize) {
        factory.addConnectorCustomizers(connector -> {
            try {
                connector.setMaxPartHeaderSize(maxPartHeaderSize);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        });
    }

    private void customizeAccessLog(ConfigurableTomcatWebServerFactory factory) {
        AccessLogValve valve = new AccessLogValve();
        PropertyMapper map = PropertyMapper.get();
        TomcatServerProperties.Accesslog accessLogConfig = this.tomcatProperties.getAccesslog();
        map.from((Object)accessLogConfig.getConditionIf()).to(arg_0 -> ((AccessLogValve)valve).setConditionIf(arg_0));
        map.from((Object)accessLogConfig.getConditionUnless()).to(arg_0 -> ((AccessLogValve)valve).setConditionUnless(arg_0));
        map.from((Object)accessLogConfig.getPattern()).to(arg_0 -> ((AccessLogValve)valve).setPattern(arg_0));
        map.from((Object)accessLogConfig.getDirectory()).to(arg_0 -> ((AccessLogValve)valve).setDirectory(arg_0));
        map.from((Object)accessLogConfig.getPrefix()).to(arg_0 -> ((AccessLogValve)valve).setPrefix(arg_0));
        map.from((Object)accessLogConfig.getSuffix()).to(arg_0 -> ((AccessLogValve)valve).setSuffix(arg_0));
        map.from((Object)accessLogConfig.getEncoding()).whenHasText().to(arg_0 -> ((AccessLogValve)valve).setEncoding(arg_0));
        map.from((Object)accessLogConfig.getLocale()).whenHasText().to(arg_0 -> ((AccessLogValve)valve).setLocale(arg_0));
        map.from((Object)accessLogConfig.isCheckExists()).to(arg_0 -> ((AccessLogValve)valve).setCheckExists(arg_0));
        map.from((Object)accessLogConfig.isRotate()).to(arg_0 -> ((AccessLogValve)valve).setRotatable(arg_0));
        map.from((Object)accessLogConfig.isRenameOnRotate()).to(arg_0 -> ((AccessLogValve)valve).setRenameOnRotate(arg_0));
        map.from((Object)accessLogConfig.getMaxDays()).to(arg_0 -> ((AccessLogValve)valve).setMaxDays(arg_0));
        map.from((Object)accessLogConfig.getFileDateFormat()).to(arg_0 -> ((AccessLogValve)valve).setFileDateFormat(arg_0));
        map.from((Object)accessLogConfig.isIpv6Canonical()).to(arg_0 -> ((AccessLogValve)valve).setIpv6Canonical(arg_0));
        map.from((Object)accessLogConfig.isRequestAttributesEnabled()).to(arg_0 -> ((AccessLogValve)valve).setRequestAttributesEnabled(arg_0));
        map.from((Object)accessLogConfig.isBuffered()).to(arg_0 -> ((AccessLogValve)valve).setBuffered(arg_0));
        factory.addEngineValves(new Valve[]{valve});
    }

    private void customizeStaticResources(ConfigurableTomcatWebServerFactory factory) {
        TomcatServerProperties.Resource resource = this.tomcatProperties.getResource();
        factory.addContextCustomizers(context -> context.addLifecycleListener(event -> {
            if (event.getType().equals("configure_start")) {
                context.getResources().setCachingAllowed(resource.isAllowCaching());
                context.getResources().setCacheMaxSize(resource.getCacheMaxSize().toKilobytes());
                context.getResources().setCacheTtl(resource.getCacheTtl().toMillis());
            }
        }));
    }

    private void customizeErrorReportValve(ErrorProperties error, ConfigurableTomcatWebServerFactory factory) {
        if (error.getIncludeStacktrace() == ErrorProperties.IncludeAttribute.NEVER) {
            factory.addContextCustomizers(context -> {
                ErrorReportValve valve = new ErrorReportValve();
                valve.setShowServerInfo(false);
                valve.setShowReport(false);
                context.getParent().getPipeline().addValve((Valve)valve);
            });
        }
    }
}

